/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.server.agentexecution;

import io.a2a.server.ServerCallContext;
import io.a2a.spec.InvalidParamsError;
import io.a2a.spec.Message;
import io.a2a.spec.MessageSendConfiguration;
import io.a2a.spec.MessageSendParams;
import io.a2a.spec.Part;
import io.a2a.spec.Task;
import io.a2a.spec.TextPart;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;

public class RequestContext {
    private final @Nullable MessageSendParams params;
    private final String taskId;
    private final String contextId;
    private final @Nullable Task task;
    private final List<Task> relatedTasks;
    private final @Nullable ServerCallContext callContext;

    private RequestContext(@Nullable MessageSendParams params, String taskId, String contextId, @Nullable Task task, List<Task> relatedTasks, @Nullable ServerCallContext callContext) {
        this.params = params;
        this.taskId = taskId;
        this.contextId = contextId;
        this.task = task;
        this.relatedTasks = relatedTasks;
        this.callContext = callContext;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getContextId() {
        return this.contextId;
    }

    public @Nullable Task getTask() {
        return this.task;
    }

    public List<Task> getRelatedTasks() {
        return Collections.unmodifiableList(this.relatedTasks);
    }

    public @Nullable Message getMessage() {
        return this.params != null ? this.params.message() : null;
    }

    public @Nullable MessageSendConfiguration getConfiguration() {
        return this.params != null ? this.params.configuration() : null;
    }

    public @Nullable ServerCallContext getCallContext() {
        return this.callContext;
    }

    public @Nullable String getTenant() {
        return this.params != null ? this.params.tenant() : null;
    }

    public String getUserInput(String delimiter) {
        if (this.params == null) {
            return "";
        }
        if (delimiter == null) {
            delimiter = "\n";
        }
        return this.getMessageText(this.params.message(), delimiter);
    }

    public void attachRelatedTask(Task task) {
        this.relatedTasks.add(task);
    }

    private String getMessageText(Message message, String delimiter) {
        List<String> textParts = this.getTextParts(message.parts());
        return String.join((CharSequence)delimiter, textParts);
    }

    private List<String> getTextParts(List<Part<?>> parts) {
        return parts.stream().filter(part -> part instanceof TextPart).map(part -> (TextPart)part).map(TextPart::text).collect(Collectors.toList());
    }

    public static class Builder {
        private @Nullable MessageSendParams params;
        private @Nullable String taskId;
        private @Nullable String contextId;
        private @Nullable Task task;
        private @Nullable List<Task> relatedTasks;
        private @Nullable ServerCallContext serverCallContext;

        public Builder setParams(@Nullable MessageSendParams params) {
            this.params = params;
            return this;
        }

        public Builder setTaskId(@Nullable String taskId) {
            this.taskId = taskId;
            return this;
        }

        public Builder setContextId(@Nullable String contextId) {
            this.contextId = contextId;
            return this;
        }

        public Builder setTask(@Nullable Task task) {
            this.task = task;
            return this;
        }

        public Builder setRelatedTasks(@Nullable List<Task> relatedTasks) {
            this.relatedTasks = relatedTasks;
            return this;
        }

        public Builder setServerCallContext(@Nullable ServerCallContext serverCallContext) {
            this.serverCallContext = serverCallContext;
            return this;
        }

        public @Nullable MessageSendParams getParams() {
            return this.params;
        }

        public @Nullable String getTaskId() {
            return this.taskId;
        }

        public @Nullable String getContextId() {
            return this.contextId;
        }

        public @Nullable Task getTask() {
            return this.task;
        }

        public @Nullable List<Task> getRelatedTasks() {
            return this.relatedTasks;
        }

        public @Nullable ServerCallContext getServerCallContext() {
            return this.serverCallContext;
        }

        public RequestContext build() throws InvalidParamsError {
            String finalTaskId;
            String messageContextId;
            ArrayList<Task> finalRelatedTasks = this.relatedTasks != null ? this.relatedTasks : new ArrayList<Task>();
            String messageTaskId = this.params != null ? this.params.message().taskId() : null;
            String string = messageContextId = this.params != null ? this.params.message().contextId() : null;
            if (this.taskId != null && messageTaskId != null && !this.taskId.equals(messageTaskId)) {
                throw new InvalidParamsError("bad task id");
            }
            if (this.contextId != null && messageContextId != null && !this.contextId.equals(messageContextId)) {
                throw new InvalidParamsError("bad context id");
            }
            String string2 = this.taskId != null ? this.taskId : (finalTaskId = messageTaskId != null ? messageTaskId : UUID.randomUUID().toString());
            String finalContextId = this.contextId != null ? this.contextId : (messageContextId != null ? messageContextId : UUID.randomUUID().toString());
            MessageSendParams finalParams = this.params;
            if (!(this.params == null || finalTaskId.equals(messageTaskId) && finalContextId.equals(messageContextId))) {
                Message updatedMessage = Message.builder((Message)this.params.message()).taskId(finalTaskId).contextId(finalContextId).build();
                finalParams = MessageSendParams.builder().message(updatedMessage).configuration(this.params.configuration()).metadata(this.params.metadata()).tenant(this.params.tenant()).build();
            }
            return new RequestContext(finalParams, finalTaskId, finalContextId, this.task, finalRelatedTasks, this.serverCallContext);
        }
    }
}

