/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.server.tasks;

import io.a2a.jsonrpc.common.wrappers.ListTasksResult;
import io.a2a.server.tasks.TaskStateProvider;
import io.a2a.server.tasks.TaskStore;
import io.a2a.spec.ListTasksParams;
import io.a2a.spec.Task;
import io.a2a.util.PageToken;
import jakarta.enterprise.context.ApplicationScoped;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jspecify.annotations.Nullable;

@ApplicationScoped
public class InMemoryTaskStore
implements TaskStore,
TaskStateProvider {
    private final ConcurrentMap<String, Task> tasks = new ConcurrentHashMap<String, Task>();

    @Override
    public void save(Task task, boolean isReplicated) {
        this.tasks.put(task.id(), task);
    }

    @Override
    public @Nullable Task get(String taskId) {
        return (Task)this.tasks.get(taskId);
    }

    @Override
    public void delete(String taskId) {
        this.tasks.remove(taskId);
    }

    @Override
    public ListTasksResult list(ListTasksParams params) {
        List<Task> allFilteredTasks = this.tasks.values().stream().filter(task -> params.contextId() == null || params.contextId().equals(task.contextId())).filter(task -> params.status() == null || task.status() != null && params.status().equals((Object)task.status().state())).filter(task -> params.statusTimestampAfter() == null || task.status() != null && task.status().timestamp() != null && task.status().timestamp().toInstant().isAfter(params.statusTimestampAfter())).sorted(Comparator.comparing(t -> t.status() != null && t.status().timestamp() != null ? t.status().timestamp().toInstant().truncatedTo(ChronoUnit.MILLIS) : null, Comparator.nullsLast(Comparator.reverseOrder())).thenComparing(Task::id)).toList();
        int totalSize = allFilteredTasks.size();
        int pageSize = params.getEffectivePageSize();
        int startIndex = 0;
        PageToken pageToken = PageToken.fromString((String)params.pageToken());
        if (pageToken != null) {
            Instant tokenTimestamp = pageToken.timestamp();
            String tokenId = pageToken.id();
            int left = 0;
            int right = allFilteredTasks.size();
            while (left < right) {
                Instant taskTimestamp;
                int mid = left + (right - left) / 2;
                Task task2 = allFilteredTasks.get(mid);
                Instant instant = taskTimestamp = task2.status() != null && task2.status().timestamp() != null ? task2.status().timestamp().toInstant().truncatedTo(ChronoUnit.MILLIS) : null;
                if (taskTimestamp == null) {
                    left = mid + 1;
                    continue;
                }
                int timestampCompare = taskTimestamp.compareTo(tokenTimestamp);
                if (timestampCompare < 0 || timestampCompare == 0 && task2.id().compareTo(tokenId) > 0) {
                    right = mid;
                    continue;
                }
                left = mid + 1;
            }
            startIndex = left;
        }
        int endIndex = Math.min(startIndex + pageSize, allFilteredTasks.size());
        List<Task> pageTasks = allFilteredTasks.subList(startIndex, endIndex);
        String nextPageToken = null;
        if (endIndex < allFilteredTasks.size()) {
            Task lastTask = allFilteredTasks.get(endIndex - 1);
            Instant timestamp = lastTask.status().timestamp().toInstant();
            nextPageToken = new PageToken(timestamp, lastTask.id()).toString();
        }
        int historyLength = params.getEffectiveHistoryLength();
        boolean includeArtifacts = params.shouldIncludeArtifacts();
        List<Task> transformedTasks = pageTasks.stream().map(task -> this.transformTask((Task)task, historyLength, includeArtifacts)).toList();
        return new ListTasksResult(transformedTasks, totalSize, transformedTasks.size(), nextPageToken);
    }

    private Task transformTask(Task task, int historyLength, boolean includeArtifacts) {
        List artifacts;
        List history = task.history();
        if (historyLength == 0) {
            history = List.of();
        } else if (historyLength > 0 && history != null && history.size() > historyLength) {
            history = history.subList(history.size() - historyLength, history.size());
        }
        List list = artifacts = includeArtifacts ? task.artifacts() : List.of();
        if (history == task.history() && artifacts == task.artifacts()) {
            return task;
        }
        return Task.builder((Task)task).artifacts(artifacts).history(history).build();
    }

    @Override
    public boolean isTaskActive(String taskId) {
        Task task = (Task)this.tasks.get(taskId);
        if (task == null) {
            return false;
        }
        return task.status() == null || task.status().state() == null || !task.status().state().isFinal();
    }

    @Override
    public boolean isTaskFinalized(String taskId) {
        Task task = (Task)this.tasks.get(taskId);
        if (task == null) {
            return false;
        }
        return task.status() != null && task.status().state() != null && task.status().state().isFinal();
    }
}

