/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.server.events;

import io.a2a.server.events.EventQueue;
import io.a2a.server.events.EventQueueItem;
import io.a2a.server.events.MainEventBusContext;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class MainEventBus {
    private static final Logger LOGGER = LoggerFactory.getLogger(MainEventBus.class);
    private final BlockingQueue<MainEventBusContext> queue = new LinkedBlockingDeque<MainEventBusContext>();

    void submit(String taskId, EventQueue.MainQueue mainQueue, EventQueueItem item) {
        try {
            this.queue.put(new MainEventBusContext(taskId, mainQueue, item));
            LOGGER.debug("Submitted event for task {} to MainEventBus (queue size: {})", (Object)taskId, (Object)this.queue.size());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted submitting to MainEventBus", e);
        }
    }

    MainEventBusContext take() throws InterruptedException {
        LOGGER.debug("MainEventBus: Waiting to take event (current queue size: {})...", (Object)this.queue.size());
        MainEventBusContext context = this.queue.take();
        LOGGER.debug("MainEventBus: Took event for task {} (remaining queue size: {})", (Object)context.taskId(), (Object)this.queue.size());
        return context;
    }

    public int size() {
        return this.queue.size();
    }
}

