/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.server.events;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jspecify.annotations.Nullable;

public abstract class EnhancedRunnable
implements Runnable {
    private volatile @Nullable Throwable error;
    private final List<DoneCallback> doneCallbacks = new CopyOnWriteArrayList<DoneCallback>();
    private final AtomicBoolean started = new AtomicBoolean(false);

    public @Nullable Throwable getError() {
        return this.error;
    }

    public void setError(Throwable error) {
        this.error = error;
    }

    public void addDoneCallback(DoneCallback doneCallback) {
        if (this.started.get()) {
            throw new IllegalStateException("Cannot add callback after runnable has started execution. Callbacks must be registered before CompletableFuture.runAsync() is called.");
        }
        this.doneCallbacks.add(doneCallback);
    }

    public void markStarted() {
        this.started.set(true);
    }

    public void invokeDoneCallbacks() {
        for (DoneCallback doneCallback : this.doneCallbacks) {
            doneCallback.done(this);
        }
    }

    public static interface DoneCallback {
        public void done(EnhancedRunnable var1);
    }
}

