/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.server.version;

import io.a2a.server.ServerCallContext;
import io.a2a.spec.AgentCard;
import io.a2a.spec.VersionNotSupportedError;

public class A2AVersionValidator {
    public static void validateProtocolVersion(AgentCard agentCard, ServerCallContext context) throws VersionNotSupportedError {
        String supportedVersion;
        String requestedVersion = context.getRequestedProtocolVersion();
        if (requestedVersion == null || requestedVersion.trim().isEmpty()) {
            requestedVersion = "1.0";
        }
        if (!A2AVersionValidator.isVersionCompatible(supportedVersion = agentCard.protocolVersion(), requestedVersion)) {
            throw new VersionNotSupportedError(null, "Protocol version '" + requestedVersion + "' is not supported. Supported version: " + supportedVersion, null);
        }
    }

    static boolean isVersionCompatible(String supported, String requested) {
        try {
            VersionParts supportedParts = A2AVersionValidator.parseVersion(supported);
            VersionParts requestedParts = A2AVersionValidator.parseVersion(requested);
            return supportedParts.major == requestedParts.major;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private static VersionParts parseVersion(String version) {
        if (version == null || version.trim().isEmpty()) {
            throw new IllegalArgumentException("Version cannot be null or empty");
        }
        String[] parts = version.split("\\.");
        if (parts.length < 2) {
            throw new IllegalArgumentException("Version must have at least major.minor format: " + version);
        }
        try {
            int major = Integer.parseInt(parts[0]);
            int minor = Integer.parseInt(parts[1]);
            return new VersionParts(major, minor);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid version format: " + version, e);
        }
    }

    private record VersionParts(int major, int minor) {
    }
}

