/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.server.tasks;

import io.a2a.server.tasks.PushNotificationConfigStore;
import io.a2a.spec.ListTaskPushNotificationConfigParams;
import io.a2a.spec.ListTaskPushNotificationConfigResult;
import io.a2a.spec.PushNotificationConfig;
import io.a2a.spec.TaskPushNotificationConfig;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@ApplicationScoped
public class InMemoryPushNotificationConfigStore
implements PushNotificationConfigStore {
    private final Map<String, List<PushNotificationConfig>> pushNotificationInfos = Collections.synchronizedMap(new HashMap());

    @Inject
    public InMemoryPushNotificationConfigStore() {
    }

    @Override
    public PushNotificationConfig setInfo(String taskId, PushNotificationConfig notificationConfig) {
        List notificationConfigList = this.pushNotificationInfos.getOrDefault(taskId, new ArrayList());
        PushNotificationConfig.Builder builder = PushNotificationConfig.builder((PushNotificationConfig)notificationConfig);
        if (notificationConfig.id() == null || notificationConfig.id().isEmpty()) {
            builder.id(taskId);
        }
        notificationConfig = builder.build();
        Iterator notificationConfigIterator = notificationConfigList.iterator();
        while (notificationConfigIterator.hasNext()) {
            PushNotificationConfig config = (PushNotificationConfig)notificationConfigIterator.next();
            if (!config.id().equals(notificationConfig.id())) continue;
            notificationConfigIterator.remove();
            break;
        }
        notificationConfigList.add(notificationConfig);
        this.pushNotificationInfos.put(taskId, notificationConfigList);
        return notificationConfig;
    }

    @Override
    public ListTaskPushNotificationConfigResult getInfo(ListTaskPushNotificationConfigParams params) {
        int index;
        List<PushNotificationConfig> configs = this.pushNotificationInfos.get(params.id());
        if (configs == null) {
            return new ListTaskPushNotificationConfigResult(Collections.emptyList());
        }
        if (params.pageSize() <= 0) {
            return new ListTaskPushNotificationConfigResult(this.convertPushNotificationConfig(configs, params), null);
        }
        if (params.pageToken() != null && !params.pageToken().isBlank() && (index = this.findFirstIndex(configs, params.pageToken())) < configs.size()) {
            configs = configs.subList(index, configs.size());
        }
        if (configs.size() <= params.pageSize()) {
            return new ListTaskPushNotificationConfigResult(this.convertPushNotificationConfig(configs, params), null);
        }
        String newToken = configs.get(params.pageSize()).id();
        return new ListTaskPushNotificationConfigResult(this.convertPushNotificationConfig(configs.subList(0, params.pageSize()), params), newToken);
    }

    private int findFirstIndex(List<PushNotificationConfig> configs, String id) {
        Iterator<PushNotificationConfig> iter = configs.iterator();
        int index = 0;
        while (iter.hasNext()) {
            if (id.equals(iter.next().id())) {
                return index;
            }
            ++index;
        }
        return index;
    }

    private List<TaskPushNotificationConfig> convertPushNotificationConfig(List<PushNotificationConfig> pushNotificationConfigList, ListTaskPushNotificationConfigParams params) {
        ArrayList<TaskPushNotificationConfig> taskPushNotificationConfigList = new ArrayList<TaskPushNotificationConfig>(pushNotificationConfigList.size());
        for (PushNotificationConfig pushNotificationConfig : pushNotificationConfigList) {
            TaskPushNotificationConfig taskPushNotificationConfig = new TaskPushNotificationConfig(params.id(), pushNotificationConfig, params.tenant());
            taskPushNotificationConfigList.add(taskPushNotificationConfig);
        }
        return taskPushNotificationConfigList;
    }

    @Override
    public void deleteInfo(String taskId, String configId) {
        List<PushNotificationConfig> notificationConfigList;
        if (configId == null) {
            configId = taskId;
        }
        if ((notificationConfigList = this.pushNotificationInfos.get(taskId)) == null || notificationConfigList.isEmpty()) {
            return;
        }
        Iterator<PushNotificationConfig> notificationConfigIterator = notificationConfigList.iterator();
        while (notificationConfigIterator.hasNext()) {
            PushNotificationConfig config = notificationConfigIterator.next();
            if (!configId.equals(config.id())) continue;
            notificationConfigIterator.remove();
            break;
        }
        if (notificationConfigList.isEmpty()) {
            this.pushNotificationInfos.remove(taskId);
        }
    }
}

