/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.extras.opentelemetry;

import io.a2a.jsonrpc.common.wrappers.ListTasksResult;
import io.a2a.server.ServerCallContext;
import io.a2a.server.requesthandlers.RequestHandler;
import io.a2a.spec.A2AError;
import io.a2a.spec.DeleteTaskPushNotificationConfigParams;
import io.a2a.spec.EventKind;
import io.a2a.spec.GetTaskPushNotificationConfigParams;
import io.a2a.spec.ListTaskPushNotificationConfigParams;
import io.a2a.spec.ListTaskPushNotificationConfigResult;
import io.a2a.spec.ListTasksParams;
import io.a2a.spec.MessageSendParams;
import io.a2a.spec.StreamingEventKind;
import io.a2a.spec.Task;
import io.a2a.spec.TaskIdParams;
import io.a2a.spec.TaskPushNotificationConfig;
import io.a2a.spec.TaskQueryParams;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Scope;
import jakarta.annotation.Priority;
import jakarta.decorator.Decorator;
import jakarta.decorator.Delegate;
import jakarta.enterprise.inject.Any;
import jakarta.inject.Inject;
import java.util.concurrent.Flow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Decorator
@Priority(value=100)
public abstract class OpenTelemetryRequestHandlerDecorator
implements RequestHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenTelemetryRequestHandlerDecorator.class);
    @Inject
    @Delegate
    @Any
    private RequestHandler delegate;
    @Inject
    private Tracer tracer;

    public OpenTelemetryRequestHandlerDecorator() {
    }

    public OpenTelemetryRequestHandlerDecorator(RequestHandler delegate, Tracer tracer) {
        this.delegate = delegate;
        this.tracer = tracer;
    }

    public Task onGetTask(TaskQueryParams params, ServerCallContext context) throws A2AError {
        SpanBuilder spanBuilder = this.tracer.spanBuilder("GetTask").setSpanKind(SpanKind.SERVER).setAttribute("gen_ai.agent.a2a.operation.name", "GetTask");
        if (params.id() != null) {
            spanBuilder.setAttribute("gen_ai.agent.a2a.task_id", params.id());
        }
        if (this.extractRequest()) {
            spanBuilder.setAttribute("gen_ai.agent.a2a.request", params.toString());
        }
        Span span = spanBuilder.startSpan();
        try {
            Task task;
            block14: {
                Scope scope = span.makeCurrent();
                try {
                    Task result = this.delegate.onGetTask(params, context);
                    if (result != null && this.extractResponse()) {
                        span.setAttribute("gen_ai.agent.a2a.response", result.toString());
                    }
                    span.setStatus(StatusCode.OK);
                    task = result;
                    if (scope == null) break block14;
                }
                catch (Throwable throwable) {
                    try {
                        if (scope != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (A2AError error) {
                        span.setAttribute("error.type", error.getMessage());
                        span.setStatus(StatusCode.ERROR, error.getMessage());
                        throw error;
                    }
                }
                scope.close();
            }
            return task;
        }
        finally {
            span.end();
        }
    }

    public ListTasksResult onListTasks(ListTasksParams params, ServerCallContext context) throws A2AError {
        SpanBuilder spanBuilder = this.tracer.spanBuilder("ListTasks").setSpanKind(SpanKind.SERVER).setAttribute("gen_ai.agent.a2a.operation.name", "ListTasks");
        if (this.extractRequest()) {
            spanBuilder.setAttribute("gen_ai.agent.a2a.request", params.toString());
        }
        if (params.contextId() != null) {
            spanBuilder.setAttribute("gen_ai.agent.a2a.context_id", params.contextId());
        }
        Span span = spanBuilder.startSpan();
        try {
            ListTasksResult listTasksResult;
            block14: {
                Scope scope = span.makeCurrent();
                try {
                    ListTasksResult result = this.delegate.onListTasks(params, context);
                    if (result != null && this.extractResponse()) {
                        span.setAttribute("gen_ai.agent.a2a.response", result.toString());
                    }
                    span.setStatus(StatusCode.OK);
                    listTasksResult = result;
                    if (scope == null) break block14;
                }
                catch (Throwable throwable) {
                    try {
                        if (scope != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (A2AError error) {
                        span.setAttribute("error.type", error.getMessage());
                        span.setStatus(StatusCode.ERROR, error.getMessage());
                        throw error;
                    }
                }
                scope.close();
            }
            return listTasksResult;
        }
        finally {
            span.end();
        }
    }

    public Task onCancelTask(TaskIdParams params, ServerCallContext context) throws A2AError {
        SpanBuilder spanBuilder = this.tracer.spanBuilder("CancelTask").setSpanKind(SpanKind.SERVER).setAttribute("gen_ai.agent.a2a.operation.name", "CancelTask");
        if (params.id() != null) {
            spanBuilder.setAttribute("gen_ai.agent.a2a.task_id", params.id());
        }
        if (this.extractRequest()) {
            spanBuilder.setAttribute("gen_ai.agent.a2a.request", params.toString());
        }
        Span span = spanBuilder.startSpan();
        try {
            Task task;
            block14: {
                Scope scope = span.makeCurrent();
                try {
                    Task result = this.delegate.onCancelTask(params, context);
                    if (result != null && this.extractResponse()) {
                        span.setAttribute("gen_ai.agent.a2a.response", result.toString());
                    }
                    span.setStatus(StatusCode.OK);
                    task = result;
                    if (scope == null) break block14;
                }
                catch (Throwable throwable) {
                    try {
                        if (scope != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (A2AError error) {
                        span.setAttribute("error.type", error.getMessage());
                        span.setStatus(StatusCode.ERROR, error.getMessage());
                        throw error;
                    }
                }
                scope.close();
            }
            return task;
        }
        finally {
            span.end();
        }
    }

    public EventKind onMessageSend(MessageSendParams params, ServerCallContext context) throws A2AError {
        SpanBuilder spanBuilder = this.tracer.spanBuilder("SendMessage").setSpanKind(SpanKind.SERVER).setAttribute("gen_ai.agent.a2a.operation.name", "SendMessage");
        if (params.message() != null) {
            if (params.message().taskId() != null) {
                spanBuilder.setAttribute("gen_ai.agent.a2a.task_id", params.message().taskId());
            }
            if (params.message().contextId() != null) {
                spanBuilder.setAttribute("gen_ai.agent.a2a.context_id", params.message().contextId());
            }
            if (params.message().messageId() != null) {
                spanBuilder.setAttribute("gen_ai.agent.a2a.message_id", params.message().messageId());
            }
            if (params.message().role() != null) {
                spanBuilder.setAttribute("gen_ai.agent.a2a.role", params.message().role().name());
            }
            if (params.message().extensions() != null && !params.message().extensions().isEmpty()) {
                spanBuilder.setAttribute("gen_ai.agent.a2a.extensions", String.join((CharSequence)",", params.message().extensions()));
            }
            spanBuilder.setAttribute("gen_ai.agent.a2a.parts.number", (long)params.message().parts().size());
        }
        if (this.extractRequest()) {
            spanBuilder.setAttribute("gen_ai.agent.a2a.request", params.toString());
        }
        Span span = spanBuilder.startSpan();
        try {
            EventKind eventKind;
            block19: {
                Scope scope = span.makeCurrent();
                try {
                    EventKind result = this.delegate.onMessageSend(params, context);
                    if (result != null && this.extractResponse()) {
                        span.setAttribute("gen_ai.agent.a2a.response", result.toString());
                    }
                    span.setStatus(StatusCode.OK);
                    eventKind = result;
                    if (scope == null) break block19;
                }
                catch (Throwable throwable) {
                    try {
                        if (scope != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (A2AError error) {
                        span.setAttribute("error.type", error.getMessage());
                        span.setStatus(StatusCode.ERROR, error.getMessage());
                        throw error;
                    }
                }
                scope.close();
            }
            return eventKind;
        }
        finally {
            span.end();
        }
    }

    public Flow.Publisher<StreamingEventKind> onMessageSendStream(MessageSendParams params, ServerCallContext context) throws A2AError {
        SpanBuilder spanBuilder = this.tracer.spanBuilder("SendStreamingMessage").setSpanKind(SpanKind.SERVER).setAttribute("gen_ai.agent.a2a.operation.name", "SendStreamingMessage");
        if (params.message() != null) {
            if (params.message().taskId() != null) {
                spanBuilder.setAttribute("gen_ai.agent.a2a.task_id", params.message().taskId());
            }
            if (params.message().contextId() != null) {
                spanBuilder.setAttribute("gen_ai.agent.a2a.context_id", params.message().contextId());
            }
            if (params.message().messageId() != null) {
                spanBuilder.setAttribute("gen_ai.agent.a2a.message_id", params.message().messageId());
            }
            if (params.message().role() != null) {
                spanBuilder.setAttribute("gen_ai.agent.a2a.role", params.message().role().name());
            }
            if (params.message().extensions() != null && !params.message().extensions().isEmpty()) {
                spanBuilder.setAttribute("gen_ai.agent.a2a.extensions", String.join((CharSequence)",", params.message().extensions()));
            }
            spanBuilder.setAttribute("gen_ai.agent.a2a.parts.number", (long)params.message().parts().size());
        }
        if (this.extractRequest()) {
            spanBuilder.setAttribute("gen_ai.agent.a2a.request", params.toString());
        }
        Span span = spanBuilder.startSpan();
        try {
            Flow.Publisher publisher;
            block19: {
                Scope scope = span.makeCurrent();
                try {
                    Flow.Publisher result = this.delegate.onMessageSendStream(params, context);
                    if (this.extractResponse()) {
                        span.setAttribute("gen_ai.agent.a2a.response", "Stream publisher created");
                    }
                    span.setStatus(StatusCode.OK);
                    publisher = result;
                    if (scope == null) break block19;
                }
                catch (Throwable throwable) {
                    try {
                        if (scope != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (A2AError error) {
                        span.setAttribute("error.type", error.getMessage());
                        span.setStatus(StatusCode.ERROR, error.getMessage());
                        throw error;
                    }
                }
                scope.close();
            }
            return publisher;
        }
        finally {
            span.end();
        }
    }

    public TaskPushNotificationConfig onCreateTaskPushNotificationConfig(TaskPushNotificationConfig params, ServerCallContext context) throws A2AError {
        SpanBuilder spanBuilder = this.tracer.spanBuilder("CreateTaskPushNotificationConfig").setSpanKind(SpanKind.SERVER).setAttribute("gen_ai.agent.a2a.operation.name", "CreateTaskPushNotificationConfig");
        if (params.taskId() != null) {
            spanBuilder.setAttribute("gen_ai.agent.a2a.task_id", params.taskId());
        }
        if (params.config() != null && params.config().id() != null) {
            spanBuilder.setAttribute("gen_ai.agent.a2a.config_id", params.config().id());
        }
        if (this.extractRequest()) {
            spanBuilder.setAttribute("gen_ai.agent.a2a.request", params.toString());
        }
        Span span = spanBuilder.startSpan();
        try {
            TaskPushNotificationConfig taskPushNotificationConfig;
            block15: {
                Scope scope = span.makeCurrent();
                try {
                    TaskPushNotificationConfig result = this.delegate.onCreateTaskPushNotificationConfig(params, context);
                    if (result != null && this.extractResponse()) {
                        span.setAttribute("gen_ai.agent.a2a.response", result.toString());
                    }
                    span.setStatus(StatusCode.OK);
                    taskPushNotificationConfig = result;
                    if (scope == null) break block15;
                }
                catch (Throwable throwable) {
                    try {
                        if (scope != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (A2AError error) {
                        span.setAttribute("error.type", error.getMessage());
                        span.setStatus(StatusCode.ERROR, error.getMessage());
                        throw error;
                    }
                }
                scope.close();
            }
            return taskPushNotificationConfig;
        }
        finally {
            span.end();
        }
    }

    public TaskPushNotificationConfig onGetTaskPushNotificationConfig(GetTaskPushNotificationConfigParams params, ServerCallContext context) throws A2AError {
        SpanBuilder spanBuilder = this.tracer.spanBuilder("GetTaskPushNotificationConfig").setSpanKind(SpanKind.SERVER).setAttribute("gen_ai.agent.a2a.operation.name", "GetTaskPushNotificationConfig");
        if (params.taskId() != null) {
            spanBuilder.setAttribute("gen_ai.agent.a2a.task_id", params.taskId());
        }
        if (params.id() != null) {
            spanBuilder.setAttribute("gen_ai.agent.a2a.config_id", params.id());
        }
        if (this.extractRequest()) {
            spanBuilder.setAttribute("gen_ai.agent.a2a.request", params.toString());
        }
        Span span = spanBuilder.startSpan();
        try {
            TaskPushNotificationConfig taskPushNotificationConfig;
            block15: {
                Scope scope = span.makeCurrent();
                try {
                    TaskPushNotificationConfig result = this.delegate.onGetTaskPushNotificationConfig(params, context);
                    if (result != null && this.extractResponse()) {
                        span.setAttribute("gen_ai.agent.a2a.response", result.toString());
                    }
                    span.setStatus(StatusCode.OK);
                    taskPushNotificationConfig = result;
                    if (scope == null) break block15;
                }
                catch (Throwable throwable) {
                    try {
                        if (scope != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (A2AError error) {
                        span.setAttribute("error.type", error.getMessage());
                        span.setStatus(StatusCode.ERROR, error.getMessage());
                        throw error;
                    }
                }
                scope.close();
            }
            return taskPushNotificationConfig;
        }
        finally {
            span.end();
        }
    }

    public Flow.Publisher<StreamingEventKind> onSubscribeToTask(TaskIdParams params, ServerCallContext context) throws A2AError {
        SpanBuilder spanBuilder = this.tracer.spanBuilder("SubscribeToTask").setSpanKind(SpanKind.SERVER).setAttribute("gen_ai.agent.a2a.operation.name", "SubscribeToTask");
        if (params.id() != null) {
            spanBuilder.setAttribute("gen_ai.agent.a2a.task_id", params.id());
        }
        if (this.extractRequest()) {
            spanBuilder.setAttribute("gen_ai.agent.a2a.request", params.toString());
        }
        Span span = spanBuilder.startSpan();
        try {
            Flow.Publisher publisher;
            block14: {
                Scope scope = span.makeCurrent();
                try {
                    Flow.Publisher result = this.delegate.onSubscribeToTask(params, context);
                    if (this.extractResponse()) {
                        span.setAttribute("gen_ai.agent.a2a.response", "Stream publisher created");
                    }
                    span.setStatus(StatusCode.OK);
                    publisher = result;
                    if (scope == null) break block14;
                }
                catch (Throwable throwable) {
                    try {
                        if (scope != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (A2AError error) {
                        span.setAttribute("error.type", error.getMessage());
                        span.setStatus(StatusCode.ERROR, error.getMessage());
                        throw error;
                    }
                }
                scope.close();
            }
            return publisher;
        }
        finally {
            span.end();
        }
    }

    public ListTaskPushNotificationConfigResult onListTaskPushNotificationConfig(ListTaskPushNotificationConfigParams params, ServerCallContext context) throws A2AError {
        SpanBuilder spanBuilder = this.tracer.spanBuilder("ListTaskPushNotificationConfig").setSpanKind(SpanKind.SERVER).setAttribute("gen_ai.agent.a2a.operation.name", "ListTaskPushNotificationConfig");
        if (this.extractRequest()) {
            spanBuilder.setAttribute("gen_ai.agent.a2a.request", params.toString());
        }
        if (params.id() != null) {
            spanBuilder.setAttribute("gen_ai.agent.a2a.task_id", params.id());
        }
        Span span = spanBuilder.startSpan();
        try {
            ListTaskPushNotificationConfigResult listTaskPushNotificationConfigResult;
            block14: {
                Scope scope = span.makeCurrent();
                try {
                    ListTaskPushNotificationConfigResult result = this.delegate.onListTaskPushNotificationConfig(params, context);
                    if (result != null && this.extractResponse()) {
                        span.setAttribute("gen_ai.agent.a2a.response", result.toString());
                    }
                    span.setStatus(StatusCode.OK);
                    listTaskPushNotificationConfigResult = result;
                    if (scope == null) break block14;
                }
                catch (Throwable throwable) {
                    try {
                        if (scope != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (A2AError error) {
                        span.setAttribute("error.type", error.getMessage());
                        span.setStatus(StatusCode.ERROR, error.getMessage());
                        throw error;
                    }
                }
                scope.close();
            }
            return listTaskPushNotificationConfigResult;
        }
        finally {
            span.end();
        }
    }

    public void onDeleteTaskPushNotificationConfig(DeleteTaskPushNotificationConfigParams params, ServerCallContext context) throws A2AError {
        SpanBuilder spanBuilder = this.tracer.spanBuilder("DeleteTaskPushNotificationConfig").setSpanKind(SpanKind.SERVER).setAttribute("gen_ai.agent.a2a.operation.name", "DeleteTaskPushNotificationConfig");
        if (this.extractRequest()) {
            spanBuilder.setAttribute("gen_ai.agent.a2a.request", params.toString());
        }
        if (params.taskId() != null) {
            spanBuilder.setAttribute("gen_ai.agent.a2a.task_id", params.taskId());
        }
        Span span = spanBuilder.startSpan();
        try (Scope scope = span.makeCurrent();){
            this.delegate.onDeleteTaskPushNotificationConfig(params, context);
            span.setStatus(StatusCode.OK);
        }
        catch (A2AError error) {
            span.setAttribute("error.type", error.getMessage());
            span.setStatus(StatusCode.ERROR, error.getMessage());
            throw error;
        }
        finally {
            span.end();
        }
    }

    private boolean extractRequest() {
        return Boolean.getBoolean("io.a2a.server.extract.request");
    }

    private boolean extractResponse() {
        return Boolean.getBoolean("io.a2a.server.extract.response");
    }
}

