/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.jsonrpc.common.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.google.gson.ToNumberPolicy;
import com.google.gson.ToNumberStrategy;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import io.a2a.jsonrpc.common.json.JsonProcessingException;
import io.a2a.spec.A2AError;
import io.a2a.spec.APIKeySecurityScheme;
import io.a2a.spec.ContentTypeNotSupportedError;
import io.a2a.spec.DataPart;
import io.a2a.spec.FileContent;
import io.a2a.spec.FilePart;
import io.a2a.spec.FileWithBytes;
import io.a2a.spec.FileWithUri;
import io.a2a.spec.HTTPAuthSecurityScheme;
import io.a2a.spec.InternalError;
import io.a2a.spec.InvalidAgentResponseError;
import io.a2a.spec.InvalidParamsError;
import io.a2a.spec.InvalidRequestError;
import io.a2a.spec.JSONParseError;
import io.a2a.spec.Message;
import io.a2a.spec.MethodNotFoundError;
import io.a2a.spec.MutualTLSSecurityScheme;
import io.a2a.spec.OAuth2SecurityScheme;
import io.a2a.spec.OpenIdConnectSecurityScheme;
import io.a2a.spec.Part;
import io.a2a.spec.PushNotificationNotSupportedError;
import io.a2a.spec.SecurityRequirement;
import io.a2a.spec.SecurityScheme;
import io.a2a.spec.StreamingEventKind;
import io.a2a.spec.Task;
import io.a2a.spec.TaskArtifactUpdateEvent;
import io.a2a.spec.TaskNotCancelableError;
import io.a2a.spec.TaskNotFoundError;
import io.a2a.spec.TaskStatusUpdateEvent;
import io.a2a.spec.TextPart;
import io.a2a.spec.UnsupportedOperationError;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jspecify.annotations.Nullable;

public class JsonUtil {
    public static final Gson OBJECT_MAPPER = JsonUtil.createBaseGsonBuilder().registerTypeHierarchyAdapter(Part.class, (Object)new PartTypeAdapter()).registerTypeHierarchyAdapter(StreamingEventKind.class, (Object)new StreamingEventKindTypeAdapter()).registerTypeHierarchyAdapter(SecurityScheme.class, (Object)new SecuritySchemeTypeAdapter()).create();

    private static GsonBuilder createBaseGsonBuilder() {
        return new GsonBuilder().setObjectToNumberStrategy((ToNumberStrategy)ToNumberPolicy.LONG_OR_DOUBLE).registerTypeAdapter(OffsetDateTime.class, (Object)new OffsetDateTimeTypeAdapter()).registerTypeAdapter(SecurityRequirement.class, (Object)new SecurityRequirementTypeAdapter()).registerTypeHierarchyAdapter(A2AError.class, (Object)new A2AErrorTypeAdapter()).registerTypeHierarchyAdapter(FileContent.class, (Object)new FileContentTypeAdapter());
    }

    public static <T> T fromJson(String json, Class<T> classOfT) throws JsonProcessingException {
        try {
            return (T)OBJECT_MAPPER.fromJson(json, classOfT);
        }
        catch (JsonSyntaxException e) {
            throw new JsonProcessingException("Failed to parse JSON", e);
        }
    }

    public static <T> T fromJson(String json, Type type) throws JsonProcessingException {
        try {
            return (T)OBJECT_MAPPER.fromJson(json, type);
        }
        catch (JsonSyntaxException e) {
            throw new JsonProcessingException("Failed to parse JSON", e);
        }
    }

    public static String toJson(Object data) throws JsonProcessingException {
        try {
            return OBJECT_MAPPER.toJson(data);
        }
        catch (JsonSyntaxException e) {
            throw new JsonProcessingException("Failed to generate JSON", e);
        }
    }

    static class OffsetDateTimeTypeAdapter
    extends TypeAdapter<OffsetDateTime> {
        OffsetDateTimeTypeAdapter() {
        }

        public void write(JsonWriter out, OffsetDateTime value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                out.value(value.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME));
            }
        }

        public @Nullable OffsetDateTime read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            String dateTimeString = in.nextString();
            try {
                return OffsetDateTime.parse(dateTimeString, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
            }
            catch (DateTimeParseException e) {
                throw new JsonSyntaxException("Failed to parse OffsetDateTime: " + dateTimeString, (Throwable)e);
            }
        }
    }

    static class SecurityRequirementTypeAdapter
    extends TypeAdapter<SecurityRequirement> {
        private static final String SCHEMES_FIELD = "schemes";
        private static final String LIST_FIELD = "list";

        SecurityRequirementTypeAdapter() {
        }

        public void write(JsonWriter out, SecurityRequirement value) throws IOException {
            if (value == null) {
                out.nullValue();
                return;
            }
            out.beginObject();
            out.name(SCHEMES_FIELD);
            Map schemes = value.schemes();
            if (schemes == null || schemes.isEmpty()) {
                out.beginObject();
                out.endObject();
            } else {
                out.beginObject();
                for (Map.Entry entry : schemes.entrySet()) {
                    out.name((String)entry.getKey());
                    out.beginObject();
                    out.name(LIST_FIELD);
                    out.beginArray();
                    List scopes = (List)entry.getValue();
                    if (scopes != null) {
                        for (String scope : scopes) {
                            out.value(scope);
                        }
                    }
                    out.endArray();
                    out.endObject();
                }
                out.endObject();
            }
            out.endObject();
        }

        public @Nullable SecurityRequirement read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            Map<Object, Object> schemes = Collections.emptyMap();
            in.beginObject();
            while (in.hasNext()) {
                String fieldName = in.nextName();
                if (SCHEMES_FIELD.equals(fieldName)) {
                    schemes = this.readSchemesMap(in);
                    continue;
                }
                in.skipValue();
            }
            in.endObject();
            return new SecurityRequirement(schemes);
        }

        private Map<String, List<String>> readSchemesMap(JsonReader in) throws IOException {
            LinkedHashMap<String, List<String>> schemes = new LinkedHashMap<String, List<String>>();
            in.beginObject();
            while (in.hasNext()) {
                String schemeName = in.nextName();
                List<String> scopes = this.readStringList(in);
                schemes.put(schemeName, scopes);
            }
            in.endObject();
            return schemes;
        }

        private List<String> readStringList(JsonReader in) throws IOException {
            ArrayList<String> scopes = new ArrayList<String>();
            in.beginObject();
            while (in.hasNext()) {
                String fieldName = in.nextName();
                if (LIST_FIELD.equals(fieldName)) {
                    in.beginArray();
                    while (in.hasNext()) {
                        scopes.add(in.nextString());
                    }
                    in.endArray();
                    continue;
                }
                in.skipValue();
            }
            in.endObject();
            return scopes;
        }
    }

    static class A2AErrorTypeAdapter
    extends TypeAdapter<A2AError> {
        private static final ThrowableTypeAdapter THROWABLE_ADAPTER = new ThrowableTypeAdapter();
        static final String THROWABLE_MARKER_FIELD = "__throwable";
        private static final String CODE_FIELD = "code";
        private static final String DATA_FIELD = "data";
        private static final String MESSAGE_FIELD = "message";
        private static final String TYPE_FIELD = "type";

        A2AErrorTypeAdapter() {
        }

        public void write(JsonWriter out, A2AError value) throws IOException {
            if (value == null) {
                out.nullValue();
                return;
            }
            out.beginObject();
            out.name(CODE_FIELD).value((Number)value.getCode());
            out.name(MESSAGE_FIELD).value(value.getMessage());
            if (value.getData() != null) {
                out.name(DATA_FIELD);
                Object object = value.getData();
                if (object instanceof Throwable) {
                    Throwable throwable = (Throwable)object;
                    THROWABLE_ADAPTER.write(out, throwable);
                } else {
                    OBJECT_MAPPER.toJson(value.getData(), Object.class, out);
                }
            }
            out.endObject();
        }

        public @Nullable A2AError read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            Integer code = null;
            String message = null;
            Object data = null;
            in.beginObject();
            block10: while (in.hasNext()) {
                String fieldName;
                switch (fieldName = in.nextName()) {
                    case "code": {
                        code = in.nextInt();
                        continue block10;
                    }
                    case "message": {
                        message = in.nextString();
                        continue block10;
                    }
                    case "data": {
                        data = this.readDataValue(in);
                        continue block10;
                    }
                }
                in.skipValue();
            }
            in.endObject();
            return this.createErrorInstance(code, message, data);
        }

        private @Nullable Object readDataValue(JsonReader in) throws IOException {
            return switch (in.peek()) {
                case JsonToken.STRING -> in.nextString();
                case JsonToken.NUMBER -> in.nextDouble();
                case JsonToken.BOOLEAN -> in.nextBoolean();
                case JsonToken.NULL -> {
                    in.nextNull();
                    yield null;
                }
                case JsonToken.BEGIN_OBJECT -> {
                    JsonObject obj;
                    JsonElement element = JsonParser.parseReader((JsonReader)in);
                    if (element.isJsonObject() && (obj = element.getAsJsonObject()).has(TYPE_FIELD) && obj.has(MESSAGE_FIELD) && obj.has(THROWABLE_MARKER_FIELD)) {
                        yield THROWABLE_ADAPTER.read(new JsonReader((Reader)new StringReader(element.toString())));
                    }
                    yield OBJECT_MAPPER.fromJson(element, Object.class);
                }
                case JsonToken.BEGIN_ARRAY -> OBJECT_MAPPER.fromJson(in, Object.class);
                default -> {
                    in.skipValue();
                    yield null;
                }
            };
        }

        private A2AError createErrorInstance(@Nullable Integer code, @Nullable String message, @Nullable Object data) {
            if (code == null) {
                throw new JsonSyntaxException("A2AError must have a code field");
            }
            return switch (code) {
                case -32700 -> new JSONParseError(code, message, data);
                case -32600 -> new InvalidRequestError(code, message, data);
                case -32601 -> new MethodNotFoundError(code, message, data);
                case -32602 -> new InvalidParamsError(code, message, data);
                case -32603 -> new InternalError(code, message, data);
                case -32001 -> new TaskNotFoundError(code, message, data);
                case -32002 -> new TaskNotCancelableError(code, message, data);
                case -32003 -> new PushNotificationNotSupportedError(code, message, data);
                case -32004 -> new UnsupportedOperationError(code, message, data);
                case -32005 -> new ContentTypeNotSupportedError(code, message, data);
                case -32006 -> new InvalidAgentResponseError(code, message, data);
                default -> new A2AError(code, message == null ? "" : message, data);
            };
        }
    }

    static class FileContentTypeAdapter
    extends TypeAdapter<FileContent> {
        private final Gson delegateGson = new GsonBuilder().registerTypeAdapter(OffsetDateTime.class, (Object)new OffsetDateTimeTypeAdapter()).create();

        FileContentTypeAdapter() {
        }

        public void write(JsonWriter out, FileContent value) throws IOException {
            if (value == null) {
                out.nullValue();
                return;
            }
            this.delegateGson.toJson((Object)value, value.getClass(), out);
        }

        public @Nullable FileContent read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            JsonElement jsonElement = JsonParser.parseReader((JsonReader)in);
            if (!jsonElement.isJsonObject()) {
                throw new JsonSyntaxException("FileContent must be a JSON object");
            }
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            if (jsonObject.has("bytes")) {
                return (FileContent)this.delegateGson.fromJson(jsonElement, FileWithBytes.class);
            }
            if (jsonObject.has("uri")) {
                return (FileContent)this.delegateGson.fromJson(jsonElement, FileWithUri.class);
            }
            throw new JsonSyntaxException("FileContent must have either 'bytes' or 'uri' field");
        }
    }

    static class PartTypeAdapter
    extends TypeAdapter<Part<?>> {
        private static final Set<String> VALID_KEYS = Set.of("text", "file", "data");
        private static final Type MAP_TYPE = new TypeToken<Map<String, Object>>(){}.getType();
        private final Gson delegateGson = JsonUtil.createBaseGsonBuilder().create();

        PartTypeAdapter() {
        }

        private void writeMetadata(JsonWriter out, @Nullable Map<String, Object> metadata) throws IOException {
            if (metadata != null && !metadata.isEmpty()) {
                out.name("metadata");
                this.delegateGson.toJson(metadata, MAP_TYPE, out);
            }
        }

        public void write(JsonWriter out, Part<?> value) throws IOException {
            if (value == null) {
                out.nullValue();
                return;
            }
            out.beginObject();
            if (value instanceof TextPart) {
                TextPart textPart = (TextPart)value;
                out.name("text");
                out.value(textPart.text());
                this.writeMetadata(out, textPart.metadata());
            } else if (value instanceof FilePart) {
                FilePart filePart = (FilePart)value;
                out.name("file");
                this.delegateGson.toJson((Object)filePart.file(), FileContent.class, out);
                this.writeMetadata(out, filePart.metadata());
            } else if (value instanceof DataPart) {
                DataPart dataPart = (DataPart)value;
                out.name("data");
                this.delegateGson.toJson(dataPart.data(), Object.class, out);
                this.writeMetadata(out, dataPart.metadata());
            } else {
                throw new JsonSyntaxException("Unknown Part subclass: " + value.getClass().getName());
            }
            out.endObject();
        }

        public @Nullable Part<?> read(JsonReader in) throws IOException {
            String discriminator;
            Set keys;
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            JsonElement jsonElement = JsonParser.parseReader((JsonReader)in);
            if (!jsonElement.isJsonObject()) {
                throw new JsonSyntaxException("Part must be a JSON object");
            }
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            Map metadata = null;
            if (jsonObject.has("metadata")) {
                metadata = (Map)this.delegateGson.fromJson(jsonObject.get("metadata"), new TypeToken<Map<String, Object>>(){}.getType());
            }
            if ((keys = jsonObject.keySet()).size() < 1 || keys.size() > 2) {
                throw new JsonSyntaxException(String.format("Part object must have one content key from %s and optionally 'metadata' (found: %s)", VALID_KEYS, keys));
            }
            return switch (discriminator = keys.stream().filter(VALID_KEYS::contains).findFirst().orElseThrow(() -> new JsonSyntaxException(String.format("Part must have one of: %s (found: %s)", VALID_KEYS, keys)))) {
                case "text" -> new TextPart(jsonObject.get("text").getAsString(), metadata);
                case "file" -> new FilePart((FileContent)this.delegateGson.fromJson(jsonObject.get("file"), FileContent.class), metadata);
                case "data" -> {
                    Object data = this.delegateGson.fromJson(jsonObject.get("data"), Object.class);
                    yield new DataPart(data, metadata);
                }
                default -> throw new JsonSyntaxException(String.format("Part must have one of: %s (found: %s)", VALID_KEYS, discriminator));
            };
        }
    }

    static class StreamingEventKindTypeAdapter
    extends TypeAdapter<StreamingEventKind> {
        private final Gson delegateGson = JsonUtil.createBaseGsonBuilder().registerTypeHierarchyAdapter(Part.class, (Object)new PartTypeAdapter()).create();

        StreamingEventKindTypeAdapter() {
        }

        public void write(JsonWriter out, StreamingEventKind value) throws IOException {
            if (value == null) {
                out.nullValue();
                return;
            }
            out.beginObject();
            out.name(value.kind());
            this.delegateGson.toJson((Object)value, value.getClass(), out);
            out.endObject();
        }

        public @Nullable StreamingEventKind read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            JsonElement jsonElement = JsonParser.parseReader((JsonReader)in);
            if (!jsonElement.isJsonObject()) {
                throw new JsonSyntaxException("StreamingEventKind must be a JSON object");
            }
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            if (jsonObject.has("task")) {
                return (StreamingEventKind)this.delegateGson.fromJson(jsonObject.get("task"), Task.class);
            }
            if (jsonObject.has("message")) {
                return (StreamingEventKind)this.delegateGson.fromJson(jsonObject.get("message"), Message.class);
            }
            if (jsonObject.has("statusUpdate")) {
                return (StreamingEventKind)this.delegateGson.fromJson(jsonObject.get("statusUpdate"), TaskStatusUpdateEvent.class);
            }
            if (jsonObject.has("artifactUpdate")) {
                return (StreamingEventKind)this.delegateGson.fromJson(jsonObject.get("artifactUpdate"), TaskArtifactUpdateEvent.class);
            }
            if (jsonObject.has("role") && jsonObject.has("messageId")) {
                return (StreamingEventKind)this.delegateGson.fromJson((JsonElement)jsonObject, Message.class);
            }
            if (jsonObject.has("id") && jsonObject.has("contextId")) {
                return (StreamingEventKind)this.delegateGson.fromJson((JsonElement)jsonObject, Task.class);
            }
            if (jsonObject.has("taskId") && jsonObject.has("status")) {
                return (StreamingEventKind)this.delegateGson.fromJson((JsonElement)jsonObject, TaskStatusUpdateEvent.class);
            }
            if (jsonObject.has("taskId") && jsonObject.has("artifact")) {
                return (StreamingEventKind)this.delegateGson.fromJson((JsonElement)jsonObject, TaskArtifactUpdateEvent.class);
            }
            throw new JsonSyntaxException("StreamingEventKind must have wrapper (task/message/statusUpdate/artifactUpdate) or recognizable unwrapped fields (found: " + String.valueOf(jsonObject.keySet()) + ")");
        }
    }

    static class SecuritySchemeTypeAdapter
    extends TypeAdapter<SecurityScheme> {
        private static final Set<String> VALID_KEYS = Set.of("apiKeySecurityScheme", "httpAuthSecurityScheme", "oauth2SecurityScheme", "openIdConnectSecurityScheme", "mtlsSecurityScheme");
        private final Gson delegateGson = JsonUtil.createBaseGsonBuilder().registerTypeAdapter(APIKeySecurityScheme.Location.class, (Object)new APIKeyLocationTypeAdapter()).create();

        SecuritySchemeTypeAdapter() {
        }

        public void write(JsonWriter out, SecurityScheme value) throws IOException {
            if (value == null) {
                out.nullValue();
                return;
            }
            out.beginObject();
            out.name(value.type());
            this.delegateGson.toJson((Object)value, value.getClass(), out);
            out.endObject();
        }

        public @Nullable SecurityScheme read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            JsonElement jsonElement = JsonParser.parseReader((JsonReader)in);
            if (!jsonElement.isJsonObject()) {
                throw new JsonSyntaxException("SecurityScheme must be a JSON object");
            }
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            Set keys = jsonObject.keySet();
            if (keys.size() != 1) {
                throw new JsonSyntaxException(String.format("A SecurityScheme object must have exactly one key, which must be one of: %s (found: %s)", VALID_KEYS, keys));
            }
            String discriminator = (String)keys.iterator().next();
            JsonElement nestedObject = jsonObject.get(discriminator);
            return switch (discriminator) {
                case "apiKeySecurityScheme" -> (APIKeySecurityScheme)this.delegateGson.fromJson(nestedObject, APIKeySecurityScheme.class);
                case "httpAuthSecurityScheme" -> (HTTPAuthSecurityScheme)this.delegateGson.fromJson(nestedObject, HTTPAuthSecurityScheme.class);
                case "oauth2SecurityScheme" -> (OAuth2SecurityScheme)this.delegateGson.fromJson(nestedObject, OAuth2SecurityScheme.class);
                case "openIdConnectSecurityScheme" -> (OpenIdConnectSecurityScheme)this.delegateGson.fromJson(nestedObject, OpenIdConnectSecurityScheme.class);
                case "mtlsSecurityScheme" -> (MutualTLSSecurityScheme)this.delegateGson.fromJson(nestedObject, MutualTLSSecurityScheme.class);
                default -> throw new JsonSyntaxException(String.format("Unknown SecurityScheme type. Must be one of: %s (found: %s)", VALID_KEYS, discriminator));
            };
        }
    }

    static class APIKeyLocationTypeAdapter
    extends TypeAdapter<APIKeySecurityScheme.Location> {
        APIKeyLocationTypeAdapter() {
        }

        public void write(JsonWriter out, APIKeySecurityScheme.Location value) throws IOException {
            if (value == null) {
                out.nullValue();
                return;
            }
            out.value(value.asString());
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable APIKeySecurityScheme.Location read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            String locationString = in.nextString();
            try {
                return APIKeySecurityScheme.Location.fromString((String)locationString);
            }
            catch (IllegalArgumentException e) {
                throw new JsonSyntaxException("Invalid APIKeySecurityScheme.Location: " + locationString, (Throwable)e);
            }
        }
    }

    static class ThrowableTypeAdapter
    extends TypeAdapter<Throwable> {
        ThrowableTypeAdapter() {
        }

        public void write(JsonWriter out, Throwable value) throws IOException {
            if (value == null) {
                out.nullValue();
                return;
            }
            out.beginObject();
            out.name("type").value(value.getClass().getName());
            out.name("message").value(value.getMessage());
            out.name("__throwable").value(true);
            out.endObject();
        }

        public @Nullable Throwable read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            String type = null;
            String message = null;
            in.beginObject();
            block12: while (in.hasNext()) {
                String fieldName;
                switch (fieldName = in.nextName()) {
                    case "type": {
                        type = in.nextString();
                        continue block12;
                    }
                    case "message": {
                        message = in.nextString();
                        continue block12;
                    }
                }
                in.skipValue();
            }
            in.endObject();
            if (type != null) {
                try {
                    Class<?> throwableClass = Class.forName(type);
                    if (Throwable.class.isAssignableFrom(throwableClass)) {
                        try {
                            Constructor<?> constructor = throwableClass.getConstructor(String.class);
                            return (Throwable)constructor.newInstance(message);
                        }
                        catch (NoSuchMethodException e) {
                            return new RuntimeException(message);
                        }
                    }
                }
                catch (Exception e) {
                    return new RuntimeException(message);
                }
            }
            return new RuntimeException(message);
        }
    }
}

