/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.client.http;

import io.a2a.client.http.A2AHttpClient;
import io.a2a.client.http.A2AHttpResponse;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import java.util.function.Consumer;

public class JdkA2AHttpClient
implements A2AHttpClient {
    private final HttpClient httpClient = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).followRedirects(HttpClient.Redirect.NORMAL).build();

    @Override
    public A2AHttpClient.GetBuilder createGet() {
        return new JdkGetBuilder();
    }

    @Override
    public A2AHttpClient.PostBuilder createPost() {
        return new JdkPostBuilder();
    }

    @Override
    public A2AHttpClient.DeleteBuilder createDelete() {
        return new JdkDeleteBuilder();
    }

    private class JdkGetBuilder
    extends JdkBuilder<A2AHttpClient.GetBuilder>
    implements A2AHttpClient.GetBuilder {
        private JdkGetBuilder() {
        }

        private HttpRequest.Builder createRequestBuilder(boolean SSE) throws IOException {
            HttpRequest.Builder builder = super.createRequestBuilder().GET();
            if (SSE) {
                builder.header("Accept", "text/event-stream");
            }
            return builder;
        }

        @Override
        public A2AHttpResponse get() throws IOException, InterruptedException {
            HttpRequest request = this.createRequestBuilder(false).build();
            HttpResponse<String> response = JdkA2AHttpClient.this.httpClient.send(request, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
            return new JdkHttpResponse(response);
        }

        @Override
        public CompletableFuture<Void> getAsyncSSE(Consumer<String> messageConsumer, Consumer<Throwable> errorConsumer, Runnable completeRunnable) throws IOException, InterruptedException {
            HttpRequest request = this.createRequestBuilder(true).build();
            return super.asyncRequest(request, messageConsumer, errorConsumer, completeRunnable);
        }
    }

    private class JdkPostBuilder
    extends JdkBuilder<A2AHttpClient.PostBuilder>
    implements A2AHttpClient.PostBuilder {
        String body;

        private JdkPostBuilder() {
            this.body = "";
        }

        @Override
        public A2AHttpClient.PostBuilder body(String body) {
            this.body = body;
            return (A2AHttpClient.PostBuilder)this.self();
        }

        private HttpRequest.Builder createRequestBuilder(boolean SSE) throws IOException {
            HttpRequest.Builder builder = super.createRequestBuilder().POST(HttpRequest.BodyPublishers.ofString(this.body, StandardCharsets.UTF_8));
            if (SSE) {
                builder.header("Accept", "text/event-stream");
            }
            return builder;
        }

        @Override
        public A2AHttpResponse post() throws IOException, InterruptedException {
            HttpRequest request = this.createRequestBuilder(false).POST(HttpRequest.BodyPublishers.ofString(this.body, StandardCharsets.UTF_8)).build();
            HttpResponse<String> response = JdkA2AHttpClient.this.httpClient.send(request, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
            return new JdkHttpResponse(response);
        }

        @Override
        public CompletableFuture<Void> postAsyncSSE(Consumer<String> messageConsumer, Consumer<Throwable> errorConsumer, Runnable completeRunnable) throws IOException, InterruptedException {
            HttpRequest request = this.createRequestBuilder(true).build();
            return super.asyncRequest(request, messageConsumer, errorConsumer, completeRunnable);
        }
    }

    private class JdkDeleteBuilder
    extends JdkBuilder<A2AHttpClient.DeleteBuilder>
    implements A2AHttpClient.DeleteBuilder {
        private JdkDeleteBuilder() {
        }

        @Override
        public A2AHttpResponse delete() throws IOException, InterruptedException {
            HttpRequest request = super.createRequestBuilder().DELETE().build();
            HttpResponse<String> response = JdkA2AHttpClient.this.httpClient.send(request, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
            return new JdkHttpResponse(response);
        }
    }

    private record JdkHttpResponse(HttpResponse<String> response) implements A2AHttpResponse
    {
        @Override
        public int status() {
            return this.response.statusCode();
        }

        @Override
        public boolean success() {
            return JdkHttpResponse.success(this.response);
        }

        static boolean success(HttpResponse<?> response) {
            return response.statusCode() >= 200 && response.statusCode() < 300;
        }

        @Override
        public String body() {
            return this.response.body();
        }
    }

    private abstract class JdkBuilder<T extends A2AHttpClient.Builder<T>>
    implements A2AHttpClient.Builder<T> {
        private String url;
        private Map<String, String> headers = new HashMap<String, String>();

        private JdkBuilder() {
        }

        @Override
        public T url(String url) {
            this.url = url;
            return this.self();
        }

        @Override
        public T addHeader(String name, String value) {
            this.headers.put(name, value);
            return this.self();
        }

        @Override
        public T addHeaders(Map<String, String> headers) {
            if (headers != null && !headers.isEmpty()) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    this.addHeader(entry.getKey(), entry.getValue());
                }
            }
            return this.self();
        }

        T self() {
            return (T)this;
        }

        protected HttpRequest.Builder createRequestBuilder() throws IOException {
            HttpRequest.Builder builder = HttpRequest.newBuilder().uri(URI.create(this.url));
            for (Map.Entry<String, String> headerEntry : this.headers.entrySet()) {
                builder.header(headerEntry.getKey(), headerEntry.getValue());
            }
            return builder;
        }

        protected CompletableFuture<Void> asyncRequest(HttpRequest request, final Consumer<String> messageConsumer, final Consumer<Throwable> errorConsumer, final Runnable completeRunnable) {
            Flow.Subscriber<String> subscriber = new Flow.Subscriber<String>(){
                private Flow.Subscription subscription;

                @Override
                public void onSubscribe(Flow.Subscription subscription) {
                    this.subscription = subscription;
                    subscription.request(1L);
                }

                @Override
                public void onNext(String item) {
                    if (item != null && item.startsWith("data:") && !(item = item.substring(5).trim()).isEmpty()) {
                        messageConsumer.accept(item);
                    }
                    this.subscription.request(1L);
                }

                @Override
                public void onError(Throwable throwable) {
                    errorConsumer.accept(throwable);
                    this.subscription.cancel();
                }

                @Override
                public void onComplete() {
                    completeRunnable.run();
                    this.subscription.cancel();
                }
            };
            HttpResponse.BodyHandler<Void> bodyHandler = HttpResponse.BodyHandlers.fromLineSubscriber((Flow.Subscriber<? super String>)subscriber);
            return JdkA2AHttpClient.this.httpClient.sendAsync(request, bodyHandler).thenAccept(response -> {
                if (!JdkHttpResponse.success(response)) {
                    subscriber.onError(new IOException("Request failed " + response.statusCode()));
                }
            });
        }
    }
}

