/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.examples.helloworld;

import io.a2a.A2A;
import io.a2a.client.Client;
import io.a2a.client.ClientBuilder;
import io.a2a.client.ClientEvent;
import io.a2a.client.MessageEvent;
import io.a2a.client.http.A2ACardResolver;
import io.a2a.client.transport.grpc.GrpcTransport;
import io.a2a.client.transport.grpc.GrpcTransportConfig;
import io.a2a.client.transport.grpc.GrpcTransportConfigBuilder;
import io.a2a.client.transport.jsonrpc.JSONRPCTransport;
import io.a2a.client.transport.jsonrpc.JSONRPCTransportConfig;
import io.a2a.client.transport.rest.RestTransport;
import io.a2a.client.transport.rest.RestTransportConfig;
import io.a2a.client.transport.spi.ClientTransportConfig;
import io.a2a.jsonrpc.common.json.JsonUtil;
import io.a2a.spec.AgentCard;
import io.a2a.spec.Message;
import io.a2a.spec.Part;
import io.a2a.spec.TextPart;
import io.grpc.Channel;
import io.grpc.ManagedChannelBuilder;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporter;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;

public class HelloWorldClient {
    private static final String SERVER_URL = "http://localhost:9999";
    private static final String MESSAGE_TEXT = "how much is 10 USD in INR?";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        OpenTelemetrySdk openTelemetrySdk = null;
        try {
            AgentCard publicAgentCard = new A2ACardResolver(SERVER_URL).getAgentCard();
            System.out.println("Successfully fetched public agent card:");
            System.out.println(JsonUtil.toJson((Object)publicAgentCard));
            System.out.println("Using public agent card for client initialization (default).");
            AgentCard finalAgentCard = publicAgentCard;
            if (publicAgentCard.capabilities().extendedAgentCard()) {
                System.out.println("Public card supports authenticated extended card. Attempting to fetch from: http://localhost:9999/ExtendedAgentCard");
                HashMap<String, String> authHeaders = new HashMap<String, String>();
                authHeaders.put("Authorization", "Bearer dummy-token-for-extended-card");
                AgentCard extendedAgentCard = A2A.getAgentCard((String)SERVER_URL, (String)"/ExtendedAgentCard", authHeaders);
                System.out.println("Successfully fetched authenticated extended agent card:");
                System.out.println(JsonUtil.toJson((Object)extendedAgentCard));
                System.out.println("Using AUTHENTICATED EXTENDED agent card for client initialization.");
                finalAgentCard = extendedAgentCard;
            } else {
                System.out.println("Public card does not indicate support for an extended card. Using public card.");
            }
            CompletableFuture messageResponse = new CompletableFuture();
            ArrayList<BiConsumer<ClientEvent, AgentCard>> consumers = new ArrayList<BiConsumer<ClientEvent, AgentCard>>();
            consumers.add((event, agentCard) -> {
                if (event instanceof MessageEvent) {
                    MessageEvent messageEvent = (MessageEvent)event;
                    Message responseMessage = messageEvent.getMessage();
                    StringBuilder textBuilder = new StringBuilder();
                    if (responseMessage.parts() != null) {
                        for (Part part : responseMessage.parts()) {
                            if (!(part instanceof TextPart)) continue;
                            TextPart textPart = (TextPart)part;
                            textBuilder.append(textPart.text());
                        }
                    }
                    messageResponse.complete(textBuilder.toString());
                } else {
                    System.out.println("Received client event: " + event.getClass().getSimpleName());
                }
            });
            Consumer<Throwable> streamingErrorHandler = error -> {
                System.err.println("Streaming error occurred: " + error.getMessage());
                error.printStackTrace();
                messageResponse.completeExceptionally((Throwable)error);
            };
            if (Boolean.getBoolean("opentelemetry")) {
                openTelemetrySdk = HelloWorldClient.initOpenTelemetry();
            }
            ClientBuilder clientBuilder = Client.builder((AgentCard)finalAgentCard).addConsumers(consumers).streamingErrorHandler(streamingErrorHandler);
            HelloWorldClient.configureTransport(clientBuilder, openTelemetrySdk);
            Client client = clientBuilder.build();
            Message message = A2A.toUserMessage((String)MESSAGE_TEXT);
            try {
                System.out.println("Sending message: how much is 10 USD in INR?");
                client.sendMessage(message);
                System.out.println("Message sent successfully. Responses will be handled by the configured consumers.");
                String responseText = (String)messageResponse.get();
                System.out.println("Response: " + responseText);
            }
            catch (Exception e) {
                System.err.println("Failed to get response: " + e.getMessage());
            }
        }
        catch (Exception e) {
            System.err.println("An error occurred: " + e.getMessage());
            e.printStackTrace();
        }
        finally {
            if (openTelemetrySdk != null) {
                System.out.println("Shutting down OpenTelemetry SDK...");
                openTelemetrySdk.close();
                System.out.println("OpenTelemetry SDK shutdown complete.");
            }
        }
    }

    static OpenTelemetrySdk initOpenTelemetry() {
        SdkTracerProvider sdkTracerProvider = SdkTracerProvider.builder().addSpanProcessor((SpanProcessor)BatchSpanProcessor.builder((SpanExporter)OtlpGrpcSpanExporter.builder().setEndpoint("http://localhost:5317").build()).build()).setResource(Resource.getDefault().toBuilder().put("service.version", "1.0").put("service.name", "helloworld-client").build()).build();
        return OpenTelemetrySdk.builder().setTracerProvider(sdkTracerProvider).setPropagators(ContextPropagators.create((TextMapPropagator)W3CTraceContextPropagator.getInstance())).build();
    }

    private static void configureTransport(ClientBuilder clientBuilder, OpenTelemetrySdk openTelemetrySdk) {
        switch (System.getProperty("quarkus.agentcard.protocol", "JSONRPC")) {
            case "GRPC": {
                Function<String, Channel> channelFactory = url -> {
                    String target = url.replaceAll("^https?://", "");
                    return ManagedChannelBuilder.forTarget((String)target).usePlaintext().build();
                };
                GrpcTransportConfig transportConfig = new GrpcTransportConfigBuilder().channelFactory(channelFactory).build();
                HelloWorldClient.updateTransportConfig((ClientTransportConfig)transportConfig, openTelemetrySdk);
                clientBuilder.withTransport(GrpcTransport.class, (ClientTransportConfig)transportConfig);
                break;
            }
            case "HTTP+JSON": {
                RestTransportConfig transportConfig = new RestTransportConfig();
                HelloWorldClient.updateTransportConfig((ClientTransportConfig)transportConfig, openTelemetrySdk);
                clientBuilder.withTransport(RestTransport.class, (ClientTransportConfig)transportConfig);
                break;
            }
            default: {
                JSONRPCTransportConfig transportConfig = new JSONRPCTransportConfig();
                HelloWorldClient.updateTransportConfig((ClientTransportConfig)transportConfig, openTelemetrySdk);
                clientBuilder.withTransport(JSONRPCTransport.class, (ClientTransportConfig)transportConfig);
            }
        }
    }

    private static void updateTransportConfig(ClientTransportConfig transportConfig, OpenTelemetrySdk openTelemetrySdk) {
        if (openTelemetrySdk != null) {
            HashMap<String, Object> parameters = new HashMap<String, Object>(transportConfig.getParameters());
            parameters.put("io.a2a.extras.opentelemetry.Tracer", openTelemetrySdk.getTracer("helloworld-client"));
            parameters.put("io.a2a.extras.opentelemetry.OpenTelemetry", openTelemetrySdk);
            transportConfig.setParameters(parameters);
        }
    }
}

