/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.client.transport.spi.sse;

import io.a2a.spec.StreamingEventKind;
import io.a2a.spec.Task;
import io.a2a.spec.TaskState;
import io.a2a.spec.TaskStatusUpdateEvent;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.jspecify.annotations.Nullable;

public abstract class AbstractSSEEventListener {
    private static final Logger log = Logger.getLogger(AbstractSSEEventListener.class.getName());
    private final Consumer<StreamingEventKind> eventHandler;
    private final @Nullable Consumer<Throwable> errorHandler;

    protected AbstractSSEEventListener(Consumer<StreamingEventKind> eventHandler, @Nullable Consumer<Throwable> errorHandler) {
        this.eventHandler = eventHandler;
        this.errorHandler = errorHandler;
    }

    protected Consumer<StreamingEventKind> getEventHandler() {
        return this.eventHandler;
    }

    protected @Nullable Consumer<Throwable> getErrorHandler() {
        return this.errorHandler;
    }

    public abstract void onMessage(String var1, @Nullable Future<Void> var2);

    public void onError(Throwable throwable, @Nullable Future<Void> future) {
        if (this.errorHandler != null) {
            this.errorHandler.accept(throwable);
        }
        if (future != null) {
            future.cancel(true);
        }
    }

    protected void handleEvent(StreamingEventKind event, @Nullable Future<Void> future) {
        this.eventHandler.accept(event);
        if (this.shouldAutoClose(event) && future != null) {
            log.fine("Auto-closing SSE connection for final event: " + event.getClass().getSimpleName());
            future.cancel(true);
        }
    }

    protected boolean shouldAutoClose(StreamingEventKind event) {
        TaskStatusUpdateEvent tue;
        if (event instanceof TaskStatusUpdateEvent && (tue = (TaskStatusUpdateEvent)event).isFinal()) {
            return true;
        }
        if (event instanceof Task) {
            Task task = (Task)event;
            TaskState state = task.status().state();
            return state.isFinal();
        }
        return false;
    }
}

