/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.client.transport.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import io.a2a.client.http.A2ACardResolver;
import io.a2a.client.http.A2AHttpClient;
import io.a2a.client.http.A2AHttpResponse;
import io.a2a.client.http.JdkA2AHttpClient;
import io.a2a.client.transport.rest.RestErrorMapper;
import io.a2a.client.transport.rest.sse.RestSSEEventListener;
import io.a2a.client.transport.spi.ClientTransport;
import io.a2a.client.transport.spi.interceptors.ClientCallContext;
import io.a2a.client.transport.spi.interceptors.ClientCallInterceptor;
import io.a2a.client.transport.spi.interceptors.PayloadAndHeaders;
import io.a2a.grpc.CancelTaskRequest;
import io.a2a.grpc.CreateTaskPushNotificationConfigRequest;
import io.a2a.grpc.DeleteTaskPushNotificationConfigRequest;
import io.a2a.grpc.GetTaskPushNotificationConfigRequest;
import io.a2a.grpc.GetTaskRequest;
import io.a2a.grpc.ListTaskPushNotificationConfigRequest;
import io.a2a.grpc.ListTaskPushNotificationConfigResponse;
import io.a2a.grpc.ListTaskPushNotificationConfigResponseOrBuilder;
import io.a2a.grpc.SendMessageRequest;
import io.a2a.grpc.SendMessageResponse;
import io.a2a.grpc.Task;
import io.a2a.grpc.TaskOrBuilder;
import io.a2a.grpc.TaskPushNotificationConfig;
import io.a2a.grpc.TaskPushNotificationConfigOrBuilder;
import io.a2a.grpc.TaskSubscriptionRequest;
import io.a2a.grpc.utils.ProtoUtils;
import io.a2a.spec.A2AClientError;
import io.a2a.spec.A2AClientException;
import io.a2a.spec.AgentCard;
import io.a2a.spec.DeleteTaskPushNotificationConfigParams;
import io.a2a.spec.EventKind;
import io.a2a.spec.GetTaskPushNotificationConfigParams;
import io.a2a.spec.ListTaskPushNotificationConfigParams;
import io.a2a.spec.MessageSendParams;
import io.a2a.spec.StreamingEventKind;
import io.a2a.spec.TaskIdParams;
import io.a2a.spec.TaskQueryParams;
import io.a2a.util.Assert;
import io.a2a.util.Utils;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.jspecify.annotations.Nullable;

public class RestTransport
implements ClientTransport {
    private static final Logger log = Logger.getLogger(RestTransport.class.getName());
    private final A2AHttpClient httpClient;
    private final String agentUrl;
    private final @Nullable List<ClientCallInterceptor> interceptors;
    private AgentCard agentCard;
    private boolean needsExtendedCard = false;

    public RestTransport(AgentCard agentCard) {
        this(null, agentCard, agentCard.url(), null);
    }

    public RestTransport(@Nullable A2AHttpClient httpClient, AgentCard agentCard, String agentUrl, @Nullable List<ClientCallInterceptor> interceptors) {
        this.httpClient = httpClient == null ? new JdkA2AHttpClient() : httpClient;
        this.agentCard = agentCard;
        this.agentUrl = agentUrl.endsWith("/") ? agentUrl.substring(0, agentUrl.length() - 1) : agentUrl;
        this.interceptors = interceptors;
    }

    public EventKind sendMessage(MessageSendParams messageSendParams, @Nullable ClientCallContext context) throws A2AClientException {
        Assert.checkNotNullParam((String)"messageSendParams", (Object)messageSendParams);
        SendMessageRequest.Builder builder = SendMessageRequest.newBuilder((SendMessageRequest)ProtoUtils.ToProto.sendMessageRequest((MessageSendParams)messageSendParams));
        PayloadAndHeaders payloadAndHeaders = this.applyInterceptors("message/send", (MessageOrBuilder)builder, this.agentCard, context);
        try {
            String httpResponseBody = this.sendPostRequest(this.agentUrl + "/v1/message:send", payloadAndHeaders);
            SendMessageResponse.Builder responseBuilder = SendMessageResponse.newBuilder();
            JsonFormat.parser().merge(httpResponseBody, (Message.Builder)responseBuilder);
            if (responseBuilder.hasMsg()) {
                return ProtoUtils.FromProto.message((io.a2a.grpc.MessageOrBuilder)responseBuilder.getMsg());
            }
            if (responseBuilder.hasTask()) {
                return ProtoUtils.FromProto.task((TaskOrBuilder)responseBuilder.getTask());
            }
            throw new A2AClientException("Failed to send message, wrong response:" + httpResponseBody);
        }
        catch (A2AClientException e) {
            throw e;
        }
        catch (IOException | InterruptedException e) {
            throw new A2AClientException("Failed to send message: " + String.valueOf(e), (Throwable)e);
        }
    }

    public void sendMessageStreaming(MessageSendParams messageSendParams, Consumer<StreamingEventKind> eventConsumer, Consumer<Throwable> errorConsumer, @Nullable ClientCallContext context) throws A2AClientException {
        Assert.checkNotNullParam((String)"request", (Object)messageSendParams);
        Assert.checkNotNullParam((String)"eventConsumer", eventConsumer);
        Assert.checkNotNullParam((String)"messageSendParams", (Object)messageSendParams);
        SendMessageRequest.Builder builder = SendMessageRequest.newBuilder((SendMessageRequest)ProtoUtils.ToProto.sendMessageRequest((MessageSendParams)messageSendParams));
        PayloadAndHeaders payloadAndHeaders = this.applyInterceptors("message/stream", (MessageOrBuilder)builder, this.agentCard, context);
        AtomicReference<CompletableFuture> ref = new AtomicReference<CompletableFuture>();
        RestSSEEventListener sseEventListener = new RestSSEEventListener(eventConsumer, errorConsumer);
        try {
            A2AHttpClient.PostBuilder postBuilder = this.createPostBuilder(this.agentUrl + "/v1/message:stream", payloadAndHeaders);
            ref.set(postBuilder.postAsyncSSE(msg -> sseEventListener.onMessage((String)msg, (Future)ref.get()), throwable -> sseEventListener.onError((Throwable)throwable, (Future)ref.get()), () -> {}));
        }
        catch (IOException e) {
            throw new A2AClientException("Failed to send streaming message request: " + String.valueOf(e), (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new A2AClientException("Send streaming message request timed out: " + String.valueOf(e), (Throwable)e);
        }
    }

    public io.a2a.spec.Task getTask(TaskQueryParams taskQueryParams, @Nullable ClientCallContext context) throws A2AClientException {
        Assert.checkNotNullParam((String)"taskQueryParams", (Object)taskQueryParams);
        GetTaskRequest.Builder builder = GetTaskRequest.newBuilder();
        builder.setName("tasks/" + taskQueryParams.id());
        PayloadAndHeaders payloadAndHeaders = this.applyInterceptors("tasks/get", (MessageOrBuilder)builder, this.agentCard, context);
        try {
            A2AHttpResponse response;
            String url = taskQueryParams.historyLength() > 0 ? this.agentUrl + String.format("/v1/tasks/%1s?historyLength=%2d", taskQueryParams.id(), taskQueryParams.historyLength()) : this.agentUrl + String.format("/v1/tasks/%1s", taskQueryParams.id());
            A2AHttpClient.GetBuilder getBuilder = (A2AHttpClient.GetBuilder)this.httpClient.createGet().url(url);
            if (payloadAndHeaders.getHeaders() != null) {
                for (Map.Entry entry : payloadAndHeaders.getHeaders().entrySet()) {
                    getBuilder.addHeader((String)entry.getKey(), (String)entry.getValue());
                }
            }
            if (!(response = getBuilder.get()).success()) {
                throw RestErrorMapper.mapRestError(response);
            }
            String httpResponseBody = response.body();
            Task.Builder responseBuilder = Task.newBuilder();
            JsonFormat.parser().merge(httpResponseBody, (Message.Builder)responseBuilder);
            return ProtoUtils.FromProto.task((TaskOrBuilder)responseBuilder);
        }
        catch (A2AClientException e) {
            throw e;
        }
        catch (IOException | InterruptedException e) {
            throw new A2AClientException("Failed to get task: " + String.valueOf(e), (Throwable)e);
        }
    }

    public io.a2a.spec.Task cancelTask(TaskIdParams taskIdParams, @Nullable ClientCallContext context) throws A2AClientException {
        Assert.checkNotNullParam((String)"taskIdParams", (Object)taskIdParams);
        CancelTaskRequest.Builder builder = CancelTaskRequest.newBuilder();
        builder.setName("tasks/" + taskIdParams.id());
        PayloadAndHeaders payloadAndHeaders = this.applyInterceptors("tasks/cancel", (MessageOrBuilder)builder, this.agentCard, context);
        try {
            String httpResponseBody = this.sendPostRequest(this.agentUrl + String.format("/v1/tasks/%1s:cancel", taskIdParams.id()), payloadAndHeaders);
            Task.Builder responseBuilder = Task.newBuilder();
            JsonFormat.parser().merge(httpResponseBody, (Message.Builder)responseBuilder);
            return ProtoUtils.FromProto.task((TaskOrBuilder)responseBuilder);
        }
        catch (A2AClientException e) {
            throw e;
        }
        catch (IOException | InterruptedException e) {
            throw new A2AClientException("Failed to cancel task: " + String.valueOf(e), (Throwable)e);
        }
    }

    public io.a2a.spec.TaskPushNotificationConfig setTaskPushNotificationConfiguration(io.a2a.spec.TaskPushNotificationConfig request, @Nullable ClientCallContext context) throws A2AClientException {
        Assert.checkNotNullParam((String)"request", (Object)request);
        CreateTaskPushNotificationConfigRequest.Builder builder = CreateTaskPushNotificationConfigRequest.newBuilder();
        builder.setConfig(ProtoUtils.ToProto.taskPushNotificationConfig((io.a2a.spec.TaskPushNotificationConfig)request)).setParent("tasks/" + request.taskId());
        if (request.pushNotificationConfig().id() != null) {
            builder.setConfigId(request.pushNotificationConfig().id());
        }
        PayloadAndHeaders payloadAndHeaders = this.applyInterceptors("tasks/pushNotificationConfig/set", (MessageOrBuilder)builder, this.agentCard, context);
        try {
            String httpResponseBody = this.sendPostRequest(this.agentUrl + String.format("/v1/tasks/%1s/pushNotificationConfigs", request.taskId()), payloadAndHeaders);
            TaskPushNotificationConfig.Builder responseBuilder = TaskPushNotificationConfig.newBuilder();
            JsonFormat.parser().merge(httpResponseBody, (Message.Builder)responseBuilder);
            return ProtoUtils.FromProto.taskPushNotificationConfig((TaskPushNotificationConfigOrBuilder)responseBuilder);
        }
        catch (A2AClientException e) {
            throw e;
        }
        catch (IOException | InterruptedException e) {
            throw new A2AClientException("Failed to set task push notification config: " + String.valueOf(e), (Throwable)e);
        }
    }

    public io.a2a.spec.TaskPushNotificationConfig getTaskPushNotificationConfiguration(GetTaskPushNotificationConfigParams request, @Nullable ClientCallContext context) throws A2AClientException {
        Assert.checkNotNullParam((String)"request", (Object)request);
        GetTaskPushNotificationConfigRequest.Builder builder = GetTaskPushNotificationConfigRequest.newBuilder();
        builder.setName(String.format("/tasks/%1s/pushNotificationConfigs/%2s", request.id(), request.pushNotificationConfigId()));
        PayloadAndHeaders payloadAndHeaders = this.applyInterceptors("tasks/pushNotificationConfig/get", (MessageOrBuilder)builder, this.agentCard, context);
        try {
            A2AHttpResponse response;
            String url = this.agentUrl + String.format("/v1/tasks/%1s/pushNotificationConfigs/%2s", request.id(), request.pushNotificationConfigId());
            A2AHttpClient.GetBuilder getBuilder = (A2AHttpClient.GetBuilder)this.httpClient.createGet().url(url);
            if (payloadAndHeaders.getHeaders() != null) {
                for (Map.Entry entry : payloadAndHeaders.getHeaders().entrySet()) {
                    getBuilder.addHeader((String)entry.getKey(), (String)entry.getValue());
                }
            }
            if (!(response = getBuilder.get()).success()) {
                throw RestErrorMapper.mapRestError(response);
            }
            String httpResponseBody = response.body();
            TaskPushNotificationConfig.Builder responseBuilder = TaskPushNotificationConfig.newBuilder();
            JsonFormat.parser().merge(httpResponseBody, (Message.Builder)responseBuilder);
            return ProtoUtils.FromProto.taskPushNotificationConfig((TaskPushNotificationConfigOrBuilder)responseBuilder);
        }
        catch (A2AClientException e) {
            throw e;
        }
        catch (IOException | InterruptedException e) {
            throw new A2AClientException("Failed to get push notifications: " + String.valueOf(e), (Throwable)e);
        }
    }

    public List<io.a2a.spec.TaskPushNotificationConfig> listTaskPushNotificationConfigurations(ListTaskPushNotificationConfigParams request, @Nullable ClientCallContext context) throws A2AClientException {
        Assert.checkNotNullParam((String)"request", (Object)request);
        ListTaskPushNotificationConfigRequest.Builder builder = ListTaskPushNotificationConfigRequest.newBuilder();
        builder.setParent(String.format("/tasks/%1s/pushNotificationConfigs", request.id()));
        PayloadAndHeaders payloadAndHeaders = this.applyInterceptors("tasks/pushNotificationConfig/list", (MessageOrBuilder)builder, this.agentCard, context);
        try {
            A2AHttpResponse response;
            String url = this.agentUrl + String.format("/v1/tasks/%1s/pushNotificationConfigs", request.id());
            A2AHttpClient.GetBuilder getBuilder = (A2AHttpClient.GetBuilder)this.httpClient.createGet().url(url);
            if (payloadAndHeaders.getHeaders() != null) {
                for (Map.Entry entry : payloadAndHeaders.getHeaders().entrySet()) {
                    getBuilder.addHeader((String)entry.getKey(), (String)entry.getValue());
                }
            }
            if (!(response = getBuilder.get()).success()) {
                throw RestErrorMapper.mapRestError(response);
            }
            String httpResponseBody = response.body();
            ListTaskPushNotificationConfigResponse.Builder responseBuilder = ListTaskPushNotificationConfigResponse.newBuilder();
            JsonFormat.parser().merge(httpResponseBody, (Message.Builder)responseBuilder);
            return ProtoUtils.FromProto.listTaskPushNotificationConfigParams((ListTaskPushNotificationConfigResponseOrBuilder)responseBuilder);
        }
        catch (A2AClientException e) {
            throw e;
        }
        catch (IOException | InterruptedException e) {
            throw new A2AClientException("Failed to list push notifications: " + String.valueOf(e), (Throwable)e);
        }
    }

    public void deleteTaskPushNotificationConfigurations(DeleteTaskPushNotificationConfigParams request, @Nullable ClientCallContext context) throws A2AClientException {
        Assert.checkNotNullParam((String)"request", (Object)request);
        DeleteTaskPushNotificationConfigRequest.Builder builder = DeleteTaskPushNotificationConfigRequest.newBuilder();
        PayloadAndHeaders payloadAndHeaders = this.applyInterceptors("tasks/pushNotificationConfig/delete", (MessageOrBuilder)builder, this.agentCard, context);
        try {
            A2AHttpResponse response;
            String url = this.agentUrl + String.format("/v1/tasks/%1s/pushNotificationConfigs/%2s", request.id(), request.pushNotificationConfigId());
            A2AHttpClient.DeleteBuilder deleteBuilder = (A2AHttpClient.DeleteBuilder)this.httpClient.createDelete().url(url);
            if (payloadAndHeaders.getHeaders() != null) {
                for (Map.Entry entry : payloadAndHeaders.getHeaders().entrySet()) {
                    deleteBuilder.addHeader((String)entry.getKey(), (String)entry.getValue());
                }
            }
            if (!(response = deleteBuilder.delete()).success()) {
                throw RestErrorMapper.mapRestError(response);
            }
        }
        catch (A2AClientException e) {
            throw e;
        }
        catch (IOException | InterruptedException e) {
            throw new A2AClientException("Failed to delete push notification config: " + String.valueOf(e), (Throwable)e);
        }
    }

    public void resubscribe(TaskIdParams request, Consumer<StreamingEventKind> eventConsumer, Consumer<Throwable> errorConsumer, @Nullable ClientCallContext context) throws A2AClientException {
        Assert.checkNotNullParam((String)"request", (Object)request);
        TaskSubscriptionRequest.Builder builder = TaskSubscriptionRequest.newBuilder();
        builder.setName("tasks/" + request.id());
        PayloadAndHeaders payloadAndHeaders = this.applyInterceptors("tasks/resubscribe", (MessageOrBuilder)builder, this.agentCard, context);
        AtomicReference<CompletableFuture> ref = new AtomicReference<CompletableFuture>();
        RestSSEEventListener sseEventListener = new RestSSEEventListener(eventConsumer, errorConsumer);
        try {
            String url = this.agentUrl + String.format("/v1/tasks/%1s:subscribe", request.id());
            A2AHttpClient.PostBuilder postBuilder = this.createPostBuilder(url, payloadAndHeaders);
            ref.set(postBuilder.postAsyncSSE(msg -> sseEventListener.onMessage((String)msg, (Future)ref.get()), throwable -> sseEventListener.onError((Throwable)throwable, (Future)ref.get()), () -> {}));
        }
        catch (IOException e) {
            throw new A2AClientException("Failed to send streaming message request: " + String.valueOf(e), (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new A2AClientException("Send streaming message request timed out: " + String.valueOf(e), (Throwable)e);
        }
    }

    public AgentCard getAgentCard(@Nullable ClientCallContext context) throws A2AClientException {
        try {
            A2AHttpResponse response;
            if (this.agentCard == null) {
                A2ACardResolver resolver = new A2ACardResolver(this.httpClient, this.agentUrl, null, this.getHttpHeaders(context));
                this.agentCard = resolver.getAgentCard();
                this.needsExtendedCard = this.agentCard.supportsAuthenticatedExtendedCard();
            }
            if (!this.needsExtendedCard) {
                return this.agentCard;
            }
            PayloadAndHeaders payloadAndHeaders = this.applyInterceptors("tasks/get", null, this.agentCard, context);
            String url = this.agentUrl + String.format("/v1/card", new Object[0]);
            A2AHttpClient.GetBuilder getBuilder = (A2AHttpClient.GetBuilder)this.httpClient.createGet().url(url);
            if (payloadAndHeaders.getHeaders() != null) {
                for (Map.Entry entry : payloadAndHeaders.getHeaders().entrySet()) {
                    getBuilder.addHeader((String)entry.getKey(), (String)entry.getValue());
                }
            }
            if (!(response = getBuilder.get()).success()) {
                throw RestErrorMapper.mapRestError(response);
            }
            String httpResponseBody = response.body();
            this.agentCard = (AgentCard)Utils.OBJECT_MAPPER.readValue(httpResponseBody, AgentCard.class);
            this.needsExtendedCard = false;
            return this.agentCard;
        }
        catch (IOException | InterruptedException e) {
            throw new A2AClientException("Failed to get authenticated extended agent card: " + String.valueOf(e), (Throwable)e);
        }
        catch (A2AClientError e) {
            throw new A2AClientException("Failed to get agent card: " + String.valueOf((Object)e), (Throwable)e);
        }
    }

    public void close() {
    }

    private PayloadAndHeaders applyInterceptors(String methodName, @Nullable MessageOrBuilder payload, AgentCard agentCard, @Nullable ClientCallContext clientCallContext) {
        PayloadAndHeaders payloadAndHeaders = new PayloadAndHeaders((Object)payload, this.getHttpHeaders(clientCallContext));
        if (this.interceptors != null && !this.interceptors.isEmpty()) {
            for (ClientCallInterceptor interceptor : this.interceptors) {
                payloadAndHeaders = interceptor.intercept(methodName, payloadAndHeaders.getPayload(), payloadAndHeaders.getHeaders(), agentCard, clientCallContext);
            }
        }
        return payloadAndHeaders;
    }

    private String sendPostRequest(String url, PayloadAndHeaders payloadAndHeaders) throws IOException, InterruptedException {
        A2AHttpClient.PostBuilder builder = this.createPostBuilder(url, payloadAndHeaders);
        A2AHttpResponse response = builder.post();
        if (!response.success()) {
            log.fine("Error on POST processing " + JsonFormat.printer().print((MessageOrBuilder)payloadAndHeaders.getPayload()));
            throw RestErrorMapper.mapRestError(response);
        }
        return response.body();
    }

    private A2AHttpClient.PostBuilder createPostBuilder(String url, PayloadAndHeaders payloadAndHeaders) throws JsonProcessingException, InvalidProtocolBufferException {
        log.fine(JsonFormat.printer().print((MessageOrBuilder)payloadAndHeaders.getPayload()));
        A2AHttpClient.PostBuilder postBuilder = ((A2AHttpClient.PostBuilder)((A2AHttpClient.PostBuilder)this.httpClient.createPost().url(url)).addHeader("Content-Type", "application/json")).body(JsonFormat.printer().print((MessageOrBuilder)payloadAndHeaders.getPayload()));
        if (payloadAndHeaders.getHeaders() != null) {
            for (Map.Entry entry : payloadAndHeaders.getHeaders().entrySet()) {
                postBuilder.addHeader((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return postBuilder;
    }

    private Map<String, String> getHttpHeaders(@Nullable ClientCallContext context) {
        return context != null ? context.getHeaders() : Collections.emptyMap();
    }
}

