/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.client.transport.grpc;

import com.google.protobuf.Timestamp;
import io.a2a.client.transport.grpc.EventStreamObserver;
import io.a2a.client.transport.grpc.GrpcErrorMapper;
import io.a2a.client.transport.spi.ClientTransport;
import io.a2a.client.transport.spi.interceptors.ClientCallContext;
import io.a2a.client.transport.spi.interceptors.ClientCallInterceptor;
import io.a2a.client.transport.spi.interceptors.PayloadAndHeaders;
import io.a2a.grpc.A2AServiceGrpc;
import io.a2a.grpc.AgentCardOrBuilder;
import io.a2a.grpc.CancelTaskRequest;
import io.a2a.grpc.CreateTaskPushNotificationConfigRequest;
import io.a2a.grpc.DeleteTaskPushNotificationConfigRequest;
import io.a2a.grpc.GetExtendedAgentCardRequest;
import io.a2a.grpc.GetTaskPushNotificationConfigRequest;
import io.a2a.grpc.GetTaskRequest;
import io.a2a.grpc.ListTaskPushNotificationConfigRequest;
import io.a2a.grpc.ListTaskPushNotificationConfigResponse;
import io.a2a.grpc.ListTaskPushNotificationConfigResponseOrBuilder;
import io.a2a.grpc.ListTasksRequest;
import io.a2a.grpc.ListTasksResponse;
import io.a2a.grpc.MessageOrBuilder;
import io.a2a.grpc.SendMessageRequest;
import io.a2a.grpc.SendMessageResponse;
import io.a2a.grpc.SubscribeToTaskRequest;
import io.a2a.grpc.TaskOrBuilder;
import io.a2a.grpc.TaskPushNotificationConfigOrBuilder;
import io.a2a.grpc.utils.ProtoUtils;
import io.a2a.jsonrpc.common.wrappers.ListTasksResult;
import io.a2a.spec.A2AClientException;
import io.a2a.spec.AgentCard;
import io.a2a.spec.DeleteTaskPushNotificationConfigParams;
import io.a2a.spec.EventKind;
import io.a2a.spec.GetTaskPushNotificationConfigParams;
import io.a2a.spec.ListTaskPushNotificationConfigParams;
import io.a2a.spec.ListTaskPushNotificationConfigResult;
import io.a2a.spec.ListTasksParams;
import io.a2a.spec.MessageSendParams;
import io.a2a.spec.StreamingEventKind;
import io.a2a.spec.Task;
import io.a2a.spec.TaskIdParams;
import io.a2a.spec.TaskPushNotificationConfig;
import io.a2a.spec.TaskQueryParams;
import io.a2a.spec.TaskState;
import io.a2a.util.Assert;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.Metadata;
import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.MetadataUtils;
import io.grpc.stub.StreamObserver;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;

public class GrpcTransport
implements ClientTransport {
    private static final Metadata.Key<String> AUTHORIZATION_METADATA_KEY = Metadata.Key.of((String)"Authorization", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final Metadata.Key<String> EXTENSIONS_KEY = Metadata.Key.of((String)"X-A2A-Extensions", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final Metadata.Key<String> VERSION_KEY = Metadata.Key.of((String)"X-A2A-Version", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private final A2AServiceGrpc.A2AServiceBlockingV2Stub blockingStub;
    private final A2AServiceGrpc.A2AServiceStub asyncStub;
    private final @Nullable List<ClientCallInterceptor> interceptors;
    private final AgentCard agentCard;
    private final String agentTenant;

    public GrpcTransport(Channel channel, AgentCard agentCard) {
        this(channel, agentCard, "", null);
    }

    public GrpcTransport(Channel channel, AgentCard agentCard, @Nullable String agentTenant, @Nullable List<ClientCallInterceptor> interceptors) {
        Assert.checkNotNullParam((String)"channel", (Object)channel);
        Assert.checkNotNullParam((String)"agentCard", (Object)agentCard);
        this.asyncStub = A2AServiceGrpc.newStub((Channel)channel);
        this.blockingStub = A2AServiceGrpc.newBlockingV2Stub((Channel)channel);
        this.agentCard = agentCard;
        this.interceptors = interceptors;
        this.agentTenant = agentTenant == null || agentTenant.isBlank() ? "" : agentTenant;
    }

    private String resolveTenant(@Nullable String requestTenant) {
        return requestTenant == null || requestTenant.isBlank() ? this.agentTenant : requestTenant;
    }

    public EventKind sendMessage(MessageSendParams request, @Nullable ClientCallContext context) throws A2AClientException {
        Assert.checkNotNullParam((String)"request", (Object)request);
        MessageSendParams tenantRequest = this.createRequestWithTenant(request);
        SendMessageRequest sendMessageRequest = this.createGrpcSendMessageRequest(tenantRequest, context);
        PayloadAndHeaders payloadAndHeaders = this.applyInterceptors("SendMessage", sendMessageRequest, this.agentCard, context);
        try {
            A2AServiceGrpc.A2AServiceBlockingV2Stub stubWithMetadata = this.createBlockingStubWithMetadata(context, payloadAndHeaders);
            SendMessageResponse response = stubWithMetadata.sendMessage(sendMessageRequest);
            if (response.hasMessage()) {
                return ProtoUtils.FromProto.message((MessageOrBuilder)response.getMessage());
            }
            if (response.hasTask()) {
                return ProtoUtils.FromProto.task((TaskOrBuilder)response.getTask());
            }
            throw new A2AClientException("Server response did not contain a message or task");
        }
        catch (StatusException | StatusRuntimeException e) {
            throw GrpcErrorMapper.mapGrpcError(e, "Failed to send message: ");
        }
    }

    public void sendMessageStreaming(MessageSendParams request, Consumer<StreamingEventKind> eventConsumer, Consumer<Throwable> errorConsumer, @Nullable ClientCallContext context) throws A2AClientException {
        Assert.checkNotNullParam((String)"request", (Object)request);
        Assert.checkNotNullParam((String)"eventConsumer", eventConsumer);
        MessageSendParams tenantRequest = this.createRequestWithTenant(request);
        SendMessageRequest grpcRequest = this.createGrpcSendMessageRequest(tenantRequest, context);
        PayloadAndHeaders payloadAndHeaders = this.applyInterceptors("SendStreamingMessage", grpcRequest, this.agentCard, context);
        EventStreamObserver streamObserver = new EventStreamObserver(eventConsumer, errorConsumer);
        try {
            A2AServiceGrpc.A2AServiceStub stubWithMetadata = this.createAsyncStubWithMetadata(context, payloadAndHeaders);
            stubWithMetadata.sendStreamingMessage(grpcRequest, (StreamObserver)streamObserver);
        }
        catch (StatusRuntimeException e) {
            throw GrpcErrorMapper.mapGrpcError(e, "Failed to send streaming message request: ");
        }
    }

    public Task getTask(TaskQueryParams request, @Nullable ClientCallContext context) throws A2AClientException {
        Assert.checkNotNullParam((String)"request", (Object)request);
        GetTaskRequest.Builder requestBuilder = GetTaskRequest.newBuilder();
        requestBuilder.setId(request.id());
        if (request.historyLength() != null) {
            requestBuilder.setHistoryLength(request.historyLength().intValue());
        }
        requestBuilder.setTenant(this.resolveTenant(request.tenant()));
        GetTaskRequest getTaskRequest = requestBuilder.build();
        PayloadAndHeaders payloadAndHeaders = this.applyInterceptors("GetTask", getTaskRequest, this.agentCard, context);
        try {
            A2AServiceGrpc.A2AServiceBlockingV2Stub stubWithMetadata = this.createBlockingStubWithMetadata(context, payloadAndHeaders);
            return ProtoUtils.FromProto.task((TaskOrBuilder)stubWithMetadata.getTask(getTaskRequest));
        }
        catch (StatusException | StatusRuntimeException e) {
            throw GrpcErrorMapper.mapGrpcError(e, "Failed to get task: ");
        }
    }

    public Task cancelTask(TaskIdParams request, @Nullable ClientCallContext context) throws A2AClientException {
        Assert.checkNotNullParam((String)"request", (Object)request);
        CancelTaskRequest cancelTaskRequest = CancelTaskRequest.newBuilder().setId(request.id()).setTenant(this.resolveTenant(request.tenant())).build();
        PayloadAndHeaders payloadAndHeaders = this.applyInterceptors("CancelTask", cancelTaskRequest, this.agentCard, context);
        try {
            A2AServiceGrpc.A2AServiceBlockingV2Stub stubWithMetadata = this.createBlockingStubWithMetadata(context, payloadAndHeaders);
            return ProtoUtils.FromProto.task((TaskOrBuilder)stubWithMetadata.cancelTask(cancelTaskRequest));
        }
        catch (StatusException | StatusRuntimeException e) {
            throw GrpcErrorMapper.mapGrpcError(e, "Failed to cancel task: ");
        }
    }

    public ListTasksResult listTasks(ListTasksParams request, @Nullable ClientCallContext context) throws A2AClientException {
        Assert.checkNotNullParam((String)"request", (Object)request);
        ListTasksRequest.Builder requestBuilder = ListTasksRequest.newBuilder();
        if (request.contextId() != null) {
            requestBuilder.setContextId(request.contextId());
        }
        if (request.status() != null) {
            requestBuilder.setStatus(ProtoUtils.ToProto.taskState((TaskState)request.status()));
        }
        if (request.pageSize() != null) {
            requestBuilder.setPageSize(request.pageSize().intValue());
        }
        if (request.pageToken() != null) {
            requestBuilder.setPageToken(request.pageToken());
        }
        if (request.historyLength() != null) {
            requestBuilder.setHistoryLength(request.historyLength().intValue());
        }
        if (request.statusTimestampAfter() != null) {
            requestBuilder.setStatusTimestampAfter(Timestamp.newBuilder().setSeconds(request.statusTimestampAfter().getEpochSecond()).setNanos(request.statusTimestampAfter().getNano()).build());
        }
        if (request.includeArtifacts() != null) {
            requestBuilder.setIncludeArtifacts(request.includeArtifacts().booleanValue());
        }
        requestBuilder.setTenant(this.resolveTenant(request.tenant()));
        ListTasksRequest listTasksRequest = requestBuilder.build();
        PayloadAndHeaders payloadAndHeaders = this.applyInterceptors("ListTasks", listTasksRequest, this.agentCard, context);
        try {
            A2AServiceGrpc.A2AServiceBlockingV2Stub stubWithMetadata = this.createBlockingStubWithMetadata(context, payloadAndHeaders);
            ListTasksResponse grpcResponse = stubWithMetadata.listTasks(listTasksRequest);
            return new ListTasksResult(grpcResponse.getTasksList().stream().map(ProtoUtils.FromProto::task).collect(Collectors.toList()), grpcResponse.getTotalSize(), grpcResponse.getTasksCount(), grpcResponse.getNextPageToken().isEmpty() ? null : grpcResponse.getNextPageToken());
        }
        catch (StatusException | StatusRuntimeException e) {
            throw GrpcErrorMapper.mapGrpcError(e, "Failed to list tasks: ");
        }
    }

    public TaskPushNotificationConfig createTaskPushNotificationConfiguration(TaskPushNotificationConfig request, @Nullable ClientCallContext context) throws A2AClientException {
        Assert.checkNotNullParam((String)"request", (Object)request);
        String configId = request.pushNotificationConfig().id();
        CreateTaskPushNotificationConfigRequest grpcRequest = CreateTaskPushNotificationConfigRequest.newBuilder().setTaskId(request.taskId()).setConfig(ProtoUtils.ToProto.taskPushNotificationConfig((TaskPushNotificationConfig)request).getPushNotificationConfig()).setConfigId(configId != null ? configId : request.taskId()).setTenant(this.resolveTenant(request.tenant())).build();
        PayloadAndHeaders payloadAndHeaders = this.applyInterceptors("CreateTaskPushNotificationConfig", grpcRequest, this.agentCard, context);
        try {
            A2AServiceGrpc.A2AServiceBlockingV2Stub stubWithMetadata = this.createBlockingStubWithMetadata(context, payloadAndHeaders);
            return ProtoUtils.FromProto.taskPushNotificationConfig((TaskPushNotificationConfigOrBuilder)stubWithMetadata.createTaskPushNotificationConfig(grpcRequest));
        }
        catch (StatusException | StatusRuntimeException e) {
            throw GrpcErrorMapper.mapGrpcError(e, "Failed to create task push notification config: ");
        }
    }

    public TaskPushNotificationConfig getTaskPushNotificationConfiguration(GetTaskPushNotificationConfigParams request, @Nullable ClientCallContext context) throws A2AClientException {
        Assert.checkNotNullParam((String)"request", (Object)request);
        Assert.checkNotNullParam((String)"taskId", (Object)request.id());
        if (request.pushNotificationConfigId() == null) {
            throw new IllegalArgumentException("Id must not be null");
        }
        GetTaskPushNotificationConfigRequest grpcRequest = GetTaskPushNotificationConfigRequest.newBuilder().setTaskId(request.id()).setTenant(this.resolveTenant(request.tenant())).setId(request.pushNotificationConfigId()).build();
        PayloadAndHeaders payloadAndHeaders = this.applyInterceptors("GetTaskPushNotificationConfig", grpcRequest, this.agentCard, context);
        try {
            A2AServiceGrpc.A2AServiceBlockingV2Stub stubWithMetadata = this.createBlockingStubWithMetadata(context, payloadAndHeaders);
            return ProtoUtils.FromProto.taskPushNotificationConfig((TaskPushNotificationConfigOrBuilder)stubWithMetadata.getTaskPushNotificationConfig(grpcRequest));
        }
        catch (StatusException | StatusRuntimeException e) {
            throw GrpcErrorMapper.mapGrpcError(e, "Failed to get task push notification config: ");
        }
    }

    public ListTaskPushNotificationConfigResult listTaskPushNotificationConfigurations(ListTaskPushNotificationConfigParams request, @Nullable ClientCallContext context) throws A2AClientException {
        Assert.checkNotNullParam((String)"request", (Object)request);
        ListTaskPushNotificationConfigRequest grpcRequest = ListTaskPushNotificationConfigRequest.newBuilder().setTaskId(request.id()).setTenant(this.resolveTenant(request.tenant())).setPageSize(request.pageSize()).setPageToken(request.pageToken()).build();
        PayloadAndHeaders payloadAndHeaders = this.applyInterceptors("ListTaskPushNotificationConfig", grpcRequest, this.agentCard, context);
        try {
            A2AServiceGrpc.A2AServiceBlockingV2Stub stubWithMetadata = this.createBlockingStubWithMetadata(context, payloadAndHeaders);
            ListTaskPushNotificationConfigResponse grpcResponse = stubWithMetadata.listTaskPushNotificationConfig(grpcRequest);
            return ProtoUtils.FromProto.listTaskPushNotificationConfigResult((ListTaskPushNotificationConfigResponseOrBuilder)grpcResponse);
        }
        catch (StatusException | StatusRuntimeException e) {
            throw GrpcErrorMapper.mapGrpcError(e, "Failed to list task push notification config: ");
        }
    }

    public void deleteTaskPushNotificationConfigurations(DeleteTaskPushNotificationConfigParams request, @Nullable ClientCallContext context) throws A2AClientException {
        Assert.checkNotNullParam((String)"request", (Object)request);
        DeleteTaskPushNotificationConfigRequest grpcRequest = DeleteTaskPushNotificationConfigRequest.newBuilder().setTaskId(request.id()).setId(request.pushNotificationConfigId()).setTenant(this.resolveTenant(request.tenant())).build();
        PayloadAndHeaders payloadAndHeaders = this.applyInterceptors("DeleteTaskPushNotificationConfig", grpcRequest, this.agentCard, context);
        try {
            A2AServiceGrpc.A2AServiceBlockingV2Stub stubWithMetadata = this.createBlockingStubWithMetadata(context, payloadAndHeaders);
            stubWithMetadata.deleteTaskPushNotificationConfig(grpcRequest);
        }
        catch (StatusException | StatusRuntimeException e) {
            throw GrpcErrorMapper.mapGrpcError(e, "Failed to delete task push notification config: ");
        }
    }

    public void subscribeToTask(TaskIdParams request, Consumer<StreamingEventKind> eventConsumer, Consumer<Throwable> errorConsumer, @Nullable ClientCallContext context) throws A2AClientException {
        Assert.checkNotNullParam((String)"request", (Object)request);
        Assert.checkNotNullParam((String)"eventConsumer", eventConsumer);
        SubscribeToTaskRequest grpcRequest = SubscribeToTaskRequest.newBuilder().setTenant(this.resolveTenant(request.tenant())).setId(request.id()).build();
        PayloadAndHeaders payloadAndHeaders = this.applyInterceptors("SubscribeToTask", grpcRequest, this.agentCard, context);
        EventStreamObserver streamObserver = new EventStreamObserver(eventConsumer, errorConsumer);
        try {
            A2AServiceGrpc.A2AServiceStub stubWithMetadata = this.createAsyncStubWithMetadata(context, payloadAndHeaders);
            stubWithMetadata.subscribeToTask(grpcRequest, (StreamObserver)streamObserver);
        }
        catch (StatusRuntimeException e) {
            throw GrpcErrorMapper.mapGrpcError(e, "Failed to subscribe task push notification config: ");
        }
    }

    private MessageSendParams createRequestWithTenant(MessageSendParams request) {
        return MessageSendParams.builder().configuration(request.configuration()).message(request.message()).metadata(request.metadata()).tenant(this.resolveTenant(request.tenant())).build();
    }

    public AgentCard getExtendedAgentCard(@Nullable ClientCallContext context) throws A2AClientException {
        GetExtendedAgentCardRequest request = GetExtendedAgentCardRequest.newBuilder().build();
        PayloadAndHeaders payloadAndHeaders = this.applyInterceptors("GetExtendedAgentCard", request, this.agentCard, context);
        try {
            A2AServiceGrpc.A2AServiceBlockingV2Stub stubWithMetadata = this.createBlockingStubWithMetadata(context, payloadAndHeaders);
            io.a2a.grpc.AgentCard response = stubWithMetadata.getExtendedAgentCard(request);
            return ProtoUtils.FromProto.agentCard((AgentCardOrBuilder)response);
        }
        catch (StatusException | StatusRuntimeException e) {
            throw GrpcErrorMapper.mapGrpcError(e, "Failed to get extended agent card: ");
        }
    }

    public void close() {
    }

    private SendMessageRequest createGrpcSendMessageRequest(MessageSendParams messageSendParams, @Nullable ClientCallContext context) {
        return ProtoUtils.ToProto.sendMessageRequest((MessageSendParams)messageSendParams);
    }

    private Metadata createGrpcMetadata(@Nullable ClientCallContext context, @Nullable PayloadAndHeaders payloadAndHeaders) {
        Metadata metadata = new Metadata();
        if (context != null && context.getHeaders() != null) {
            String extensionsHeader;
            String versionHeader = (String)context.getHeaders().get("X-A2A-Version");
            if (versionHeader != null) {
                metadata.put(VERSION_KEY, (Object)versionHeader);
            }
            if ((extensionsHeader = (String)context.getHeaders().get("X-A2A-Extensions")) != null) {
                metadata.put(EXTENSIONS_KEY, (Object)extensionsHeader);
            }
        }
        if (payloadAndHeaders != null && payloadAndHeaders.getHeaders() != null) {
            for (Map.Entry headerEntry : payloadAndHeaders.getHeaders().entrySet()) {
                String headerName = (String)headerEntry.getKey();
                String headerValue = (String)headerEntry.getValue();
                if (headerValue == null) continue;
                if ("Authorization".equals(headerName)) {
                    metadata.put(AUTHORIZATION_METADATA_KEY, (Object)headerValue);
                    continue;
                }
                Metadata.Key metadataKey = Metadata.Key.of((String)headerName, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
                metadata.put(metadataKey, (Object)headerValue);
            }
        }
        return metadata;
    }

    private A2AServiceGrpc.A2AServiceBlockingV2Stub createBlockingStubWithMetadata(@Nullable ClientCallContext context, PayloadAndHeaders payloadAndHeaders) {
        Metadata metadata = this.createGrpcMetadata(context, payloadAndHeaders);
        return (A2AServiceGrpc.A2AServiceBlockingV2Stub)this.blockingStub.withInterceptors(new ClientInterceptor[]{MetadataUtils.newAttachHeadersInterceptor((Metadata)metadata)});
    }

    private A2AServiceGrpc.A2AServiceStub createAsyncStubWithMetadata(@Nullable ClientCallContext context, PayloadAndHeaders payloadAndHeaders) {
        Metadata metadata = this.createGrpcMetadata(context, payloadAndHeaders);
        return (A2AServiceGrpc.A2AServiceStub)this.asyncStub.withInterceptors(new ClientInterceptor[]{MetadataUtils.newAttachHeadersInterceptor((Metadata)metadata)});
    }

    private PayloadAndHeaders applyInterceptors(String methodName, Object payload, AgentCard agentCard, @Nullable ClientCallContext clientCallContext) {
        PayloadAndHeaders payloadAndHeaders = new PayloadAndHeaders(payload, clientCallContext != null ? clientCallContext.getHeaders() : null);
        if (this.interceptors != null && !this.interceptors.isEmpty()) {
            for (ClientCallInterceptor interceptor : this.interceptors) {
                payloadAndHeaders = interceptor.intercept(methodName, payloadAndHeaders.getPayload(), payloadAndHeaders.getHeaders(), agentCard, clientCallContext);
            }
        }
        return payloadAndHeaders;
    }
}

