/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.client.transport.grpc;

import io.a2a.client.transport.grpc.EventStreamObserver;
import io.a2a.client.transport.grpc.GrpcErrorMapper;
import io.a2a.client.transport.spi.ClientTransport;
import io.a2a.client.transport.spi.interceptors.ClientCallContext;
import io.a2a.grpc.A2AServiceGrpc;
import io.a2a.grpc.CancelTaskRequest;
import io.a2a.grpc.CreateTaskPushNotificationConfigRequest;
import io.a2a.grpc.DeleteTaskPushNotificationConfigRequest;
import io.a2a.grpc.GetTaskPushNotificationConfigRequest;
import io.a2a.grpc.GetTaskRequest;
import io.a2a.grpc.ListTaskPushNotificationConfigRequest;
import io.a2a.grpc.SendMessageRequest;
import io.a2a.grpc.SendMessageResponse;
import io.a2a.grpc.Task;
import io.a2a.grpc.TaskPushNotificationConfigOrBuilder;
import io.a2a.grpc.TaskSubscriptionRequest;
import io.a2a.grpc.utils.ProtoUtils;
import io.a2a.spec.A2AClientException;
import io.a2a.spec.AgentCard;
import io.a2a.spec.DeleteTaskPushNotificationConfigParams;
import io.a2a.spec.EventKind;
import io.a2a.spec.GetTaskPushNotificationConfigParams;
import io.a2a.spec.ListTaskPushNotificationConfigParams;
import io.a2a.spec.Message;
import io.a2a.spec.MessageSendConfiguration;
import io.a2a.spec.MessageSendParams;
import io.a2a.spec.StreamingEventKind;
import io.a2a.spec.TaskIdParams;
import io.a2a.spec.TaskPushNotificationConfig;
import io.a2a.spec.TaskQueryParams;
import io.a2a.util.Assert;
import io.grpc.Channel;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class GrpcTransport
implements ClientTransport {
    private final A2AServiceGrpc.A2AServiceBlockingV2Stub blockingStub;
    private final A2AServiceGrpc.A2AServiceStub asyncStub;
    private AgentCard agentCard;

    public GrpcTransport(Channel channel, AgentCard agentCard) {
        Assert.checkNotNullParam((String)"channel", (Object)channel);
        this.asyncStub = A2AServiceGrpc.newStub((Channel)channel);
        this.blockingStub = A2AServiceGrpc.newBlockingV2Stub((Channel)channel);
        this.agentCard = agentCard;
    }

    public EventKind sendMessage(MessageSendParams request, ClientCallContext context) throws A2AClientException {
        Assert.checkNotNullParam((String)"request", (Object)request);
        SendMessageRequest sendMessageRequest = this.createGrpcSendMessageRequest(request, context);
        try {
            SendMessageResponse response = this.blockingStub.sendMessage(sendMessageRequest);
            if (response.hasMsg()) {
                return ProtoUtils.FromProto.message((io.a2a.grpc.Message)response.getMsg());
            }
            if (response.hasTask()) {
                return ProtoUtils.FromProto.task((Task)response.getTask());
            }
            throw new A2AClientException("Server response did not contain a message or task");
        }
        catch (StatusRuntimeException e) {
            throw GrpcErrorMapper.mapGrpcError(e, "Failed to send message: ");
        }
    }

    public void sendMessageStreaming(MessageSendParams request, Consumer<StreamingEventKind> eventConsumer, Consumer<Throwable> errorConsumer, ClientCallContext context) throws A2AClientException {
        Assert.checkNotNullParam((String)"request", (Object)request);
        Assert.checkNotNullParam((String)"eventConsumer", eventConsumer);
        SendMessageRequest grpcRequest = this.createGrpcSendMessageRequest(request, context);
        EventStreamObserver streamObserver = new EventStreamObserver(eventConsumer, errorConsumer);
        try {
            this.asyncStub.sendStreamingMessage(grpcRequest, (StreamObserver)streamObserver);
        }
        catch (StatusRuntimeException e) {
            throw GrpcErrorMapper.mapGrpcError(e, "Failed to send streaming message request: ");
        }
    }

    public io.a2a.spec.Task getTask(TaskQueryParams request, ClientCallContext context) throws A2AClientException {
        Assert.checkNotNullParam((String)"request", (Object)request);
        GetTaskRequest.Builder requestBuilder = GetTaskRequest.newBuilder();
        requestBuilder.setName("tasks/" + request.id());
        if (request.historyLength() != null) {
            requestBuilder.setHistoryLength(request.historyLength().intValue());
        }
        GetTaskRequest getTaskRequest = requestBuilder.build();
        try {
            return ProtoUtils.FromProto.task((Task)this.blockingStub.getTask(getTaskRequest));
        }
        catch (StatusRuntimeException e) {
            throw GrpcErrorMapper.mapGrpcError(e, "Failed to get task: ");
        }
    }

    public io.a2a.spec.Task cancelTask(TaskIdParams request, ClientCallContext context) throws A2AClientException {
        Assert.checkNotNullParam((String)"request", (Object)request);
        CancelTaskRequest cancelTaskRequest = CancelTaskRequest.newBuilder().setName("tasks/" + request.id()).build();
        try {
            return ProtoUtils.FromProto.task((Task)this.blockingStub.cancelTask(cancelTaskRequest));
        }
        catch (StatusRuntimeException e) {
            throw GrpcErrorMapper.mapGrpcError(e, "Failed to cancel task: ");
        }
    }

    public TaskPushNotificationConfig setTaskPushNotificationConfiguration(TaskPushNotificationConfig request, ClientCallContext context) throws A2AClientException {
        Assert.checkNotNullParam((String)"request", (Object)request);
        String configId = request.pushNotificationConfig().id();
        CreateTaskPushNotificationConfigRequest grpcRequest = CreateTaskPushNotificationConfigRequest.newBuilder().setParent("tasks/" + request.taskId()).setConfig(ProtoUtils.ToProto.taskPushNotificationConfig((TaskPushNotificationConfig)request)).setConfigId(configId != null ? configId : request.taskId()).build();
        try {
            return ProtoUtils.FromProto.taskPushNotificationConfig((TaskPushNotificationConfigOrBuilder)this.blockingStub.createTaskPushNotificationConfig(grpcRequest));
        }
        catch (StatusRuntimeException e) {
            throw GrpcErrorMapper.mapGrpcError(e, "Failed to create task push notification config: ");
        }
    }

    public TaskPushNotificationConfig getTaskPushNotificationConfiguration(GetTaskPushNotificationConfigParams request, ClientCallContext context) throws A2AClientException {
        Assert.checkNotNullParam((String)"request", (Object)request);
        GetTaskPushNotificationConfigRequest grpcRequest = GetTaskPushNotificationConfigRequest.newBuilder().setName(this.getTaskPushNotificationConfigName(request)).build();
        try {
            return ProtoUtils.FromProto.taskPushNotificationConfig((TaskPushNotificationConfigOrBuilder)this.blockingStub.getTaskPushNotificationConfig(grpcRequest));
        }
        catch (StatusRuntimeException e) {
            throw GrpcErrorMapper.mapGrpcError(e, "Failed to get task push notification config: ");
        }
    }

    public List<TaskPushNotificationConfig> listTaskPushNotificationConfigurations(ListTaskPushNotificationConfigParams request, ClientCallContext context) throws A2AClientException {
        Assert.checkNotNullParam((String)"request", (Object)request);
        ListTaskPushNotificationConfigRequest grpcRequest = ListTaskPushNotificationConfigRequest.newBuilder().setParent("tasks/" + request.id()).build();
        try {
            return this.blockingStub.listTaskPushNotificationConfig(grpcRequest).getConfigsList().stream().map(ProtoUtils.FromProto::taskPushNotificationConfig).collect(Collectors.toList());
        }
        catch (StatusRuntimeException e) {
            throw GrpcErrorMapper.mapGrpcError(e, "Failed to list task push notification config: ");
        }
    }

    public void deleteTaskPushNotificationConfigurations(DeleteTaskPushNotificationConfigParams request, ClientCallContext context) throws A2AClientException {
        Assert.checkNotNullParam((String)"request", (Object)request);
        DeleteTaskPushNotificationConfigRequest grpcRequest = DeleteTaskPushNotificationConfigRequest.newBuilder().setName(this.getTaskPushNotificationConfigName(request.id(), request.pushNotificationConfigId())).build();
        try {
            this.blockingStub.deleteTaskPushNotificationConfig(grpcRequest);
        }
        catch (StatusRuntimeException e) {
            throw GrpcErrorMapper.mapGrpcError(e, "Failed to delete task push notification config: ");
        }
    }

    public void resubscribe(TaskIdParams request, Consumer<StreamingEventKind> eventConsumer, Consumer<Throwable> errorConsumer, ClientCallContext context) throws A2AClientException {
        Assert.checkNotNullParam((String)"request", (Object)request);
        Assert.checkNotNullParam((String)"eventConsumer", eventConsumer);
        TaskSubscriptionRequest grpcRequest = TaskSubscriptionRequest.newBuilder().setName("tasks/" + request.id()).build();
        EventStreamObserver streamObserver = new EventStreamObserver(eventConsumer, errorConsumer);
        try {
            this.asyncStub.taskSubscription(grpcRequest, (StreamObserver)streamObserver);
        }
        catch (StatusRuntimeException e) {
            throw GrpcErrorMapper.mapGrpcError(e, "Failed to resubscribe task push notification config: ");
        }
    }

    public AgentCard getAgentCard(ClientCallContext context) throws A2AClientException {
        return this.agentCard;
    }

    public void close() {
    }

    private SendMessageRequest createGrpcSendMessageRequest(MessageSendParams messageSendParams, ClientCallContext context) {
        SendMessageRequest.Builder builder = SendMessageRequest.newBuilder();
        builder.setRequest(ProtoUtils.ToProto.message((Message)messageSendParams.message()));
        if (messageSendParams.configuration() != null) {
            builder.setConfiguration(ProtoUtils.ToProto.messageSendConfiguration((MessageSendConfiguration)messageSendParams.configuration()));
        }
        if (messageSendParams.metadata() != null) {
            builder.setMetadata(ProtoUtils.ToProto.struct((Map)messageSendParams.metadata()));
        }
        return builder.build();
    }

    private String getTaskPushNotificationConfigName(GetTaskPushNotificationConfigParams params) {
        return this.getTaskPushNotificationConfigName(params.id(), params.pushNotificationConfigId());
    }

    private String getTaskPushNotificationConfigName(String taskId, String pushNotificationConfigId) {
        StringBuilder name = new StringBuilder();
        name.append("tasks/");
        name.append(taskId);
        if (pushNotificationConfigId != null) {
            name.append("/pushNotificationConfigs/");
            name.append(pushNotificationConfigId);
        }
        return name.toString();
    }
}

