/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.client.transport.grpc;

import io.a2a.client.transport.grpc.GrpcErrorMapper;
import io.a2a.grpc.StreamResponse;
import io.a2a.grpc.Task;
import io.a2a.grpc.TaskArtifactUpdateEvent;
import io.a2a.grpc.TaskStatusUpdateEvent;
import io.a2a.grpc.utils.ProtoUtils;
import io.a2a.spec.Message;
import io.a2a.spec.StreamingEventKind;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.util.function.Consumer;
import java.util.logging.Logger;

public class EventStreamObserver
implements StreamObserver<StreamResponse> {
    private static final Logger log = Logger.getLogger(EventStreamObserver.class.getName());
    private final Consumer<StreamingEventKind> eventHandler;
    private final Consumer<Throwable> errorHandler;

    public EventStreamObserver(Consumer<StreamingEventKind> eventHandler, Consumer<Throwable> errorHandler) {
        this.eventHandler = eventHandler;
        this.errorHandler = errorHandler;
    }

    public void onNext(StreamResponse response) {
        Message event;
        switch (response.getPayloadCase()) {
            case MSG: {
                event = ProtoUtils.FromProto.message((io.a2a.grpc.Message)response.getMsg());
                break;
            }
            case TASK: {
                event = ProtoUtils.FromProto.task((Task)response.getTask());
                break;
            }
            case STATUS_UPDATE: {
                event = ProtoUtils.FromProto.taskStatusUpdateEvent((TaskStatusUpdateEvent)response.getStatusUpdate());
                break;
            }
            case ARTIFACT_UPDATE: {
                event = ProtoUtils.FromProto.taskArtifactUpdateEvent((TaskArtifactUpdateEvent)response.getArtifactUpdate());
                break;
            }
            default: {
                log.warning("Invalid stream response " + String.valueOf(response.getPayloadCase()));
                this.errorHandler.accept(new IllegalStateException("Invalid stream response from server: " + String.valueOf(response.getPayloadCase())));
                return;
            }
        }
        this.eventHandler.accept((StreamingEventKind)event);
    }

    public void onError(Throwable t) {
        if (this.errorHandler != null) {
            if (t instanceof StatusRuntimeException) {
                this.errorHandler.accept((Throwable)GrpcErrorMapper.mapGrpcError((StatusRuntimeException)t));
            } else {
                this.errorHandler.accept(t);
            }
        }
    }

    public void onCompleted() {
    }
}

