/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.extras.queuemanager.replicated.core;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import io.a2a.server.events.EventQueueItem;
import io.a2a.server.events.QueueClosedEvent;
import io.a2a.spec.Event;
import io.a2a.spec.JSONRPCError;
import io.a2a.spec.StreamingEventKind;

public class ReplicatedEventQueueItem
implements EventQueueItem {
    private String taskId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private StreamingEventKind event;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private JSONRPCError error;
    private boolean closedEvent;

    public ReplicatedEventQueueItem() {
    }

    public ReplicatedEventQueueItem(String taskId, StreamingEventKind event) {
        this.taskId = taskId;
        this.event = event;
        this.error = null;
    }

    public ReplicatedEventQueueItem(String taskId, JSONRPCError error) {
        this.taskId = taskId;
        this.event = null;
        this.error = error;
    }

    public ReplicatedEventQueueItem(String taskId, Event event) {
        this.taskId = taskId;
        if (event instanceof QueueClosedEvent) {
            this.event = null;
            this.error = null;
            this.closedEvent = true;
        } else if (event instanceof StreamingEventKind) {
            StreamingEventKind streamingEvent;
            this.event = streamingEvent = (StreamingEventKind)event;
            this.error = null;
            this.closedEvent = false;
        } else if (event instanceof JSONRPCError) {
            JSONRPCError jsonRpcError = (JSONRPCError)event;
            this.event = null;
            this.error = jsonRpcError;
            this.closedEvent = false;
        } else {
            throw new IllegalArgumentException("Event must be StreamingEventKind, JSONRPCError, or QueueClosedEvent, got: " + String.valueOf(event.getClass()));
        }
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    @JsonGetter(value="event")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public StreamingEventKind getStreamingEvent() {
        return this.event;
    }

    @JsonSetter(value="event")
    public void setEvent(StreamingEventKind event) {
        this.event = event;
        this.error = null;
    }

    @JsonGetter(value="error")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public JSONRPCError getErrorObject() {
        return this.error;
    }

    @JsonSetter(value="error")
    public void setError(JSONRPCError error) {
        this.error = error;
        this.event = null;
    }

    @JsonIgnore
    public Event getEvent() {
        if (this.closedEvent) {
            return new QueueClosedEvent(this.taskId);
        }
        if (this.event != null) {
            return this.event;
        }
        return this.error;
    }

    @JsonIgnore
    public boolean isReplicated() {
        return true;
    }

    public boolean hasEvent() {
        return this.event != null;
    }

    public boolean hasError() {
        return this.error != null;
    }

    @JsonGetter(value="closedEvent")
    public boolean isClosedEvent() {
        return this.closedEvent;
    }

    @JsonSetter(value="closedEvent")
    public void setClosedEvent(boolean closedEvent) {
        this.closedEvent = closedEvent;
        if (closedEvent) {
            this.event = null;
            this.error = null;
        }
    }

    public String toString() {
        return "ReplicatedEventQueueItem{taskId='" + this.taskId + "', event=" + String.valueOf(this.event) + ", error=" + String.valueOf(this.error) + ", closedEvent=" + this.closedEvent + "}";
    }
}

