/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.extras.queuemanager.replicated.core;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.a2a.spec.Event;
import io.a2a.spec.JSONRPCError;
import io.a2a.spec.StreamingEventKind;

public class ReplicatedEvent {
    private String taskId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private StreamingEventKind event;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private JSONRPCError error;

    public ReplicatedEvent() {
    }

    public ReplicatedEvent(String taskId, StreamingEventKind event) {
        this.taskId = taskId;
        this.event = event;
        this.error = null;
    }

    public ReplicatedEvent(String taskId, JSONRPCError error) {
        this.taskId = taskId;
        this.event = null;
        this.error = error;
    }

    public ReplicatedEvent(String taskId, Event event) {
        this.taskId = taskId;
        if (event instanceof StreamingEventKind) {
            StreamingEventKind streamingEvent;
            this.event = streamingEvent = (StreamingEventKind)event;
            this.error = null;
        } else if (event instanceof JSONRPCError) {
            JSONRPCError jsonRpcError = (JSONRPCError)event;
            this.event = null;
            this.error = jsonRpcError;
        } else {
            throw new IllegalArgumentException("Event must be either StreamingEventKind or JSONRPCError, got: " + String.valueOf(event.getClass()));
        }
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public StreamingEventKind getEvent() {
        return this.event;
    }

    public void setEvent(StreamingEventKind event) {
        this.event = event;
        this.error = null;
    }

    public JSONRPCError getError() {
        return this.error;
    }

    public void setError(JSONRPCError error) {
        this.error = error;
        this.event = null;
    }

    @JsonIgnore
    public Event getEventAsGeneric() {
        if (this.event != null) {
            return this.event;
        }
        return this.error;
    }

    public boolean hasEvent() {
        return this.event != null;
    }

    public boolean hasError() {
        return this.error != null;
    }

    public String toString() {
        return "ReplicatedEvent{taskId='" + this.taskId + "', event=" + String.valueOf(this.event) + ", error=" + String.valueOf(this.error) + "}";
    }
}

