/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.extras.pushnotificationconfigstore.database.jpa;

import io.a2a.extras.pushnotificationconfigstore.database.jpa.JpaPushNotificationConfig;
import io.a2a.extras.pushnotificationconfigstore.database.jpa.TaskConfigId;
import io.a2a.jsonrpc.common.json.JsonProcessingException;
import io.a2a.server.tasks.PushNotificationConfigStore;
import io.a2a.spec.InvalidParamsError;
import io.a2a.spec.ListTaskPushNotificationConfigParams;
import io.a2a.spec.ListTaskPushNotificationConfigResult;
import io.a2a.spec.PushNotificationConfig;
import io.a2a.spec.TaskPushNotificationConfig;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Alternative;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.TypedQuery;
import jakarta.transaction.Transactional;
import java.time.Instant;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Alternative
@Priority(value=50)
public class JpaDatabasePushNotificationConfigStore
implements PushNotificationConfigStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(JpaDatabasePushNotificationConfigStore.class);
    private static final Instant NULL_TIMESTAMP_SENTINEL = Instant.EPOCH;
    @PersistenceContext(unitName="a2a-java")
    EntityManager em;

    @Transactional
    public PushNotificationConfig setInfo(String taskId, PushNotificationConfig notificationConfig) {
        PushNotificationConfig.Builder builder = PushNotificationConfig.builder((PushNotificationConfig)notificationConfig);
        if (notificationConfig.id() == null || notificationConfig.id().isEmpty()) {
            builder.id(taskId);
        }
        notificationConfig = builder.build();
        LOGGER.debug("Saving PushNotificationConfig for Task '{}' with ID: {}", (Object)taskId, (Object)notificationConfig.id());
        try {
            TaskConfigId configId = new TaskConfigId(taskId, notificationConfig.id());
            JpaPushNotificationConfig existingJpaConfig = (JpaPushNotificationConfig)this.em.find(JpaPushNotificationConfig.class, (Object)configId);
            if (existingJpaConfig != null) {
                existingJpaConfig.setConfig(notificationConfig);
                LOGGER.debug("Updated existing PushNotificationConfig for Task '{}' with ID: {}", (Object)taskId, (Object)notificationConfig.id());
            } else {
                JpaPushNotificationConfig jpaConfig = JpaPushNotificationConfig.createFromConfig(taskId, notificationConfig);
                this.em.persist((Object)jpaConfig);
                LOGGER.debug("Persisted new PushNotificationConfig for Task '{}' with ID: {}", (Object)taskId, (Object)notificationConfig.id());
            }
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Failed to serialize PushNotificationConfig for Task '{}' with ID: {}", new Object[]{taskId, notificationConfig.id(), e});
            throw new RuntimeException("Failed to serialize PushNotificationConfig for Task '" + taskId + "' with ID: " + notificationConfig.id(), e);
        }
        return notificationConfig;
    }

    @Transactional
    public ListTaskPushNotificationConfigResult getInfo(ListTaskPushNotificationConfigParams params) {
        String taskId = params.id();
        LOGGER.debug("Retrieving PushNotificationConfigs for Task '{}' with params: pageSize={}, pageToken={}", new Object[]{taskId, params.pageSize(), params.pageToken()});
        try {
            String[] tokenParts;
            String[] tokenParts2;
            StringBuilder queryBuilder = new StringBuilder("SELECT c FROM JpaPushNotificationConfig c WHERE c.id.taskId = :taskId");
            if (params.pageToken() != null && !params.pageToken().isEmpty() && (tokenParts2 = params.pageToken().split(":", 2)).length == 2) {
                queryBuilder.append(" AND (COALESCE(c.createdAt, :nullSentinel) < :tokenTimestamp OR (COALESCE(c.createdAt, :nullSentinel) = :tokenTimestamp AND c.id.configId > :tokenId))");
            }
            queryBuilder.append(" ORDER BY  COALESCE(c.createdAt, :nullSentinel) DESC, c.id.configId ASC");
            TypedQuery query = this.em.createQuery(queryBuilder.toString(), JpaPushNotificationConfig.class);
            query.setParameter("taskId", (Object)taskId);
            query.setParameter("nullSentinel", (Object)NULL_TIMESTAMP_SENTINEL);
            if (params.pageToken() != null && !params.pageToken().isEmpty() && (tokenParts = params.pageToken().split(":", 2)).length == 2) {
                try {
                    long timestampMillis = Long.parseLong(tokenParts[0]);
                    String tokenId = tokenParts[1];
                    Instant tokenTimestamp = Instant.ofEpochMilli(timestampMillis);
                    query.setParameter("tokenTimestamp", (Object)tokenTimestamp);
                    query.setParameter("tokenId", (Object)tokenId);
                }
                catch (NumberFormatException e) {
                    throw new InvalidParamsError(null, "Invalid pageToken format: timestamp must be numeric milliseconds", null);
                }
            }
            int pageSize = params.getEffectivePageSize();
            query.setMaxResults(pageSize + 1);
            List jpaConfigsPage = query.getResultList();
            String nextPageToken = null;
            if (jpaConfigsPage.size() > pageSize) {
                JpaPushNotificationConfig lastConfig = (JpaPushNotificationConfig)(jpaConfigsPage = jpaConfigsPage.subList(0, pageSize)).get(jpaConfigsPage.size() - 1);
                Instant timestamp = lastConfig.getCreatedAt() != null ? lastConfig.getCreatedAt() : NULL_TIMESTAMP_SENTINEL;
                nextPageToken = timestamp.toEpochMilli() + ":" + lastConfig.getId().getConfigId();
            }
            List<PushNotificationConfig> configs = jpaConfigsPage.stream().map(jpaConfig -> {
                try {
                    return jpaConfig.getConfig();
                }
                catch (JsonProcessingException e) {
                    LOGGER.error("Failed to deserialize PushNotificationConfig for Task '{}' with ID: {}", new Object[]{taskId, jpaConfig.getId().getConfigId(), e});
                    throw new RuntimeException("Failed to deserialize PushNotificationConfig for Task '" + taskId + "' with ID: " + jpaConfig.getId().getConfigId(), e);
                }
            }).toList();
            LOGGER.debug("Successfully retrieved {} PushNotificationConfigs for Task '{}'", (Object)configs.size(), (Object)taskId);
            List taskPushNotificationConfigs = configs.stream().map(config -> new TaskPushNotificationConfig(params.id(), config, params.tenant())).collect(Collectors.toList());
            return new ListTaskPushNotificationConfigResult(taskPushNotificationConfigs, nextPageToken);
        }
        catch (Exception e) {
            LOGGER.error("Failed to retrieve PushNotificationConfigs for Task '{}'", (Object)taskId, (Object)e);
            throw e;
        }
    }

    @Transactional
    public void deleteInfo(String taskId, String configId) {
        if (configId == null) {
            configId = taskId;
        }
        LOGGER.debug("Deleting PushNotificationConfig for Task '{}' with Config ID: {}", (Object)taskId, (Object)configId);
        JpaPushNotificationConfig jpaConfig = (JpaPushNotificationConfig)this.em.find(JpaPushNotificationConfig.class, (Object)new TaskConfigId(taskId, configId));
        if (jpaConfig != null) {
            this.em.remove((Object)jpaConfig);
            LOGGER.debug("Successfully deleted PushNotificationConfig for Task '{}' with Config ID: {}", (Object)taskId, (Object)configId);
        } else {
            LOGGER.debug("PushNotificationConfig not found for deletion with Task '{}' and Config ID: {}", (Object)taskId, (Object)configId);
        }
    }
}

