/*
 * Decompiled with CFR 0.152.
 */
package io.a2a.bom.test;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;

public abstract class DynamicBomVerifier {
    private final Set<String> excludedPaths;
    private final Set<String> forbiddenPaths;
    private static final Pattern PACKAGE_PATTERN = Pattern.compile("^package\\s+([a-zA-Z0-9_.]+);");

    protected DynamicBomVerifier(Set<String> excludedPaths, Set<String> forbiddenPaths) {
        this.excludedPaths = excludedPaths;
        this.forbiddenPaths = forbiddenPaths;
    }

    protected DynamicBomVerifier(Set<String> excludedPaths) {
        this(excludedPaths, Set.of());
    }

    public void verify() throws Exception {
        Path projectRoot = null;
        for (Path current = Paths.get("", new String[0]).toAbsolutePath(); current != null; current = current.getParent()) {
            if (!Files.isDirectory(current, new LinkOption[0]) || !Files.exists(current.resolve("pom.xml"), new LinkOption[0]) || !Files.exists(current.resolve("boms"), new LinkOption[0])) continue;
            projectRoot = current;
            break;
        }
        if (projectRoot == null) {
            throw new IllegalStateException("Could not find project root directory.");
        }
        System.out.println("Scanning project root: " + String.valueOf(projectRoot));
        Set<String> requiredClasses = this.discoverRequiredClasses(projectRoot);
        Set<String> forbiddenClasses = this.discoverForbiddenClasses(projectRoot);
        System.out.println("Discovered " + requiredClasses.size() + " required classes to verify");
        System.out.println("Discovered " + forbiddenClasses.size() + " forbidden classes to verify");
        this.sanityCheckDiscovery(requiredClasses, forbiddenClasses);
        ArrayList<CallSite> failures = new ArrayList<CallSite>();
        int successful = 0;
        for (String className : requiredClasses) {
            try {
                Class.forName(className);
                ++successful;
            }
            catch (ClassNotFoundException e) {
                failures.add((CallSite)((Object)("[REQUIRED] " + className + " - NOT FOUND")));
            }
            catch (NoClassDefFoundError e) {
                failures.add((CallSite)((Object)("[REQUIRED] " + className + " - MISSING DEPENDENCY: " + e.getMessage())));
            }
            catch (Exception e) {
                failures.add((CallSite)((Object)("[REQUIRED] " + className + " - ERROR: " + e.getMessage())));
            }
        }
        int correctlyForbidden = 0;
        for (String className : forbiddenClasses) {
            try {
                Class.forName(className);
                failures.add((CallSite)((Object)("[FORBIDDEN] " + className + " - INCORRECTLY LOADABLE (BOM includes dependency it shouldn't!)")));
            }
            catch (ClassNotFoundException | NoClassDefFoundError e) {
                ++correctlyForbidden;
            }
            catch (Exception e) {
                failures.add((CallSite)((Object)("[FORBIDDEN] " + className + " - UNEXPECTED ERROR: " + e.getMessage())));
            }
        }
        System.out.println("\n=== BOM Verification Results ===");
        System.out.println("Required classes successfully loaded: " + successful + "/" + requiredClasses.size());
        System.out.println("Forbidden classes correctly not loadable: " + correctlyForbidden + "/" + forbiddenClasses.size());
        System.out.println("Total failures: " + failures.size());
        if (!failures.isEmpty()) {
            System.err.println("\n=== FAILURES ===");
            failures.forEach(System.err::println);
            System.err.println("\nBOM verification FAILED!");
            System.exit(1);
        }
        System.out.println("\n\u2705 BOM is COMPLETE - all required classes loaded, all forbidden classes not loadable!");
    }

    private void sanityCheckDiscovery(Set<String> requiredClasses, Set<String> forbiddenClasses) {
        this.sanityCheckDiscovery("io.a2a.spec.AgentCard", requiredClasses, forbiddenClasses);
        this.sanityCheckDiscovery("io.a2a.server.events.EventConsumer", requiredClasses, forbiddenClasses);
        this.sanityCheckDiscovery("io.a2a.client.transport.spi.ClientTransport", requiredClasses, forbiddenClasses);
        this.sanityCheckDiscovery("io.a2a.server.common.quarkus.DefaultProducers", requiredClasses, forbiddenClasses);
        this.sanityCheckDiscovery("io.a2a.extras.common.events.TaskFinalizedEvent", requiredClasses, forbiddenClasses);
        this.sanityCheckDiscovery("io.a2a.extras.queuemanager.replicated.core.ReplicatedEventQueueItem", requiredClasses, forbiddenClasses);
        HashSet<String> intersection = new HashSet<String>(requiredClasses);
        intersection.retainAll(forbiddenClasses);
        if (!intersection.isEmpty()) {
            System.err.println("The following classes appear in both the required and forbidden sets: " + String.valueOf(intersection));
            System.exit(1);
        }
    }

    private void sanityCheckDiscovery(String className, Set<String> requiredClasses, Set<String> forbiddenClasses) {
        if (!requiredClasses.contains(className) && !forbiddenClasses.contains(className)) {
            System.err.println("Class expected to be on the classpath was not discovered: " + className);
            System.exit(1);
        }
    }

    private Set<String> discoverRequiredClasses(Path projectRoot) throws IOException {
        return this.discoverClasses(projectRoot, relativePath -> !this.isExcluded((String)relativePath) && !this.isForbidden((String)relativePath));
    }

    private Set<String> discoverForbiddenClasses(Path projectRoot) throws IOException {
        return this.discoverClasses(projectRoot, relativePath -> !this.isExcluded((String)relativePath) && this.isForbidden((String)relativePath));
    }

    private Set<String> discoverClasses(Path projectRoot, Predicate<String> pathFilter) throws IOException {
        TreeSet<String> classes = new TreeSet<String>();
        try (Stream<Path> paths = Files.walk(projectRoot, new FileVisitOption[0]);){
            paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> p.toString().endsWith(".java")).filter(p -> p.toString().contains("/src/main/java/")).filter(p -> pathFilter.test(projectRoot.relativize((Path)p).toString())).forEach(javaFile -> {
                try {
                    String className = DynamicBomVerifier.extractClassName(javaFile);
                    if (className != null) {
                        classes.add(className);
                    }
                }
                catch (IOException e) {
                    System.err.println("Failed to parse: " + String.valueOf(javaFile) + " - " + e.getMessage());
                }
            });
        }
        return classes;
    }

    private boolean isExcluded(String relativePath) {
        return this.excludedPaths.stream().anyMatch(relativePath::startsWith);
    }

    private boolean isForbidden(String relativePath) {
        return this.forbiddenPaths.stream().anyMatch(relativePath::startsWith);
    }

    private static @Nullable String extractClassName(Path javaFile) throws IOException {
        String fileName = javaFile.getFileName().toString();
        if (!fileName.endsWith(".java")) {
            return null;
        }
        String simpleClassName = fileName.substring(0, fileName.length() - 5);
        String packageName = null;
        try (Stream<String> lines = Files.lines(javaFile);){
            packageName = lines.map(String::trim).map(PACKAGE_PATTERN::matcher).filter(Matcher::matches).map(m -> m.group(1)).findFirst().orElse(null);
        }
        if (packageName != null) {
            return packageName + "." + simpleClassName;
        }
        return null;
    }
}

