/*
 * Decompiled with CFR 0.152.
 */
package com.ct.condition.core;

import com.ct.condition.core.Condition;
import com.ct.condition.core.Handler;
import com.ct.condition.core.JpaPlusException;
import com.ct.condition.core.SpecificationFactory;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Consumer;
import javax.persistence.criteria.Predicate;
import org.springframework.data.jpa.domain.Specification;

public abstract class AbstractCondition<Child extends AbstractCondition<Child, R, T>, R, T>
implements Condition<Child, R, T> {
    private final Child typedThis = this;
    private Specification<T> specification;
    private volatile Predicate.BooleanOperator operator;

    public AbstractCondition() {
        this(Predicate.BooleanOperator.AND);
    }

    private AbstractCondition(Predicate.BooleanOperator operator) {
        this.operator = operator;
        this.specification = (Specification & Serializable)(root, query, criteriaBuilder) -> null;
    }

    @Override
    public Specification<T> toSpec() {
        return this.specification;
    }

    @Override
    public Child and(Consumer<Child> consumer) {
        Child wrapper = this.instance();
        consumer.accept(wrapper);
        this.mergeSpecification(((AbstractCondition)wrapper).toSpec(), Predicate.BooleanOperator.AND);
        return this.typedThis;
    }

    protected abstract Child instance();

    @Override
    public Child or(Consumer<Child> consumer) {
        Child wrapper = this.instance();
        consumer.accept(wrapper);
        this.mergeSpecification(((AbstractCondition)wrapper).toSpec(), Predicate.BooleanOperator.OR);
        return this.typedThis;
    }

    @Override
    public Child or() {
        this.mergeSpecification(null, Predicate.BooleanOperator.OR);
        this.operator = Predicate.BooleanOperator.OR;
        return this.typedThis;
    }

    @Override
    public Child and() {
        this.mergeSpecification(null, Predicate.BooleanOperator.AND);
        this.operator = Predicate.BooleanOperator.AND;
        return this.typedThis;
    }

    @Override
    public <X extends Comparable<? super X>> Child ge(R field, X val) {
        this.specification = this.getSpecification(SpecificationFactory.createSpec(Handler.GE, this.columnToString(field), val));
        return this.typedThis;
    }

    protected String columnToString(R s) {
        return (String)s;
    }

    @Override
    public <X extends Comparable<? super X>> Child eq(R field, X val) {
        this.specification = this.getSpecification(SpecificationFactory.createSpec(Handler.EQUAL, this.columnToString(field), val));
        return this.typedThis;
    }

    @Override
    public <X extends Comparable<? super X>> Child notEq(R field, X val) {
        this.specification = this.getSpecification(SpecificationFactory.createSpec(Handler.NOT_EQUAL, this.columnToString(field), val));
        return this.typedThis;
    }

    @Override
    public <X extends Comparable<? super X>> Child gt(R field, X val) {
        this.specification = this.getSpecification(SpecificationFactory.createSpec(Handler.GT, this.columnToString(field), val));
        return this.typedThis;
    }

    @Override
    public <X extends Comparable<? super X>> Child lt(R field, X val) {
        this.specification = this.getSpecification(SpecificationFactory.createSpec(Handler.LT, this.columnToString(field), val));
        return this.typedThis;
    }

    @Override
    public <X extends Comparable<? super X>> Child le(R field, X val) {
        this.specification = this.getSpecification(SpecificationFactory.createSpec(Handler.LE, this.columnToString(field), val));
        return this.typedThis;
    }

    @Override
    public Child allLike(R field, String val) {
        this.specification = this.getSpecification(SpecificationFactory.createSpec(Handler.ALL_LIKE, this.columnToString(field), val));
        return this.typedThis;
    }

    @Override
    public Child rightLike(R field, String val) {
        this.specification = this.getSpecification(SpecificationFactory.createSpec(Handler.RIGHT_LIKE, this.columnToString(field), val));
        return this.typedThis;
    }

    @Override
    public Child leftLike(R field, String val) {
        this.specification = this.getSpecification(SpecificationFactory.createSpec(Handler.LEFT_LIKE, this.columnToString(field), val));
        return this.typedThis;
    }

    @Override
    public Child isNull(R field) {
        this.specification = this.getSpecification(SpecificationFactory.createSpec(Handler.IS_NULL, this.columnToString(field), null));
        return this.typedThis;
    }

    @Override
    public Child isNotNull(R field) {
        this.specification = this.getSpecification(SpecificationFactory.createSpec(Handler.IS_NOT_NULL, this.columnToString(field), null));
        return this.typedThis;
    }

    @Override
    public <X extends Comparable<? super X>> Child in(R field, Collection<X> collection) {
        this.specification = this.getSpecification(SpecificationFactory.createSpec(Handler.IN, this.columnToString(field), collection));
        return this.typedThis;
    }

    @Override
    public <X extends Comparable<? super X>> Child notIn(R field, Collection<X> collection) {
        this.specification = this.getSpecification(SpecificationFactory.createSpec(Handler.NOT_IN, this.columnToString(field), collection));
        return this.typedThis;
    }

    @Override
    public <X extends Comparable<? super X>> Child in(R field, X ... array) {
        if (array.length == 0) {
            throw JpaPlusException.getException("Array should not be empty");
        }
        return (Child)this.in((Object)field, Arrays.asList(array));
    }

    @Override
    public <X extends Comparable<? super X>> Child notIn(R field, X ... array) {
        if (array.length == 0) {
            throw JpaPlusException.getException("Array should not be empty");
        }
        return (Child)this.notIn((Object)field, Arrays.asList(array));
    }

    @Override
    public <X extends Comparable<? super X>> Child between(R field, X low, X up) {
        if (low != null || up != null) {
            return (Child)((AbstractCondition)this.ge((Object)field, (Comparable)low)).le((Object)field, (Comparable)up);
        }
        return this.typedThis;
    }

    @Override
    public <X extends Comparable<? super X>> Child notBetween(R field, X low, X up) {
        if (low != null || up != null) {
            return (Child)((AbstractCondition)((AbstractCondition)this.lt((Object)field, (Comparable)low)).or()).gt((Object)field, (Comparable)up);
        }
        return this.typedThis;
    }

    private void mergeSpecification(Specification<T> s, Predicate.BooleanOperator operator) {
        if (s != null) {
            this.specification = operator == Predicate.BooleanOperator.AND ? this.specification.and(s) : this.specification.or(s);
        }
    }

    private Specification<T> getSpecification(Specification<T> spec) {
        this.mergeSpecification(spec, this.operator);
        return this.specification;
    }
}

