package com.ntt.core.service.supports.jumper;

import static android.content.Intent.FLAG_ACTIVITY_NEW_TASK;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;

import com.ntt.core.service.entities.SJumpEntity;

import java.util.HashMap;
import java.util.Map;

public class JumperManager {
    private static final String TAG = JumperManager.class.getSimpleName();

    private Context mContext;

    public JumperManager(Context context) {
        mContext = context;
    }


    /**
     * 跳转
     *
     * @param entity
     */
    public boolean doJump(SJumpEntity entity) {
        //先去适配一遍老的跳转协议接口
        //如果老的协议已经适配则直接返回成功
        if (oldJump(entity)) return true;
        //生成跳转Intent
        Intent intent = genJumpIntent(entity);
        String code = entity.getCode();
        String pN = entity.getPackageName();
        String packageName = mContext.getPackageName();
        if (!isImplicitStartActivity(intent)) {
            //传进来的包名为空，或者相等，就用当前的包名
            if (pN == null || packageName.equals(pN)) {
                intent.setClassName(mContext, code);
            } else {
                intent.setClassName(pN, code);
            }
        }
        try {
            mContext.startActivity(intent);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }


    /**
     * 隐式启动
     *
     * @param intent
     * @return
     */
    private boolean isImplicitStartActivity(Intent intent) {
        return !TextUtils.isEmpty(intent.getAction());
    }


    /**
     * 老的跳转协议的适配
     *
     * @param entity
     * @return
     */
    private boolean oldJump(SJumpEntity entity) {
        String code = entity.getCode();
        if (TextUtils.isEmpty(code)) return false;
        HashMap<String, String> map = JumpConstants.get(code);
        if (map == null) return false;
        String packageName = map.get("packageName");
        if (TextUtils.isEmpty(packageName)) return false;
        try {
            //生成跳转Intent
            Intent intent = genJumpIntent(entity);
            intent.setClassName(packageName, packageName + code);
            mContext.startActivity(intent);
            return true;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    /**
     * 生成Intent
     *
     * @param entity
     * @return
     */
    private Intent genJumpIntent(SJumpEntity entity) {
        Intent intent = new Intent();
        String code = entity.getCode();
        Map<String, Object> args = entity.getParams() == null ? new HashMap<>() : entity.getParams();
        switch (code) {
            case JumpConstants.NATIVE_ALBUM_DETAIL_CODE:
                entity.setCode(JumpConstants.NEW_ALBUM_DETAIL_CODE);
                entity.setPackageName(JumpConstants.PACKAGE_NAME_ALBUM);
                if (args.containsKey("uid")) {
                    String uid = args.get("uid").toString();
                    intent.putExtra("albumId", uid);
                }
                break;
            case JumpConstants.NATIVE_EDIFY_PLAN_DETAIL_CODE: {
                entity.setCode(JumpConstants.NEW_EDIFY_PACKAGE_DETAIL_CODE);
                entity.setPackageName(JumpConstants.PACKAGE_NAME_ALBUM);
                long uid = UtMapHelper.getMapObject2Long(args, "uid");
                intent.putExtra("albumId", uid);
                break;
            }
            case JumpConstants.NATIVE_EDIFY_ALBUM_DETAIL: {
                entity.setCode(JumpConstants.NEW_EDIFY_ALBUM_DETAIL_CODE);
                entity.setPackageName(JumpConstants.PACKAGE_NAME_ALBUM);
                long uid = UtMapHelper.getMapObject2Long(args, "uid");
                intent.putExtra("edifyId", uid);
                break;
            }
            case JumpConstants.NATIVE_BROADCASTER_DETAIL_CODE: {
                entity.setCode(JumpConstants.NEW_ANNOUNCER_DETAIL_CODE);
                entity.setPackageName(JumpConstants.PACKAGE_NAME_ALBUM);
                long uid = UtMapHelper.getMapObject2Long(args, "uid");
                intent.putExtra("uid", uid);
                intent.putExtra("isChannel", UtMapHelper.getMapObjectBoolean(args, "isChannel"));
                break;
            }
            case JumpConstants.NATIVE_ANNOUNCER_HOME:
                entity.setCode(JumpConstants.NEW_ANNOUNCER_HOME_CODE);
                entity.setPackageName(JumpConstants.PACKAGE_NAME_ALBUM);
                break;
            case JumpConstants.NATIVE_ALBUM_CAT_HOME:
                entity.setCode(JumpConstants.NEW_ALBUM_CATEGORY_CODE);
                entity.setPackageName(JumpConstants.PACKAGE_NAME_ALBUM);
                break;
            case JumpConstants.NATIVE_EDIFY_HOME:
                entity.setCode(JumpConstants.NEW_EDIFY_LIST_CODE);
                entity.setPackageName(JumpConstants.PACKAGE_NAME_ALBUM);
                if (args.containsKey("isAddSchedule")) {
                    intent.putExtra("isAddSchedule", UtMapHelper.getMapObjectBoolean(args, "isAddSchedule"));
                }
                break;
            case JumpConstants.NATIVE_SEARCH_CONTENT_HOME_CODE:
                entity.setCode(JumpConstants.NEW_SEARCH_MAIN_HOME);
                entity.setPackageName(JumpConstants.PACKAGE_NAME_ALBUM);
                intent.putExtra("type", UtMapHelper.getMapObject2String(args, "type"));
                break;
            case JumpConstants.SCHEDULE_REPEAT_LIST:
                entity.setPackageName(JumpConstants.PACKAGE_NAME_ALBUM);
                entity.setCode(JumpConstants.NEW_ALBUM_REPEAT_CODE);
                break;
            case JumpConstants.SEARCH_MINE_ALBUM_HOME:
                intent.putExtra("albumId", UtMapHelper.getMapObject2String(args, "uid"));
                intent.putExtra("type", UtMapHelper.getMapObject2String(args, "type"));
                break;
            case JumpConstants.AUDIO_PLAYER_HOME: {
                intent.setAction(Intent.ACTION_VIEW);
                if (args.containsKey("uids")) {
                    String ids = UtMapHelper.getMapObject2String(args, "uids");
                    int index = UtMapHelper.getMapObject2Int(args, "index");
                    intent.setData(Uri.parse("ntt://app/?page=PlayHomeActivity&ids=" + ids + "&index=" + index));
                } else {
                    String data = UtMapHelper.getMapObject2String(args, "data");
                    intent.setData(Uri.parse("ntt://app/?" + data));
                }
            }
            break;
            case JumpConstants.VIDEO_PLAYER_HOME:
                intent.setAction(Intent.ACTION_VIEW);
                if (args.containsKey("link")) {
                    String link = UtMapHelper.getMapObject2String(args, "link");
                    intent.setData(Uri.parse("ntt://app/?page=VideoHomeActivity&link=" + link));
                } else {
                    String data = UtMapHelper.getMapObject2String(args, "data");
                    intent.setData(Uri.parse("ntt://app/?" + data));
                }
                break;
            case JumpConstants.YOUDAO_FINGER_DETECT:
                entity.setCode(JumpConstants.YOUDAO_FINGER_DETECT_HOME);
                entity.setPackageName(JumpConstants.PACKAGE_NAME_CORESERVICE);
                if (args.containsKey("requestType")) {
                    String requestType = args.get("requestType").toString();
                    Bundle bundle = new Bundle();
                    bundle.putString("requestType", requestType);
                    intent.putExtras(bundle);
                }
                break;
            case JumpConstants.NEW_SYNCHROLOGY_HOME:
                entity.setPackageName(JumpConstants.PACKAGE_NAME_SYNC_LEARNING);
                intent.putExtra("type", UtMapHelper.getMapObject2String(args, "type"));
                break;
            case JumpConstants.MEMORY_HOME_CODE:
                entity.setPackageName(JumpConstants.PACKAGE_NAME_MEMORY);
                entity.setCode(JumpConstants.MEMORY_HOME);
                //couse:课程，mycourse:我的课程，exam:考级，不传就主界面了
                if (args.containsKey("page")){
                    intent.putExtra("page",UtMapHelper.getMapObject2String(args,"page"));
                }
                break;
            case JumpConstants.SCHEDULE_EXECUTE_CODE:
                entity.setPackageName(JumpConstants.PACKAGE_NAME_SCHEDULE);
                entity.setCode(JumpConstants.SCHEDULE_EDIFY_OR_PUNCH);
                if (args.containsKey("data")) {
                    intent.putExtra("data", args.get("data").toString());
                }
                break;
            case JumpConstants.CARTOON_BOOK_DETAIL_CODE:
                entity.setPackageName(JumpConstants.PACKAGE_NAME_READING);
                entity.setCode(JumpConstants.READING_LIBRARY_CONTENT);
                if (args.containsKey("uid")) {
                    Bundle bundle = new Bundle();
                    bundle.putInt("uid", UtMapHelper.getMapObject2Int(args, "uid"));
                    intent.putExtra("params", bundle);
                }
                break;
            case JumpConstants.BOOK_LIBRARY_CODE:
                entity.setPackageName(JumpConstants.PACKAGE_NAME_READING);
                entity.setCode(JumpConstants.READING_LIBRARY);
                break;
            case JumpConstants.READING_CODE:
                entity.setPackageName(JumpConstants.PACKAGE_NAME_READING);
                entity.setCode(JumpConstants.READING_READING);
                break;
            case JumpConstants.EYE_PROTECTION_HOME:
                entity.setPackageName(JumpConstants.PACKAGE_NAME_EYE_PROTECTION);
                entity.setCode(JumpConstants.EYE_PROTECTION_HOME);
                break;
            default:
                break;
        }
        intent.setFlags(FLAG_ACTIVITY_NEW_TASK);
        return intent;
    }
}
