/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mmkv;

import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import com.tencent.mmkv.MMKV;
import java.io.IOException;

public final class ParcelableMMKV
implements Parcelable {
    private final String mmapID;
    private int ashmemFD = -1;
    private int ashmemMetaFD = -1;
    private String cryptKey = null;
    public static final Parcelable.Creator<ParcelableMMKV> CREATOR = new Parcelable.Creator<ParcelableMMKV>(){

        public ParcelableMMKV createFromParcel(Parcel source) {
            String mmapID = source.readString();
            ParcelFileDescriptor fd = (ParcelFileDescriptor)ParcelFileDescriptor.CREATOR.createFromParcel(source);
            ParcelFileDescriptor metaFD = (ParcelFileDescriptor)ParcelFileDescriptor.CREATOR.createFromParcel(source);
            String cryptKey = source.readString();
            if (fd != null && metaFD != null) {
                return new ParcelableMMKV(mmapID, fd.detachFd(), metaFD.detachFd(), cryptKey);
            }
            return null;
        }

        public ParcelableMMKV[] newArray(int size) {
            return new ParcelableMMKV[size];
        }
    };

    public ParcelableMMKV(MMKV mmkv) {
        this.mmapID = mmkv.mmapID();
        this.ashmemFD = mmkv.ashmemFD();
        this.ashmemMetaFD = mmkv.ashmemMetaFD();
        this.cryptKey = mmkv.cryptKey();
    }

    private ParcelableMMKV(String id2, int fd, int metaFD, String key) {
        this.mmapID = id2;
        this.ashmemFD = fd;
        this.ashmemMetaFD = metaFD;
        this.cryptKey = key;
    }

    public MMKV toMMKV() {
        if (this.ashmemFD >= 0 && this.ashmemMetaFD >= 0) {
            return MMKV.mmkvWithAshmemFD(this.mmapID, this.ashmemFD, this.ashmemMetaFD, this.cryptKey);
        }
        return null;
    }

    public int describeContents() {
        return 1;
    }

    public void writeToParcel(Parcel dest, int flags) {
        try {
            dest.writeString(this.mmapID);
            ParcelFileDescriptor fd = ParcelFileDescriptor.fromFd((int)this.ashmemFD);
            ParcelFileDescriptor metaFD = ParcelFileDescriptor.fromFd((int)this.ashmemMetaFD);
            fd.writeToParcel(dest, flags |= 1);
            metaFD.writeToParcel(dest, flags);
            if (this.cryptKey != null) {
                dest.writeString(this.cryptKey);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

