/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mars.xlog;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Process;
import android.widget.Toast;
import java.util.HashMap;
import java.util.Map;

public class Log {
    private static final String TAG = "mars.xlog.log";
    public static final int LEVEL_VERBOSE = 0;
    public static final int LEVEL_DEBUG = 1;
    public static final int LEVEL_INFO = 2;
    public static final int LEVEL_WARNING = 3;
    public static final int LEVEL_ERROR = 4;
    public static final int LEVEL_FATAL = 5;
    public static final int LEVEL_NONE = 6;
    private static int level = 6;
    public static Context toastSupportContext = null;
    private static LogImp debugLog;
    private static LogImp logImp;
    private static final String SYS_INFO;
    private static Map<String, LogInstance> sLogInstanceMap;

    public static void setLogImp(LogImp imp) {
        logImp = imp;
    }

    public static LogImp getImpl() {
        return logImp;
    }

    public static void appenderOpen(int level, int mode, String cacheDir, String logDir, String nameprefix, int cacheDays) {
        if (logImp != null) {
            logImp.appenderOpen(level, mode, cacheDir, logDir, nameprefix, cacheDays);
        }
    }

    public static void appenderClose() {
        if (logImp != null) {
            logImp.appenderClose();
            for (Map.Entry<String, LogInstance> entry : sLogInstanceMap.entrySet()) {
                Log.closeLogInstance(entry.getKey());
            }
        }
    }

    public static void appenderFlush() {
        if (logImp != null) {
            logImp.appenderFlush(0L, false);
            for (Map.Entry<String, LogInstance> entry : sLogInstanceMap.entrySet()) {
                entry.getValue().appenderFlush();
            }
        }
    }

    public static void appenderFlushSync(boolean isSync) {
        if (logImp != null) {
            logImp.appenderFlush(0L, isSync);
        }
    }

    public static int getLogLevel() {
        if (logImp != null) {
            return logImp.getLogLevel(0L);
        }
        return 6;
    }

    public static void setLevel(int level, boolean jni) {
        Log.level = level;
        android.util.Log.w((String)TAG, (String)("new log level: " + level));
        if (jni) {
            android.util.Log.e((String)TAG, (String)"no jni log level support");
        }
    }

    public static void setConsoleLogOpen(boolean isOpen) {
        if (logImp != null) {
            logImp.setConsoleLogOpen(0L, isOpen);
        }
    }

    public static void f(String tag, String msg) {
        Log.f(tag, msg, null);
    }

    public static void e(String tag, String msg) {
        Log.e(tag, msg, null);
    }

    public static void w(String tag, String msg) {
        Log.w(tag, msg, null);
    }

    public static void i(String tag, String msg) {
        Log.i(tag, msg, null);
    }

    public static void d(String tag, String msg) {
        Log.d(tag, msg, null);
    }

    public static void v(String tag, String msg) {
        Log.v(tag, msg, null);
    }

    public static void f(String tag, String format, Object ... obj) {
        if (logImp != null && logImp.getLogLevel(0L) <= 5) {
            String log = obj == null ? format : String.format(format, obj);
            logImp.logF(0L, tag, "", "", 0, Process.myPid(), Thread.currentThread().getId(), Looper.getMainLooper().getThread().getId(), log);
        }
    }

    public static void e(String tag, String format, Object ... obj) {
        if (logImp != null && logImp.getLogLevel(0L) <= 4) {
            String log;
            String string2 = log = obj == null ? format : String.format(format, obj);
            if (log == null) {
                log = "";
            }
            logImp.logE(0L, tag, "", "", 0, Process.myPid(), Thread.currentThread().getId(), Looper.getMainLooper().getThread().getId(), log);
        }
    }

    public static void w(String tag, String format, Object ... obj) {
        if (logImp != null && logImp.getLogLevel(0L) <= 3) {
            String log;
            String string2 = log = obj == null ? format : String.format(format, obj);
            if (log == null) {
                log = "";
            }
            logImp.logW(0L, tag, "", "", 0, Process.myPid(), Thread.currentThread().getId(), Looper.getMainLooper().getThread().getId(), log);
        }
    }

    public static void i(String tag, String format, Object ... obj) {
        if (logImp != null && logImp.getLogLevel(0L) <= 2) {
            String log;
            String string2 = log = obj == null ? format : String.format(format, obj);
            if (log == null) {
                log = "";
            }
            logImp.logI(0L, tag, "", "", 0, Process.myPid(), Thread.currentThread().getId(), Looper.getMainLooper().getThread().getId(), log);
        }
    }

    public static void d(String tag, String format, Object ... obj) {
        if (logImp != null && logImp.getLogLevel(0L) <= 1) {
            String log;
            String string2 = log = obj == null ? format : String.format(format, obj);
            if (log == null) {
                log = "";
            }
            logImp.logD(0L, tag, "", "", 0, Process.myPid(), Thread.currentThread().getId(), Looper.getMainLooper().getThread().getId(), log);
        }
    }

    public static void v(String tag, String format, Object ... obj) {
        if (logImp != null && logImp.getLogLevel(0L) <= 0) {
            String log;
            String string2 = log = obj == null ? format : String.format(format, obj);
            if (log == null) {
                log = "";
            }
            logImp.logV(0L, tag, "", "", 0, Process.myPid(), Thread.currentThread().getId(), Looper.getMainLooper().getThread().getId(), log);
        }
    }

    public static void printErrStackTrace(String tag, Throwable tr, String format, Object ... obj) {
        if (logImp != null && logImp.getLogLevel(0L) <= 4) {
            String log;
            String string2 = log = obj == null ? format : String.format(format, obj);
            if (log == null) {
                log = "";
            }
            log = log + "  " + android.util.Log.getStackTraceString((Throwable)tr);
            logImp.logE(0L, tag, "", "", 0, Process.myPid(), Thread.currentThread().getId(), Looper.getMainLooper().getThread().getId(), log);
        }
    }

    public static String getSysInfo() {
        return SYS_INFO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogInstance openLogInstance(int level, int mode, String cacheDir, String logDir, String nameprefix, int cacheDays) {
        Map<String, LogInstance> map = sLogInstanceMap;
        synchronized (map) {
            if (sLogInstanceMap.containsKey(nameprefix)) {
                return sLogInstanceMap.get(nameprefix);
            }
            LogInstance instance = new LogInstance(level, mode, cacheDir, logDir, nameprefix, cacheDays);
            sLogInstanceMap.put(nameprefix, instance);
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeLogInstance(String prefix) {
        Map<String, LogInstance> map = sLogInstanceMap;
        synchronized (map) {
            if (null != logImp && sLogInstanceMap.containsKey(prefix)) {
                LogInstance logInstance = sLogInstanceMap.remove(prefix);
                logImp.releaseXlogInstance(prefix);
                logInstance.mLogInstancePtr = -1L;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogInstance getLogInstance(String prefix) {
        Map<String, LogInstance> map = sLogInstanceMap;
        synchronized (map) {
            if (sLogInstanceMap.containsKey(prefix)) {
                return sLogInstanceMap.get(prefix);
            }
            return null;
        }
    }

    static {
        logImp = debugLog = new LogImp(){
            private Handler handler = new Handler(Looper.getMainLooper());

            @Override
            public void logV(long logInstancePtr, String tag, String filename, String funcname, int line, int pid, long tid, long maintid, String log) {
                if (level <= 0) {
                    android.util.Log.v((String)tag, (String)log);
                }
            }

            @Override
            public void logI(long logInstancePtr, String tag, String filename, String funcname, int line, int pid, long tid, long maintid, String log) {
                if (level <= 2) {
                    android.util.Log.i((String)tag, (String)log);
                }
            }

            @Override
            public void logD(long logInstancePtr, String tag, String filename, String funcname, int line, int pid, long tid, long maintid, String log) {
                if (level <= 1) {
                    android.util.Log.d((String)tag, (String)log);
                }
            }

            @Override
            public void logW(long logInstancePtr, String tag, String filename, String funcname, int line, int pid, long tid, long maintid, String log) {
                if (level <= 3) {
                    android.util.Log.w((String)tag, (String)log);
                }
            }

            @Override
            public void logE(long logInstancePtr, String tag, String filename, String funcname, int line, int pid, long tid, long maintid, String log) {
                if (level <= 4) {
                    android.util.Log.e((String)tag, (String)log);
                }
            }

            @Override
            public void logF(long logInstancePtr, String tag, String filename, String funcname, int line, int pid, long tid, long maintid, final String log) {
                if (level > 5) {
                    return;
                }
                android.util.Log.e((String)tag, (String)log);
                if (toastSupportContext != null) {
                    this.handler.post(new Runnable(){

                        @Override
                        public void run() {
                            Toast.makeText((Context)toastSupportContext, (CharSequence)log, (int)1).show();
                        }
                    });
                }
            }

            @Override
            public int getLogLevel(long logInstancePtr) {
                return level;
            }

            @Override
            public void setAppenderMode(long logInstancePtr, int mode) {
            }

            @Override
            public long openLogInstance(int level, int mode, String cacheDir, String logDir, String nameprefix, int cacheDays) {
                return 0L;
            }

            @Override
            public long getXlogInstance(String nameprefix) {
                return 0L;
            }

            @Override
            public void releaseXlogInstance(String nameprefix) {
            }

            @Override
            public void appenderOpen(int level, int mode, String cacheDir, String logDir, String nameprefix, int cacheDays) {
            }

            @Override
            public void appenderClose() {
            }

            @Override
            public void appenderFlush(long logInstancePtr, boolean isSync) {
            }

            @Override
            public void setConsoleLogOpen(long logInstancePtr, boolean isOpen) {
            }

            @Override
            public void setMaxAliveTime(long logInstancePtr, long aliveSeconds) {
            }

            @Override
            public void setMaxFileSize(long logInstancePtr, long aliveSeconds) {
            }
        };
        StringBuilder sb = new StringBuilder();
        try {
            sb.append("VERSION.RELEASE:[" + Build.VERSION.RELEASE);
            sb.append("] VERSION.CODENAME:[" + Build.VERSION.CODENAME);
            sb.append("] VERSION.INCREMENTAL:[" + Build.VERSION.INCREMENTAL);
            sb.append("] BOARD:[" + Build.BOARD);
            sb.append("] DEVICE:[" + Build.DEVICE);
            sb.append("] DISPLAY:[" + Build.DISPLAY);
            sb.append("] FINGERPRINT:[" + Build.FINGERPRINT);
            sb.append("] HOST:[" + Build.HOST);
            sb.append("] MANUFACTURER:[" + Build.MANUFACTURER);
            sb.append("] MODEL:[" + Build.MODEL);
            sb.append("] PRODUCT:[" + Build.PRODUCT);
            sb.append("] TAGS:[" + Build.TAGS);
            sb.append("] TYPE:[" + Build.TYPE);
            sb.append("] USER:[" + Build.USER + "]");
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        SYS_INFO = sb.toString();
        sLogInstanceMap = new HashMap<String, LogInstance>();
    }

    public static class LogInstance {
        private long mLogInstancePtr = -1L;
        private String mPrefix = null;

        private LogInstance(int level, int mode, String cacheDir, String logDir, String nameprefix, int cacheDays) {
            if (logImp != null) {
                this.mLogInstancePtr = logImp.openLogInstance(level, mode, cacheDir, logDir, nameprefix, cacheDays);
                this.mPrefix = nameprefix;
            }
        }

        public void f(String tag, String format, Object ... obj) {
            if (logImp != null && this.getLogLevel() <= 5 && this.mLogInstancePtr != -1L) {
                String log = obj == null ? format : String.format(format, obj);
                logImp.logF(this.mLogInstancePtr, tag, "", "", Process.myTid(), Process.myPid(), Thread.currentThread().getId(), Looper.getMainLooper().getThread().getId(), log);
            }
        }

        public void e(String tag, String format, Object ... obj) {
            if (logImp != null && this.getLogLevel() <= 4 && this.mLogInstancePtr != -1L) {
                String log;
                String string2 = log = obj == null ? format : String.format(format, obj);
                if (log == null) {
                    log = "";
                }
                logImp.logE(this.mLogInstancePtr, tag, "", "", Process.myTid(), Process.myPid(), Thread.currentThread().getId(), Looper.getMainLooper().getThread().getId(), log);
            }
        }

        public void w(String tag, String format, Object ... obj) {
            if (logImp != null && this.getLogLevel() <= 3 && this.mLogInstancePtr != -1L) {
                String log;
                String string2 = log = obj == null ? format : String.format(format, obj);
                if (log == null) {
                    log = "";
                }
                logImp.logW(this.mLogInstancePtr, tag, "", "", Process.myTid(), Process.myPid(), Thread.currentThread().getId(), Looper.getMainLooper().getThread().getId(), log);
            }
        }

        public void i(String tag, String format, Object ... obj) {
            if (logImp != null && this.getLogLevel() <= 2 && this.mLogInstancePtr != -1L) {
                String log;
                String string2 = log = obj == null ? format : String.format(format, obj);
                if (log == null) {
                    log = "";
                }
                logImp.logI(this.mLogInstancePtr, tag, "", "", Process.myTid(), Process.myPid(), Thread.currentThread().getId(), Looper.getMainLooper().getThread().getId(), log);
            }
        }

        public void d(String tag, String format, Object ... obj) {
            if (logImp != null && this.getLogLevel() <= 1 && this.mLogInstancePtr != -1L) {
                String log;
                String string2 = log = obj == null ? format : String.format(format, obj);
                if (log == null) {
                    log = "";
                }
                logImp.logD(this.mLogInstancePtr, tag, "", "", Process.myTid(), Process.myPid(), Thread.currentThread().getId(), Looper.getMainLooper().getThread().getId(), log);
            }
        }

        public void v(String tag, String format, Object ... obj) {
            if (logImp != null && this.getLogLevel() <= 0 && this.mLogInstancePtr != -1L) {
                String log;
                String string2 = log = obj == null ? format : String.format(format, obj);
                if (log == null) {
                    log = "";
                }
                logImp.logV(this.mLogInstancePtr, tag, "", "", Process.myTid(), Process.myPid(), Thread.currentThread().getId(), Looper.getMainLooper().getThread().getId(), log);
            }
        }

        public void printErrStackTrace(String tag, Throwable tr, String format, Object ... obj) {
            if (logImp != null && this.getLogLevel() <= 4 && this.mLogInstancePtr != -1L) {
                String log;
                String string2 = log = obj == null ? format : String.format(format, obj);
                if (log == null) {
                    log = "";
                }
                log = log + "  " + android.util.Log.getStackTraceString((Throwable)tr);
                logImp.logE(this.mLogInstancePtr, tag, "", "", Process.myTid(), Process.myPid(), Thread.currentThread().getId(), Looper.getMainLooper().getThread().getId(), log);
            }
        }

        public void appenderFlush() {
            if (logImp != null && this.mLogInstancePtr != -1L) {
                logImp.appenderFlush(this.mLogInstancePtr, false);
            }
        }

        public void appenderFlushSync() {
            if (logImp != null && this.mLogInstancePtr != -1L) {
                logImp.appenderFlush(this.mLogInstancePtr, true);
            }
        }

        public int getLogLevel() {
            if (logImp != null && this.mLogInstancePtr != -1L) {
                return logImp.getLogLevel(this.mLogInstancePtr);
            }
            return 6;
        }

        public void setConsoleLogOpen(boolean isOpen) {
            if (null != logImp && this.mLogInstancePtr != -1L) {
                logImp.setConsoleLogOpen(this.mLogInstancePtr, isOpen);
            }
        }
    }

    public static interface LogImp {
        public void logV(long var1, String var3, String var4, String var5, int var6, int var7, long var8, long var10, String var12);

        public void logI(long var1, String var3, String var4, String var5, int var6, int var7, long var8, long var10, String var12);

        public void logD(long var1, String var3, String var4, String var5, int var6, int var7, long var8, long var10, String var12);

        public void logW(long var1, String var3, String var4, String var5, int var6, int var7, long var8, long var10, String var12);

        public void logE(long var1, String var3, String var4, String var5, int var6, int var7, long var8, long var10, String var12);

        public void logF(long var1, String var3, String var4, String var5, int var6, int var7, long var8, long var10, String var12);

        public int getLogLevel(long var1);

        public void setAppenderMode(long var1, int var3);

        public long openLogInstance(int var1, int var2, String var3, String var4, String var5, int var6);

        public long getXlogInstance(String var1);

        public void releaseXlogInstance(String var1);

        public void appenderOpen(int var1, int var2, String var3, String var4, String var5, int var6);

        public void appenderClose();

        public void appenderFlush(long var1, boolean var3);

        public void setConsoleLogOpen(long var1, boolean var3);

        public void setMaxFileSize(long var1, long var3);

        public void setMaxAliveTime(long var1, long var3);
    }
}

