/*
 * Decompiled with CFR 0.152.
 */
package com.ntt.core.service.supports.jumper;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import com.ntt.core.service.entities.SJumpEntity;
import com.ntt.core.service.supports.jumper.JumpConstants;
import com.ntt.core.service.supports.jumper.UtMapHelper;
import java.util.HashMap;

public class JumperManager {
    private static final String TAG = JumperManager.class.getSimpleName();
    private Context mContext;

    public JumperManager(Context context) {
        this.mContext = context;
    }

    public boolean doJump(SJumpEntity entity) {
        if (this.oldJump(entity)) {
            return true;
        }
        Intent intent = this.genJumpIntent(entity);
        String code = entity.getCode();
        String pN = entity.getPackageName();
        String packageName = this.mContext.getPackageName();
        if (!this.isImplicitStartActivity(intent)) {
            if (pN == null || packageName.equals(pN)) {
                intent.setClassName(this.mContext, code);
            } else {
                intent.setClassName(pN, code);
            }
        }
        try {
            this.mContext.startActivity(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    private boolean isImplicitStartActivity(Intent intent) {
        return !TextUtils.isEmpty((CharSequence)intent.getAction());
    }

    private boolean oldJump(SJumpEntity entity) {
        String code = entity.getCode();
        if (TextUtils.isEmpty((CharSequence)code)) {
            return false;
        }
        HashMap<String, String> map = JumpConstants.get(code);
        if (map == null) {
            return false;
        }
        String packageName = map.get("packageName");
        if (TextUtils.isEmpty((CharSequence)packageName)) {
            return false;
        }
        try {
            Intent intent = this.genJumpIntent(entity);
            intent.setClassName(packageName, packageName + code);
            this.mContext.startActivity(intent);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private Intent genJumpIntent(SJumpEntity entity) {
        Intent intent = new Intent();
        String code = entity.getCode();
        HashMap<String, Object> args = entity.getParams() == null ? new HashMap() : entity.getParams();
        switch (code) {
            case "AlbumDetail": {
                entity.setCode("com.benew.nttr.album.ui.activity.AlbumDetailActivity");
                entity.setPackageName("com.benew.nttr.r2album");
                if (!args.containsKey("uid")) break;
                String uid = args.get("uid").toString();
                intent.putExtra("albumId", uid);
                break;
            }
            case "EdifyPlanDetail": {
                entity.setCode("com.benew.nttr.edify.ui.activity.EdifyPackageDetailActivity");
                entity.setPackageName("com.benew.nttr.r2album");
                long uid = UtMapHelper.getMapObject2Long(args, "uid");
                intent.putExtra("albumId", uid);
                break;
            }
            case "EdifyAlbumDetail": {
                entity.setCode("com.benew.nttr.edify.ui.activity.EdifyAlbumDetailActivity");
                entity.setPackageName("com.benew.nttr.r2album");
                long uid = UtMapHelper.getMapObject2Long(args, "uid");
                intent.putExtra("edifyId", uid);
                break;
            }
            case "BroadcasterDetail": {
                entity.setCode("com.benew.nttr.announcer.ui.activity.AnnouncerDetailActivity");
                entity.setPackageName("com.benew.nttr.r2album");
                long uid = UtMapHelper.getMapObject2Long(args, "uid");
                intent.putExtra("uid", uid);
                intent.putExtra("isChannel", UtMapHelper.getMapObjectBoolean(args, "isChannel"));
                break;
            }
            case "AnnouncerHome": {
                entity.setCode("com.benew.nttr.announcer.ui.activity.AnnouncerMainActivity");
                entity.setPackageName("com.benew.nttr.r2album");
                break;
            }
            case "AlbumCatHome": {
                entity.setCode("com.benew.nttr.album.ui.activity.AlbumCategoryActivity");
                entity.setPackageName("com.benew.nttr.r2album");
                break;
            }
            case "EdifyHome": {
                entity.setCode("com.benew.nttr.edify.ui.activity.EdifyListActivity");
                entity.setPackageName("com.benew.nttr.r2album");
                if (!args.containsKey("isAddSchedule")) break;
                intent.putExtra("isAddSchedule", UtMapHelper.getMapObjectBoolean(args, "isAddSchedule"));
                break;
            }
            case "SearchContentHome": {
                entity.setCode("com.benew.nttr.search.ui.SearchMainActivity");
                entity.setPackageName("com.benew.nttr.r2album");
                intent.putExtra("type", UtMapHelper.getMapObject2String(args, "type"));
                break;
            }
            case "ScheduleRepeatClassify": {
                entity.setPackageName("com.benew.nttr.r2album");
                entity.setCode("com.benew.nttr.album.ui.activity.AlbumRepeatActivity");
                break;
            }
            case "com.benew.nttr.search.ui.SearchMineAlbumActivity": {
                intent.putExtra("albumId", UtMapHelper.getMapObject2String(args, "uid"));
                intent.putExtra("type", UtMapHelper.getMapObject2String(args, "type"));
                break;
            }
            case "com.benew.nttr.player.mvp.ui.activity.PlayerHomeActivity": {
                intent.setAction("android.intent.action.VIEW");
                if (args.containsKey("uids")) {
                    String ids = UtMapHelper.getMapObject2String(args, "uids");
                    int index = UtMapHelper.getMapObject2Int(args, "index");
                    intent.setData(Uri.parse((String)("ntt://app/?page=PlayHomeActivity&ids=" + ids + "&index=" + index)));
                    break;
                }
                String data = UtMapHelper.getMapObject2String(args, "data");
                intent.setData(Uri.parse((String)("ntt://app/?" + data)));
                break;
            }
            case "com.benew.nttr.player.mvp.ui.activity.VideoHomeActivity": {
                intent.setAction("android.intent.action.VIEW");
                if (args.containsKey("link")) {
                    String link = UtMapHelper.getMapObject2String(args, "link");
                    intent.setData(Uri.parse((String)("ntt://app/?page=VideoHomeActivity&link=" + link)));
                    break;
                }
                String data = UtMapHelper.getMapObject2String(args, "data");
                intent.setData(Uri.parse((String)("ntt://app/?" + data)));
                break;
            }
            case "YouDaoFingerDetect": {
                entity.setCode("com.ntt.core.service.logic.finger.YouDaoMainActivity");
                entity.setPackageName("com.ntt.core.service");
                if (!args.containsKey("requestType")) break;
                String requestType = args.get("requestType").toString();
                Bundle bundle = new Bundle();
                bundle.putString("requestType", requestType);
                intent.putExtras(bundle);
                break;
            }
            case "com.benew.nttr2.synclearning.ui.activity.BookHomeActivity": {
                entity.setPackageName("com.benew.nttr2.synclearning");
                intent.putExtra("type", UtMapHelper.getMapObject2String(args, "type"));
                break;
            }
            case "MemoryCourseMine": {
                entity.setPackageName("com.benew.nttr2.memory");
                entity.setCode("com.example.flutter_code.MainActivity");
                if (!args.containsKey("page")) break;
                intent.putExtra("page", UtMapHelper.getMapObject2String(args, "page"));
                break;
            }
            case "ScheduleExecute": {
                entity.setPackageName("com.benew.nttr.schedule");
                entity.setCode("com.benew.nttr.schedule.mvp.ui.activity.IntermediaryActivity");
                if (!args.containsKey("data")) break;
                intent.putExtra("data", args.get("data").toString());
                break;
            }
            case "CartoonbookDetail": {
                entity.setPackageName("com.benew.ntt.reading");
                entity.setCode("com.benew.ntt.reading.mvp.view.LibraryContentActivity");
                if (!args.containsKey("uid")) break;
                Bundle bundle = new Bundle();
                bundle.putInt("uid", UtMapHelper.getMapObject2Int(args, "uid"));
                intent.putExtra("params", bundle);
                break;
            }
            case "BookLibrary": {
                entity.setPackageName("com.benew.ntt.reading");
                entity.setCode("com.benew.ntt.reading.mvp.view.LibraryActivity");
                break;
            }
            case "Reading": {
                entity.setPackageName("com.benew.ntt.reading");
                entity.setCode("com.benew.ntt.reading.mvp.view.VtstoryBaseActivity");
                break;
            }
            case "com.benew.nttr2.eyeprotection.EyeProtectionHomeActivity": {
                entity.setPackageName("com.benew.nttr2.eyeprotection");
                entity.setCode("com.benew.nttr2.eyeprotection.EyeProtectionHomeActivity");
                break;
            }
        }
        intent.setFlags(0x10000000);
        return intent;
    }
}

