/*
 * Decompiled with CFR 0.152.
 */
package com.ntt.core.service.supports.auth;

import android.text.TextUtils;
import com.blankj.utilcode.util.GsonUtils;
import com.ntt.core.service.CoreServiceImpl;
import com.ntt.core.service.api.ApiManager;
import com.ntt.core.service.entities.SAuthEntity;
import com.ntt.core.service.plugins.http.BaseObserver;
import com.ntt.core.service.plugins.http.exception.HttpException;
import com.ntt.core.service.plugins.sharePreference.SharePreferenceManager;
import com.ntt.core.service.plugins.utils.UtAlgorithm;
import com.ntt.core.service.plugins.utils.UtDateFormat;
import com.ntt.core.service.supports.auth.IAuthCallback;
import com.ntt.core.service.supports.log.XLog;
import java.util.HashMap;
import java.util.Map;

public class Auth {
    private static final String TAG = Auth.class.getSimpleName();
    private String mAppId;
    private String mAppSecret;
    private String mmkvAuthKey;
    private SAuthEntity mAuthEntity;

    public Auth(String appId, String appSecret) {
        if (appId == null || TextUtils.isEmpty((CharSequence)appId) || appSecret == null || TextUtils.isEmpty((CharSequence)appSecret)) {
            throw new Error("\u8bf7\u68c0\u67e5appId\u6216appSecret\u7684\u5185\u5bb9");
        }
        this.mAppId = appId;
        this.mAppSecret = appSecret;
        this.mmkvAuthKey = "auth_key_" + this.mAppId;
        String authStr = SharePreferenceManager.decodeString(this.mmkvAuthKey);
        this.mAuthEntity = GsonUtils.fromJson(authStr, SAuthEntity.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getToken(boolean force) {
        if (!force && this.mAuthEntity == null) {
            return "";
        }
        if (!force && this.isValid(this.mAuthEntity)) {
            String token = this.mAuthEntity.getAccessToken();
            return token;
        }
        final Object o = new Object();
        final String[] token = new String[1];
        Object object = o;
        synchronized (object) {
            this.asyncTokenRequest(new IAuthCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onSuccess(String t) {
                    Object object = o;
                    synchronized (object) {
                        token[0] = t;
                        o.notify();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onFailed(int code, String msg) {
                    Object object = o;
                    synchronized (object) {
                        o.notify();
                    }
                }
            });
            try {
                if (token[0] == null) {
                    o.wait();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return token[0];
    }

    public void syncToken() {
        if (this.isValid(this.mAuthEntity)) {
            return;
        }
        XLog.d(TAG, "\u51c6\u5907\u5f02\u6b65\u8bf7\u6c42Token");
        this.asyncTokenRequest(null);
    }

    public String getHeadToken() {
        if (!this.isValid(this.mAuthEntity)) {
            return "";
        }
        return this.mAuthEntity.getAccessToken();
    }

    public void clearAuthCache() {
        this.mAuthEntity = null;
        SharePreferenceManager.removeString(this.mmkvAuthKey);
    }

    private void asyncTokenRequest(final IAuthCallback callback) {
        final long ts = ApiManager.getInstance().serverDateRequest();
        AuthParams params = this.getAuthParams(ts);
        ApiManager.getInstance().authRequest("application/json", params.getAuthorization(), ts, params.getBody(), new BaseObserver<SAuthEntity>(){

            @Override
            public void onSuccess(SAuthEntity data) {
                block4: {
                    try {
                        data.setTs(ts);
                        Auth.this.mAuthEntity = data;
                        String authStr = GsonUtils.toJson(data);
                        if (!TextUtils.isEmpty((CharSequence)authStr)) {
                            SharePreferenceManager.encodeString(Auth.this.mmkvAuthKey, authStr);
                        }
                        XLog.d(TAG, "\u83b7\u53d6token\u6210\u529f", authStr);
                        if (callback != null) {
                            callback.onSuccess(data.getAccessToken());
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (callback == null) break block4;
                        callback.onFailed(-1, "\u6570\u636e\u89e3\u6790\u5931\u8d25");
                    }
                }
            }

            @Override
            public void onFailure(HttpException apiException) {
                int code = apiException.getCode();
                String msg = apiException.getMessage();
                XLog.d(TAG, "\u83b7\u53d6token\u5931\u8d25", code, msg);
                if (callback != null) {
                    callback.onFailed(code, msg);
                }
            }
        });
    }

    private AuthParams getAuthParams(long ts) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        String grantType = "client_credentials";
        CharSequence[] scope = new String[]{"device_" + CoreServiceImpl.getInstance().getDeviceId()};
        String scopeStr = String.join((CharSequence)",", scope);
        String st = UtDateFormat.formatYYYYMMDD(ts);
        String timeSt = UtDateFormat.formatYYYYMMDD(System.currentTimeMillis());
        XLog.d("getAuthParams", "st = " + st, "ts = " + ts, "system time = " + System.currentTimeMillis(), "timeStr = " + timeSt);
        String clientId = this.mAppId;
        String authorization = UtAlgorithm.getDeviceSign(this.mAppSecret, scopeStr, grantType, String.format("%s", ts));
        String ba = "Bearer " + authorization;
        body.put("scope", scope);
        body.put("grant_type", grantType);
        body.put("client_id", clientId);
        XLog.d("getOauthParams", ba, scope, grantType, clientId);
        return new AuthParams(ba, ts, body);
    }

    private boolean isValid(SAuthEntity auth) {
        if (auth == null) {
            return false;
        }
        long diff = UtDateFormat.getTimeStampSeconds() - auth.getTs();
        if (diff < auth.getExpiresIn()) {
            XLog.d("token\u672a\u8fc7\u671f\uff0c\u4e0d\u9700\u8981\u5237\u65b0:" + auth.getAccessToken());
            return true;
        }
        return false;
    }

    private static class AuthParams {
        private long ts;
        private String authorization;
        private Map<String, Object> body;

        public AuthParams(String authorization, long ts, Map<String, Object> body) {
            this.authorization = authorization;
            this.ts = ts;
            this.body = body;
        }

        public long getTs() {
            return this.ts;
        }

        public void setTs(long ts) {
            this.ts = ts;
        }

        public String getAuthorization() {
            return this.authorization;
        }

        public void setAuthorization(String authorization) {
            this.authorization = authorization;
        }

        public Map<String, Object> getBody() {
            return this.body;
        }

        public void setBody(Map<String, Object> body) {
            this.body = body;
        }
    }
}

