/*
 * Decompiled with CFR 0.152.
 */
package com.ntt.core.service.plugins.utils;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Point;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.Display;
import android.view.KeyCharacterMap;
import android.view.ViewConfiguration;
import android.view.WindowManager;

public class ViewUtils {
    public static int dp2px(Context context, float dp) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public static float px2dp(Context context, float px) {
        return px / context.getResources().getDisplayMetrics().density;
    }

    public static float sp2px(Context context, float sp) {
        return TypedValue.applyDimension((int)2, (float)sp, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public static float px2sp(Context context, float px) {
        return px / context.getResources().getDisplayMetrics().scaledDensity;
    }

    public static int getScreenWidth(Context activity) {
        DisplayMetrics localDisplayMetrics = new DisplayMetrics();
        ((WindowManager)activity.getSystemService("window")).getDefaultDisplay().getMetrics(localDisplayMetrics);
        return localDisplayMetrics.widthPixels;
    }

    public static int getScreenHeight(Context activity) {
        DisplayMetrics localDisplayMetrics = new DisplayMetrics();
        ((WindowManager)activity.getSystemService("window")).getDefaultDisplay().getMetrics(localDisplayMetrics);
        return localDisplayMetrics.heightPixels + ViewUtils.getNavigationBarHeight(activity);
    }

    public static int getNavigationBarHeight(Context activity) {
        if (!ViewUtils.isNavigationBarShow(activity)) {
            return 0;
        }
        Resources resources = activity.getResources();
        int resourceId = resources.getIdentifier("navigation_bar_height", "dimen", "android");
        int height = resources.getDimensionPixelSize(resourceId);
        return height;
    }

    public static boolean isNavigationBarShow(Context activity) {
        if (Build.VERSION.SDK_INT >= 17) {
            Display display = ((WindowManager)activity.getSystemService("window")).getDefaultDisplay();
            Point size = new Point();
            Point realSize = new Point();
            display.getSize(size);
            display.getRealSize(realSize);
            return realSize.y != size.y;
        }
        boolean menu = ViewConfiguration.get((Context)activity).hasPermanentMenuKey();
        boolean back = KeyCharacterMap.deviceHasKey((int)4);
        return !menu && !back;
    }
}

