/*
 * Decompiled with CFR 0.152.
 */
package com.ntt.core.service.plugins.utils;

import android.text.TextUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Formatter;
import java.util.Locale;

public class UtDateFormat {
    public static final String SDF_TYPE_1 = "yyyy-MM-dd'T'HH:mm:ssZ";
    public static final String SDF_TYPE_2 = "yyyy-MM-dd'T'HH:mm:ss";
    public static final String SDF_TYPE_3 = "yyyyMMdd";
    public static final String SDF_TYPE_5 = "HH:mm";
    public static final String SDF_TYPE_6 = "yyyy\u5e74MM\u6708dd\u65e5";
    public static final String SDF_TYPE_7 = "yyyy-MM";
    public static final String SDF_TYPE_8 = "MM\u6708dd\u65e5";
    public static final String SDF_TYPE_9 = "MM-dd";
    public static final String SDF_TYPE_10 = "yyyy\u5e74MM\u6708";
    public static final String SDF_TYPE_11 = "yyyy-MM-dd HH:mm:ss";
    public static final String SDF_TYPE_12 = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    public static final String SDF_TYPE_13 = "HH:mm:ss";
    public static final String SDF_TYPE_14 = "yyyy-MM-dd'T'HH:mm:ssXXX";

    public static String formatTime(long milliseconds) {
        if (milliseconds <= 0L || milliseconds >= 86400000L) {
            return "00:00";
        }
        long totalSeconds = milliseconds / 1000L;
        long seconds = totalSeconds % 60L;
        long minutes = totalSeconds / 60L % 60L;
        long hours = totalSeconds / 3600L;
        StringBuilder stringBuilder = new StringBuilder();
        Formatter formatter = new Formatter(stringBuilder, Locale.getDefault());
        if (hours > 0L) {
            return formatter.format("%d:%02d:%02d", hours, minutes, seconds).toString();
        }
        return formatter.format("%02d:%02d", minutes, seconds).toString();
    }

    public static String printfCurTime() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(SDF_TYPE_11, Locale.getDefault());
        return simpleDateFormat.format(new Date(System.currentTimeMillis()));
    }

    public static long getTimeStamp() {
        return System.currentTimeMillis();
    }

    public static long getTimeStampSeconds() {
        return System.currentTimeMillis() / 1000L;
    }

    public static boolean isDateExpire(String param1, String param2, String sdf) {
        if (TextUtils.isEmpty((CharSequence)param1) || TextUtils.isEmpty((CharSequence)param2) || TextUtils.isEmpty((CharSequence)sdf)) {
            return false;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(sdf, Locale.getDefault());
        try {
            long date1 = simpleDateFormat.parse(param1).getTime();
            long date2 = simpleDateFormat.parse(param2).getTime();
            return date2 > date1;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isDateExpire(String dateStr, int seconds, String sdf) {
        if (TextUtils.isEmpty((CharSequence)dateStr) || TextUtils.isEmpty((CharSequence)sdf)) {
            return false;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(sdf, Locale.getDefault());
        try {
            Date date = simpleDateFormat.parse(dateStr);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.add(13, seconds);
            return new Date().after(calendar.getTime());
        }
        catch (ParseException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isDateExpire(String dateStr, String sdf) {
        if (TextUtils.isEmpty((CharSequence)dateStr)) {
            return true;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(sdf, Locale.getDefault());
        try {
            long dateMillis = simpleDateFormat.parse(dateStr).getTime();
            long currentMillis = System.currentTimeMillis();
            return dateMillis < currentMillis;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return true;
        }
    }

    public static int dateAfterSeconds(String dateStr, String sdf) {
        if (TextUtils.isEmpty((CharSequence)dateStr)) {
            return -1;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(sdf, Locale.getDefault());
        try {
            long dateSecond = simpleDateFormat.parse(dateStr).getTime() / 1000L;
            long currentSecond = System.currentTimeMillis() / 1000L;
            return (int)(dateSecond - currentSecond);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static int dateAfterMinutes(String dateStr, String sdf) {
        if (TextUtils.isEmpty((CharSequence)dateStr)) {
            return -1;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(sdf, Locale.getDefault());
        try {
            long dateMinute = simpleDateFormat.parse(dateStr).getTime() / 1000L / 60L;
            long currentMinute = System.currentTimeMillis() / 1000L / 60L;
            return (int)(dateMinute - currentMinute);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static String formatDate(String dateStr, String orgSdf, String tagSdf) {
        if (TextUtils.isEmpty((CharSequence)dateStr)) {
            return "";
        }
        SimpleDateFormat simpleDateFormat1 = new SimpleDateFormat(orgSdf, Locale.getDefault());
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat(tagSdf, Locale.getDefault());
        try {
            Date date = simpleDateFormat1.parse(dateStr);
            return simpleDateFormat2.format(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String formatHHMM(long currentMillis) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(SDF_TYPE_5, Locale.getDefault());
        return simpleDateFormat.format(new Date(currentMillis));
    }

    public static String formatHHMM(String value) {
        if (TextUtils.isEmpty((CharSequence)value)) {
            return "";
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(SDF_TYPE_1, Locale.getDefault());
        SimpleDateFormat simpleDateFormat1 = new SimpleDateFormat(SDF_TYPE_5, Locale.getDefault());
        try {
            Date date = simpleDateFormat.parse(value);
            return simpleDateFormat1.format(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String formatHHMMSS(String value) {
        if (TextUtils.isEmpty((CharSequence)value)) {
            return "";
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(SDF_TYPE_1, Locale.getDefault());
        SimpleDateFormat simpleDateFormat1 = new SimpleDateFormat(SDF_TYPE_13, Locale.getDefault());
        try {
            Date date = simpleDateFormat.parse(value);
            return simpleDateFormat1.format(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String formatTimeStr(String value) {
        if (TextUtils.isEmpty((CharSequence)value)) {
            return "";
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(SDF_TYPE_12, Locale.getDefault());
        SimpleDateFormat simpleDateFormat1 = new SimpleDateFormat(SDF_TYPE_11, Locale.getDefault());
        try {
            Date date = simpleDateFormat.parse(value);
            return simpleDateFormat1.format(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String formatHHMMSS(long currentMills) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(SDF_TYPE_13, Locale.getDefault());
        return simpleDateFormat.format(new Date(currentMills));
    }

    public static String formatDate(long currentMills, String sdf) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(sdf, Locale.getDefault());
        return simpleDateFormat.format(new Date(currentMills));
    }

    public static String formatDate(Date date, String sdf) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(sdf, Locale.getDefault());
        return simpleDateFormat.format(date);
    }

    public static long formatTime(String date, String sdf) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(sdf, Locale.getDefault());
        try {
            return simpleDateFormat.parse(date).getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static long formatTimeType1(String dateStr) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(SDF_TYPE_1, Locale.getDefault());
        try {
            return simpleDateFormat.parse(dateStr).getTime();
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public static long getTodayStartTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTimeInMillis();
    }

    public static long getTodayEndTime() {
        Calendar todayEnd = Calendar.getInstance();
        todayEnd.set(11, 23);
        todayEnd.set(12, 59);
        todayEnd.set(13, 59);
        todayEnd.set(14, 999);
        return todayEnd.getTimeInMillis();
    }

    public static String getWeek(long currentMills) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(currentMills));
        int day = calendar.get(7);
        switch (day) {
            case 1: {
                return "\u661f\u671f\u5929";
            }
            case 2: {
                return "\u661f\u671f\u4e00";
            }
            case 3: {
                return "\u661f\u671f\u4e8c";
            }
            case 4: {
                return "\u661f\u671f\u4e09";
            }
            case 5: {
                return "\u661f\u671f\u56db";
            }
            case 6: {
                return "\u661f\u671f\u4e94";
            }
        }
        return "\u661f\u671f\u516d";
    }

    public static String getWeekEn(long currentMills) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(currentMills));
        int day = calendar.get(7);
        switch (day) {
            case 1: {
                return "Sun";
            }
            case 2: {
                return "Mon";
            }
            case 3: {
                return "Tue";
            }
            case 4: {
                return "Wed";
            }
            case 5: {
                return "Thur";
            }
            case 6: {
                return "Fri";
            }
        }
        return "Sat";
    }

    public static int getDayOfWeek() {
        Calendar calendar = Calendar.getInstance();
        int dayOfWeek = calendar.get(7);
        return dayOfWeek - 1;
    }

    public static String formatYYYYMMDD(long currentMills) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());
        return simpleDateFormat.format(new Date(currentMills));
    }

    public static String formatMMDD(long currentMills) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd", Locale.getDefault());
        return simpleDateFormat.format(new Date(currentMills));
    }

    public static String formatInterval(String dateStr) {
        if (TextUtils.isEmpty((CharSequence)dateStr)) {
            return "";
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(SDF_TYPE_1, Locale.getDefault());
        try {
            Date createDate = simpleDateFormat.parse(dateStr);
            Date nowDate = new Date();
            Calendar nowCalendar = Calendar.getInstance();
            nowCalendar.setTime(nowDate);
            Calendar createCalendar = Calendar.getInstance();
            createCalendar.setTime(createDate);
            int year = nowCalendar.get(1) - createCalendar.get(1);
            if (year > 0) {
                return UtDateFormat.formatDate(dateStr, SDF_TYPE_1, SDF_TYPE_7);
            }
            int month = nowCalendar.get(2) - createCalendar.get(2);
            if (month > 0) {
                return UtDateFormat.formatDate(dateStr, SDF_TYPE_1, SDF_TYPE_9);
            }
            int day = nowCalendar.get(5) - createCalendar.get(5);
            if (day >= 3) {
                return UtDateFormat.formatDate(dateStr, SDF_TYPE_1, SDF_TYPE_9);
            }
            if (day >= 2) {
                return "\u524d\u5929" + UtDateFormat.formatDate(dateStr, SDF_TYPE_1, SDF_TYPE_5);
            }
            if (day >= 1) {
                return "\u6628\u5929" + UtDateFormat.formatDate(dateStr, SDF_TYPE_1, SDF_TYPE_5);
            }
            long second = (nowDate.getTime() - createDate.getTime()) / 1000L;
            if (second / 60L > 5L) {
                return "\u4eca\u5929" + UtDateFormat.formatDate(dateStr, SDF_TYPE_1, SDF_TYPE_5);
            }
            return "\u521a\u521a";
        }
        catch (ParseException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String formatInterval(long millis) {
        if (millis == 0L) {
            return "";
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(SDF_TYPE_1, Locale.getDefault());
        return UtDateFormat.formatInterval(simpleDateFormat.format(new Date(millis)));
    }

    public static long formatTimeMillis(String ts, String format) {
        if (TextUtils.isEmpty((CharSequence)ts)) {
            return 0L;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format, Locale.getDefault());
        try {
            long t = simpleDateFormat.parse(ts).getTime();
            return t;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static String formatBirthday(String birthDayStr, String format) {
        if (birthDayStr.equals("null") || birthDayStr.isEmpty()) {
            return "";
        }
        long currentTime = new Date().getTime();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format, Locale.getDefault());
        long birthTime = 0L;
        try {
            birthTime = simpleDateFormat.parse(birthDayStr).getTime();
            if (birthTime > currentTime) {
                return "\u8fd8\u6ca1\u51fa\u751f\u54e6";
            }
            Calendar currentCalendar = Calendar.getInstance();
            currentCalendar.setTimeInMillis(currentTime);
            int currentYear = currentCalendar.get(1);
            int currentMonth = currentCalendar.get(2);
            int currentDay = currentCalendar.get(5);
            Calendar birthCalendar = Calendar.getInstance();
            birthCalendar.setTimeInMillis(birthTime);
            int birthYear = birthCalendar.get(1);
            int birthMonth = birthCalendar.get(2);
            int birthDay = birthCalendar.get(5);
            int year = 0;
            int month = 0;
            int day = 0;
            day = currentDay - birthDay + 1;
            if (day <= 0) {
                day = UtDateFormat.getMonthOfDays(currentYear, currentMonth) - birthDay + currentDay + 1;
                month = -1;
            }
            if ((month += currentMonth - birthMonth) < 0) {
                month = 12 + month;
                year = -1;
            }
            if ((year += currentYear - birthYear) > 0) {
                if (month > 0) {
                    return year + "\u5c81" + month + "\u4e2a\u6708";
                }
                return year + "\u5c81";
            }
            if (month > 0) {
                return month + "\u4e2a\u6708";
            }
            return day - 1 + "\u5929";
        }
        catch (ParseException e) {
            e.printStackTrace();
            return "";
        }
    }

    private static int getMonthOfDays(int year, int month) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, month - 1);
        calendar.set(5, 1);
        calendar.roll(5, -1);
        return calendar.get(5);
    }

    public static String formatTimeDes(long milliseconds) {
        if (milliseconds <= 0L || milliseconds >= 86400000L) {
            return "";
        }
        long totalSeconds = milliseconds / 1000L;
        long minutes = totalSeconds / 60L % 60L;
        long hours = totalSeconds / 3600L;
        StringBuilder stringBuilder = new StringBuilder();
        Formatter formatter = new Formatter(stringBuilder, Locale.getDefault());
        if (hours > 0L) {
            return formatter.format("%d\u5c0f\u65f6%02d\u5206\u949f\u540e", hours, minutes).toString();
        }
        return formatter.format("%02d\u5206\u949f\u540e", minutes).toString();
    }

    public static boolean isSameDay(long millis1, long millis2) {
        return UtDateFormat.formatYYYYMMDD(millis1).equals(UtDateFormat.formatYYYYMMDD(millis2));
    }
}

