/*
 * Decompiled with CFR 0.152.
 */
package com.ntt.core.service.plugins.utils;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.ccbase64.digest.DigestUtils;
import org.apache.ccbase64.digest.HmacAlgorithms;
import org.apache.ccbase64.digest.HmacUtils;

public class UtAlgorithm {
    public static String getDeviceSign(String secret, String scope, String grantType, String timestamp) {
        String contentToSignature = String.format("scope=%s&grant_type=%s&timestamp=%s", scope, grantType, timestamp);
        String hmacHex = new HmacUtils(HmacAlgorithms.HMAC_SHA_1, secret).hmacHex(contentToSignature);
        String sign = DigestUtils.md5Hex((String)hmacHex);
        return sign;
    }

    public static String getFormatMD5(String str) {
        MessageDigest md5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        char[] pswdArray = str.toCharArray();
        byte[] pswdByte = new byte[pswdArray.length];
        for (int i = 0; i < pswdArray.length; ++i) {
            pswdByte[i] = (byte)pswdArray[i];
        }
        byte[] digest = md5.digest(pswdByte);
        StringBuilder buff = new StringBuilder();
        for (byte aDigest : digest) {
            int num = aDigest & 0xFF;
            if (num < 16) {
                buff.append("0");
            }
            buff.append(Integer.toHexString(num));
        }
        return buff.toString();
    }

    public static String hmacSHA1Encrypt(String encryptText, String encryptKey) throws Exception {
        byte[] data = encryptKey.getBytes("UTF-8");
        SecretKeySpec secretKey = new SecretKeySpec(data, "HmacSHA1");
        Mac mac = Mac.getInstance("HmacSHA1");
        mac.init(secretKey);
        byte[] text = encryptText.getBytes("UTF-8");
        byte[] digest = mac.doFinal(text);
        StringBuilder stringBuilder = UtAlgorithm.bytesToHexString(digest);
        if (stringBuilder == null) {
            return "";
        }
        return stringBuilder.toString();
    }

    private static StringBuilder bytesToHexString(byte[] bytesArray) {
        if (bytesArray == null) {
            return null;
        }
        StringBuilder sBuilder = new StringBuilder();
        for (byte b : bytesArray) {
            String hv = String.format("%02x", b);
            sBuilder.append(hv);
        }
        return sBuilder;
    }

    public static String getSHA1(String val) {
        MessageDigest msgDig = null;
        try {
            msgDig = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        StringBuilder buf = new StringBuilder();
        if (msgDig != null) {
            byte[] msg;
            msgDig.update(val.getBytes());
            for (byte b : msg = msgDig.digest()) {
                int halfbyte = b >>> 4 & 0xF;
                int two_halfs = 0;
                do {
                    buf.append(halfbyte <= 9 ? (char)(48 + halfbyte) : (char)(97 + halfbyte - 10));
                    halfbyte = b & 0xF;
                } while (two_halfs++ < 1);
            }
        }
        return buf.toString();
    }
}

