/*
 * Decompiled with CFR 0.152.
 */
package com.ntt.core.service.plugins.http.parser;

import android.text.TextUtils;
import com.ntt.core.service.plugins.http.RetrofitUrlManager;
import com.ntt.core.service.plugins.http.cache.Cache;
import com.ntt.core.service.plugins.http.cache.LruCache;
import com.ntt.core.service.plugins.http.parser.UrlParser;
import java.util.ArrayList;
import java.util.List;
import okhttp3.HttpUrl;

public class SuperUrlParser
implements UrlParser {
    private RetrofitUrlManager mRetrofitUrlManager;
    private Cache<String, String> mCache;

    @Override
    public void init(RetrofitUrlManager retrofitUrlManager) {
        this.mRetrofitUrlManager = retrofitUrlManager;
        this.mCache = new LruCache<String, String>(100);
    }

    @Override
    public HttpUrl parseUrl(HttpUrl domainUrl, HttpUrl url) {
        if (null == domainUrl) {
            return url;
        }
        HttpUrl.Builder builder = url.newBuilder();
        int pathSize = this.resolvePathSize(url, builder);
        if (TextUtils.isEmpty((CharSequence)this.mCache.get(this.getKey(domainUrl, url, pathSize)))) {
            for (int i = 0; i < url.pathSize(); ++i) {
                builder.removePathSegment(0);
            }
            ArrayList<String> newPathSegments = new ArrayList<String>();
            newPathSegments.addAll(domainUrl.encodedPathSegments());
            if (url.pathSize() > pathSize) {
                List encodedPathSegments = url.encodedPathSegments();
                for (int i = pathSize; i < encodedPathSegments.size(); ++i) {
                    newPathSegments.add((String)encodedPathSegments.get(i));
                }
            } else if (url.pathSize() < pathSize) {
                throw new IllegalArgumentException(String.format("Your final path is %s, the pathSize = %d, but the #baseurl_path_size = %d, #baseurl_path_size must be less than or equal to pathSize of the final path", url.scheme() + "://" + url.host() + url.encodedPath(), url.pathSize(), pathSize));
            }
            for (String PathSegment : newPathSegments) {
                builder.addEncodedPathSegment(PathSegment);
            }
        } else {
            builder.encodedPath(this.mCache.get(this.getKey(domainUrl, url, pathSize)));
        }
        HttpUrl httpUrl = builder.scheme(domainUrl.scheme()).host(domainUrl.host()).port(domainUrl.port()).build();
        if (TextUtils.isEmpty((CharSequence)this.mCache.get(this.getKey(domainUrl, url, pathSize)))) {
            this.mCache.put(this.getKey(domainUrl, url, pathSize), httpUrl.encodedPath());
        }
        return httpUrl;
    }

    private String getKey(HttpUrl domainUrl, HttpUrl url, int PathSize) {
        return domainUrl.encodedPath() + url.encodedPath() + PathSize;
    }

    private int resolvePathSize(HttpUrl httpUrl, HttpUrl.Builder builder) {
        String fragment = httpUrl.fragment();
        int pathSize = 0;
        StringBuffer newFragment = new StringBuffer();
        if (fragment.indexOf("#") == -1) {
            String[] split = fragment.split("=");
            if (split.length > 1) {
                pathSize = Integer.parseInt(split[1]);
            }
        } else if (fragment.indexOf("#baseurl_path_size=") == -1) {
            int index = fragment.indexOf("#");
            newFragment.append(fragment.substring(index + 1, fragment.length()));
            String[] split = fragment.substring(0, index).split("=");
            if (split.length > 1) {
                pathSize = Integer.parseInt(split[1]);
            }
        } else {
            String[] split = fragment.split("#baseurl_path_size=");
            newFragment.append(split[0]);
            if (split.length > 1) {
                int index = split[1].indexOf("#");
                if (index != -1) {
                    newFragment.append(split[1].substring(index, split[1].length()));
                    String substring = split[1].substring(0, index);
                    if (!TextUtils.isEmpty((CharSequence)substring)) {
                        pathSize = Integer.parseInt(substring);
                    }
                } else {
                    pathSize = Integer.parseInt(split[1]);
                }
            }
        }
        if (TextUtils.isEmpty((CharSequence)newFragment.toString())) {
            builder.fragment(null);
        } else {
            builder.fragment(newFragment.toString());
        }
        return pathSize;
    }
}

