/*
 * Decompiled with CFR 0.152.
 */
package com.ntt.core.service.plugins.http.parser;

import android.text.TextUtils;
import com.ntt.core.service.plugins.http.RetrofitUrlManager;
import com.ntt.core.service.plugins.http.cache.Cache;
import com.ntt.core.service.plugins.http.cache.LruCache;
import com.ntt.core.service.plugins.http.parser.UrlParser;
import java.util.ArrayList;
import okhttp3.HttpUrl;

public class DomainUrlParser
implements UrlParser {
    private Cache<String, String> mCache;

    @Override
    public void init(RetrofitUrlManager retrofitUrlManager) {
        this.mCache = new LruCache<String, String>(100);
    }

    @Override
    public HttpUrl parseUrl(HttpUrl domainUrl, HttpUrl url) {
        if (null == domainUrl) {
            return url;
        }
        HttpUrl.Builder builder = url.newBuilder();
        if (TextUtils.isEmpty((CharSequence)this.mCache.get(this.getKey(domainUrl, url)))) {
            for (int i = 0; i < url.pathSize(); ++i) {
                builder.removePathSegment(0);
            }
            ArrayList newPathSegments = new ArrayList();
            newPathSegments.addAll(domainUrl.encodedPathSegments());
            newPathSegments.addAll(url.encodedPathSegments());
            for (String PathSegment : newPathSegments) {
                builder.addEncodedPathSegment(PathSegment);
            }
        } else {
            builder.encodedPath(this.mCache.get(this.getKey(domainUrl, url)));
        }
        HttpUrl httpUrl = builder.scheme(domainUrl.scheme()).host(domainUrl.host()).port(domainUrl.port()).build();
        if (TextUtils.isEmpty((CharSequence)this.mCache.get(this.getKey(domainUrl, url)))) {
            this.mCache.put(this.getKey(domainUrl, url), httpUrl.encodedPath());
        }
        return httpUrl;
    }

    private String getKey(HttpUrl domainUrl, HttpUrl url) {
        return domainUrl.encodedPath() + url.encodedPath();
    }
}

