/*
 * Decompiled with CFR 0.152.
 */
package com.ntt.core.service.plugins.http.parser;

import com.ntt.core.service.plugins.http.RetrofitUrlManager;
import com.ntt.core.service.plugins.http.parser.AdvancedUrlParser;
import com.ntt.core.service.plugins.http.parser.DomainUrlParser;
import com.ntt.core.service.plugins.http.parser.SuperUrlParser;
import com.ntt.core.service.plugins.http.parser.UrlParser;
import okhttp3.HttpUrl;

public class DefaultUrlParser
implements UrlParser {
    private UrlParser mDomainUrlParser;
    private volatile UrlParser mAdvancedUrlParser;
    private volatile UrlParser mSuperUrlParser;
    private RetrofitUrlManager mRetrofitUrlManager;

    @Override
    public void init(RetrofitUrlManager retrofitUrlManager) {
        this.mRetrofitUrlManager = retrofitUrlManager;
        this.mDomainUrlParser = new DomainUrlParser();
        this.mDomainUrlParser.init(retrofitUrlManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpUrl parseUrl(HttpUrl domainUrl, HttpUrl url) {
        if (null == domainUrl) {
            return url;
        }
        if (url.toString().contains("#baseurl_path_size=")) {
            if (this.mSuperUrlParser == null) {
                DefaultUrlParser defaultUrlParser = this;
                synchronized (defaultUrlParser) {
                    if (this.mSuperUrlParser == null) {
                        this.mSuperUrlParser = new SuperUrlParser();
                        this.mSuperUrlParser.init(this.mRetrofitUrlManager);
                    }
                }
            }
            return this.mSuperUrlParser.parseUrl(domainUrl, url);
        }
        if (this.mRetrofitUrlManager.isAdvancedModel()) {
            if (this.mAdvancedUrlParser == null) {
                DefaultUrlParser defaultUrlParser = this;
                synchronized (defaultUrlParser) {
                    if (this.mAdvancedUrlParser == null) {
                        this.mAdvancedUrlParser = new AdvancedUrlParser();
                        this.mAdvancedUrlParser.init(this.mRetrofitUrlManager);
                    }
                }
            }
            return this.mAdvancedUrlParser.parseUrl(domainUrl, url);
        }
        return this.mDomainUrlParser.parseUrl(domainUrl, url);
    }
}

