/*
 * Decompiled with CFR 0.152.
 */
package com.ntt.core.service.plugins.http.parser;

import android.text.TextUtils;
import com.ntt.core.service.plugins.http.RetrofitUrlManager;
import com.ntt.core.service.plugins.http.cache.Cache;
import com.ntt.core.service.plugins.http.cache.LruCache;
import com.ntt.core.service.plugins.http.parser.UrlParser;
import java.util.ArrayList;
import java.util.List;
import okhttp3.HttpUrl;

public class AdvancedUrlParser
implements UrlParser {
    private RetrofitUrlManager mRetrofitUrlManager;
    private Cache<String, String> mCache;

    @Override
    public void init(RetrofitUrlManager retrofitUrlManager) {
        this.mRetrofitUrlManager = retrofitUrlManager;
        this.mCache = new LruCache<String, String>(100);
    }

    @Override
    public HttpUrl parseUrl(HttpUrl domainUrl, HttpUrl url) {
        if (null == domainUrl) {
            return url;
        }
        HttpUrl.Builder builder = url.newBuilder();
        if (TextUtils.isEmpty((CharSequence)this.mCache.get(this.getKey(domainUrl, url)))) {
            for (int i = 0; i < url.pathSize(); ++i) {
                builder.removePathSegment(0);
            }
            ArrayList<String> newPathSegments = new ArrayList<String>();
            newPathSegments.addAll(domainUrl.encodedPathSegments());
            if (url.pathSize() > this.mRetrofitUrlManager.getPathSize()) {
                List encodedPathSegments = url.encodedPathSegments();
                for (int i = this.mRetrofitUrlManager.getPathSize(); i < encodedPathSegments.size(); ++i) {
                    newPathSegments.add((String)encodedPathSegments.get(i));
                }
            } else if (url.pathSize() < this.mRetrofitUrlManager.getPathSize()) {
                throw new IllegalArgumentException(String.format("Your final path is %s, but the baseUrl of your RetrofitUrlManager#startAdvancedModel is %s", url.scheme() + "://" + url.host() + url.encodedPath(), this.mRetrofitUrlManager.getBaseUrl().scheme() + "://" + this.mRetrofitUrlManager.getBaseUrl().host() + this.mRetrofitUrlManager.getBaseUrl().encodedPath()));
            }
            for (String PathSegment : newPathSegments) {
                builder.addEncodedPathSegment(PathSegment);
            }
        } else {
            builder.encodedPath(this.mCache.get(this.getKey(domainUrl, url)));
        }
        HttpUrl httpUrl = builder.scheme(domainUrl.scheme()).host(domainUrl.host()).port(domainUrl.port()).build();
        if (TextUtils.isEmpty((CharSequence)this.mCache.get(this.getKey(domainUrl, url)))) {
            this.mCache.put(this.getKey(domainUrl, url), httpUrl.encodedPath());
        }
        return httpUrl;
    }

    private String getKey(HttpUrl domainUrl, HttpUrl url) {
        return domainUrl.encodedPath() + url.encodedPath() + this.mRetrofitUrlManager.getPathSize();
    }
}

