/*
 * Decompiled with CFR 0.152.
 */
package com.ntt.core.service.plugins.http.log;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.blankj.utilcode.util.LogUtils;
import com.ntt.core.service.plugins.http.interceptor.HttpResponseInterceptor;
import com.ntt.core.service.plugins.http.log.FormatPrinter;
import com.ntt.core.service.plugins.utils.CharacterUtil;
import com.ntt.core.service.supports.log.XLog;
import java.util.List;
import java.util.Objects;
import okhttp3.MediaType;
import okhttp3.Request;

public class DefaultFormatPrinter
implements FormatPrinter {
    private static final String TAG = "ArmsHttpLog";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String DOUBLE_SEPARATOR = LINE_SEPARATOR + LINE_SEPARATOR;
    private static final String[] OMITTED_RESPONSE = new String[]{LINE_SEPARATOR, "Omitted response body"};
    private static final String[] OMITTED_REQUEST = new String[]{LINE_SEPARATOR, "Omitted request body"};
    private static final String N = "\n";
    private static final String T = "\t";
    private static final String REQUEST_UP_LINE = "   \u250c\u2500\u2500\u2500\u2500\u2500\u2500 Request \u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500";
    private static final String END_LINE = "   \u2514\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500";
    private static final String RESPONSE_UP_LINE = "   \u250c\u2500\u2500\u2500\u2500\u2500\u2500 Response \u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500";
    private static final String BODY_TAG = "Body:";
    private static final String URL_TAG = "URL: ";
    private static final String METHOD_TAG = "Method: @";
    private static final String HEADERS_TAG = "Headers:";
    private static final String STATUS_CODE_TAG = "Status Code: ";
    private static final String RECEIVED_TAG = "Received in: ";
    private static final String CORNER_UP = "\u250c ";
    private static final String CORNER_BOTTOM = "\u2514 ";
    private static final String CENTER_LINE = "\u251c ";
    private static final String DEFAULT_LINE = "\u2502 ";
    private static ThreadLocal<Integer> last = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };
    private static final String[] ARMS = new String[]{"-A-", "-R-", "-M-", "-S-"};

    private static boolean isEmpty(String line) {
        return TextUtils.isEmpty((CharSequence)line) || N.equals(line) || T.equals(line) || TextUtils.isEmpty((CharSequence)line.trim());
    }

    @Override
    public void printJsonRequest(@NonNull Request request, @NonNull String bodyString) {
        String requestBody = LINE_SEPARATOR + BODY_TAG + LINE_SEPARATOR + bodyString;
        String tag = DefaultFormatPrinter.getTag(true);
        XLog.d(TAG, tag, requestBody);
    }

    @Override
    public void printFileRequest(@NonNull Request request) {
        String tag = DefaultFormatPrinter.getTag(true);
    }

    @Override
    public void printJsonResponse(long chainMs, boolean isSuccessful, int code, @NonNull String headers, @Nullable MediaType contentType, @Nullable String bodyString, @NonNull List<String> segments, @NonNull String message, @NonNull String responseUrl) {
        bodyString = HttpResponseInterceptor.isJson(contentType) ? CharacterUtil.jsonFormat(bodyString) : (HttpResponseInterceptor.isXml(contentType) ? CharacterUtil.xmlFormat(bodyString) : bodyString);
        String responseBody = LINE_SEPARATOR + BODY_TAG + LINE_SEPARATOR + bodyString;
        String tag = DefaultFormatPrinter.getTag(false);
        String[] urlLine = new String[]{URL_TAG + responseUrl, N};
        XLog.d(tag, urlLine, responseBody);
    }

    @Override
    public void printFileResponse(long chainMs, boolean isSuccessful, int code, @NonNull String headers, @NonNull List<String> segments, @NonNull String message, @NonNull String responseUrl) {
        String tag = DefaultFormatPrinter.getTag(false);
        String[] urlLine = new String[]{URL_TAG + responseUrl, N};
        LogUtils.d(TAG, RESPONSE_UP_LINE);
        DefaultFormatPrinter.logLines(tag, urlLine, true);
        DefaultFormatPrinter.logLines(tag, DefaultFormatPrinter.getResponse(headers, chainMs, code, isSuccessful, segments, message), true);
        DefaultFormatPrinter.logLines(tag, OMITTED_RESPONSE, true);
        LogUtils.d(TAG, END_LINE);
    }

    private static void logLines(String tag, String[] lines, boolean withLineSize) {
        for (String line : lines) {
            int lineLength = line.length();
            int MAX_LONG_SIZE = withLineSize ? 110 : lineLength;
            for (int i = 0; i <= lineLength / MAX_LONG_SIZE; ++i) {
                int start = i * MAX_LONG_SIZE;
                int end = (i + 1) * MAX_LONG_SIZE;
                end = Math.min(end, line.length());
                LogUtils.d(DefaultFormatPrinter.resolveTag(tag), DEFAULT_LINE + line.substring(start, end));
            }
        }
    }

    private static String computeKey() {
        if (last.get() >= 4) {
            last.set(0);
        }
        String s = ARMS[last.get()];
        last.set(last.get() + 1);
        return s;
    }

    private static String resolveTag(String tag) {
        return DefaultFormatPrinter.computeKey() + tag;
    }

    private static String[] getRequest(Request request) {
        String header = request.headers().toString();
        String log = METHOD_TAG + request.method() + DOUBLE_SEPARATOR + (DefaultFormatPrinter.isEmpty(header) ? "" : HEADERS_TAG + LINE_SEPARATOR + DefaultFormatPrinter.dotHeaders(header));
        return log.split(LINE_SEPARATOR);
    }

    private static String[] getResponse(String header, long tookMs, int code, boolean isSuccessful, List<String> segments, String message) {
        String segmentString = DefaultFormatPrinter.slashSegments(segments);
        String log = (!TextUtils.isEmpty((CharSequence)segmentString) ? segmentString + " - " : "") + "is success : " + isSuccessful + " - " + RECEIVED_TAG + tookMs + "ms" + DOUBLE_SEPARATOR + STATUS_CODE_TAG + code + " / " + message + DOUBLE_SEPARATOR + (DefaultFormatPrinter.isEmpty(header) ? "" : HEADERS_TAG + LINE_SEPARATOR + DefaultFormatPrinter.dotHeaders(header));
        return log.split(Objects.requireNonNull(LINE_SEPARATOR));
    }

    private static String slashSegments(List<String> segments) {
        StringBuilder segmentString = new StringBuilder();
        for (String segment : segments) {
            segmentString.append("/").append(segment);
        }
        return segmentString.toString();
    }

    private static String dotHeaders(String header) {
        String[] headers = header.split(LINE_SEPARATOR);
        StringBuilder builder = new StringBuilder();
        String tag = "\u2500 ";
        if (headers.length > 1) {
            for (int i = 0; i < headers.length; ++i) {
                tag = i == 0 ? CORNER_UP : (i == headers.length - 1 ? CORNER_BOTTOM : CENTER_LINE);
                builder.append(tag).append(headers[i]).append(N);
            }
        } else {
            for (String item : headers) {
                builder.append(tag).append(item).append(N);
            }
        }
        return builder.toString();
    }

    private static String getTag(boolean isRequest) {
        if (isRequest) {
            return "ArmsHttpLog-Request";
        }
        return "ArmsHttpLog-Response";
    }
}

