/*
 * Decompiled with CFR 0.152.
 */
package com.ntt.core.service.plugins.http.interceptor;

import androidx.annotation.Nullable;
import com.ntt.core.service.CoreServiceImpl;
import com.ntt.core.service.plugins.http.log.DefaultFormatPrinter;
import com.ntt.core.service.plugins.http.log.FormatPrinter;
import com.ntt.core.service.plugins.utils.CharacterUtil;
import com.ntt.core.service.plugins.utils.UrlEncoderUtil;
import com.ntt.core.service.plugins.utils.ZipUtil;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;

public class HttpResponseInterceptor
implements Interceptor {
    FormatPrinter mPrinter = new DefaultFormatPrinter();
    Level printLevel = Level.ALL;

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        int code;
        long t2;
        Request request = chain.request();
        Response originalResponse = null;
        boolean logResponse = this.printLevel == Level.ALL || this.printLevel != Level.NONE && this.printLevel == Level.RESPONSE;
        long t1 = logResponse ? System.nanoTime() : 0L;
        try {
            originalResponse = chain.proceed(request);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ResponseBody responseBody = originalResponse.body();
        String bodyString = null;
        if (responseBody != null && HttpResponseInterceptor.isParseable(responseBody.contentType())) {
            bodyString = this.printResult(request, originalResponse, logResponse);
        }
        long l = t2 = logResponse ? System.nanoTime() : 0L;
        if (logResponse) {
            List segmentList = request.url().encodedPathSegments();
            String header = originalResponse.headers().toString();
            int code2 = originalResponse.code();
            boolean isSuccessful = originalResponse.isSuccessful();
            String message = originalResponse.message();
            String url = originalResponse.request().url().toString();
            if (responseBody != null && HttpResponseInterceptor.isParseable(responseBody.contentType())) {
                this.mPrinter.printJsonResponse(TimeUnit.NANOSECONDS.toMillis(t2 - t1), isSuccessful, code2, header, responseBody.contentType(), bodyString, segmentList, message, url);
            } else {
                this.mPrinter.printFileResponse(TimeUnit.NANOSECONDS.toMillis(t2 - t1), isSuccessful, code2, header, segmentList, message, url);
            }
        }
        if ((code = originalResponse.code()) == 401) {
            CoreServiceImpl.getInstance().forceRefreshToken();
        }
        return originalResponse;
    }

    @Nullable
    private String printResult(Request request, Response response, boolean log) throws IOException {
        try {
            ResponseBody responseBody = response.newBuilder().build().body();
            BufferedSource source = responseBody.source();
            source.request(Long.MAX_VALUE);
            Buffer buffer = source.buffer();
            String encoding = response.headers().get("Content-Encoding");
            Buffer clone = buffer.clone();
            return this.parseContent(responseBody, encoding, clone);
        }
        catch (IOException e) {
            e.printStackTrace();
            return "{\"error\": \"" + e.getMessage() + "\"}";
        }
    }

    private String parseContent(ResponseBody responseBody, String encoding, Buffer clone) {
        Charset charset = StandardCharsets.UTF_8;
        MediaType contentType = responseBody.contentType();
        if (contentType != null) {
            charset = contentType.charset(charset);
        }
        if (encoding != null && encoding.equalsIgnoreCase("gzip")) {
            return ZipUtil.decompressForGzip(clone.readByteArray(), HttpResponseInterceptor.convertCharset(charset));
        }
        if (encoding != null && encoding.equalsIgnoreCase("zlib")) {
            return ZipUtil.decompressToStringForZlib(clone.readByteArray(), HttpResponseInterceptor.convertCharset(charset));
        }
        return clone.readString(charset);
    }

    public static String parseParams(Request request) {
        try {
            String json;
            RequestBody body = request.newBuilder().build().body();
            if (body == null) {
                return "";
            }
            Buffer requestbuffer = new Buffer();
            body.writeTo((BufferedSink)requestbuffer);
            Charset charset = StandardCharsets.UTF_8;
            MediaType contentType = body.contentType();
            if (contentType != null) {
                charset = contentType.charset(charset);
            }
            if (UrlEncoderUtil.hasUrlEncoded(json = requestbuffer.readString(charset))) {
                json = URLDecoder.decode(json, HttpResponseInterceptor.convertCharset(charset));
            }
            return CharacterUtil.jsonFormat(json);
        }
        catch (IOException e) {
            e.printStackTrace();
            return "{\"error\": \"" + e.getMessage() + "\"}";
        }
    }

    public static boolean isParseable(MediaType mediaType) {
        if (mediaType == null) {
            return false;
        }
        mediaType.type();
        return HttpResponseInterceptor.isText(mediaType) || HttpResponseInterceptor.isPlain(mediaType) || HttpResponseInterceptor.isJson(mediaType) || HttpResponseInterceptor.isForm(mediaType) || HttpResponseInterceptor.isHtml(mediaType) || HttpResponseInterceptor.isXml(mediaType);
    }

    public static boolean isText(MediaType mediaType) {
        if (mediaType == null) {
            return false;
        }
        mediaType.type();
        return mediaType.type().equals("text");
    }

    public static boolean isPlain(MediaType mediaType) {
        if (mediaType == null) {
            return false;
        }
        mediaType.subtype();
        return mediaType.subtype().toLowerCase().contains("plain");
    }

    public static boolean isJson(MediaType mediaType) {
        if (mediaType == null || mediaType.subtype() == null) {
            return false;
        }
        return mediaType.subtype().toLowerCase().contains("json");
    }

    public static boolean isXml(MediaType mediaType) {
        if (mediaType == null || mediaType.subtype() == null) {
            return false;
        }
        return mediaType.subtype().toLowerCase().contains("xml");
    }

    public static boolean isHtml(MediaType mediaType) {
        if (mediaType == null || mediaType.subtype() == null) {
            return false;
        }
        return mediaType.subtype().toLowerCase().contains("html");
    }

    public static boolean isForm(MediaType mediaType) {
        if (mediaType == null || mediaType.subtype() == null) {
            return false;
        }
        return mediaType.subtype().toLowerCase().contains("x-www-form-urlencoded");
    }

    public static String convertCharset(Charset charset) {
        String s = charset.toString();
        int i = s.indexOf("[");
        if (i == -1) {
            return s;
        }
        return s.substring(i + 1, s.length() - 1);
    }

    public static enum Level {
        NONE,
        REQUEST,
        RESPONSE,
        ALL;

    }
}

