/*
 * Decompiled with CFR 0.152.
 */
package com.ntt.core.service.plugins.http.exception;

import android.content.Context;
import com.ntt.core.service.plugins.http.exception.ExceptionHandlerDelegate;
import com.ntt.core.service.plugins.http.exception.ResponseExceptionListener;

public class RxExceptionHandler {
    private ExceptionHandlerDelegate mHandlerFactory;

    private RxExceptionHandler(Builder builder) {
        this.mHandlerFactory = builder.mExceptionHandlerDelegate;
    }

    public ExceptionHandlerDelegate getHandlerFactory() {
        return this.mHandlerFactory;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Context mContext;
        private ResponseExceptionListener mResponseExceptionListener;
        private ExceptionHandlerDelegate mExceptionHandlerDelegate;

        public Builder with(Context context) {
            this.mContext = context;
            return this;
        }

        public Builder responseExceptionListener(ResponseExceptionListener responseExceptionListener) {
            this.mResponseExceptionListener = responseExceptionListener;
            return this;
        }

        public RxExceptionHandler build() {
            if (this.mContext == null) {
                throw new IllegalStateException("Context is Null");
            }
            if (this.mResponseExceptionListener == null) {
                throw new IllegalStateException("responseExceptionListener is Null");
            }
            this.mExceptionHandlerDelegate = new ExceptionHandlerDelegate(this.mContext, this.mResponseExceptionListener);
            return new RxExceptionHandler(this);
        }
    }
}

