/*
 * Decompiled with CFR 0.152.
 */
package com.ntt.core.service.plugins.http;

import android.text.TextUtils;
import android.util.Log;
import com.ntt.core.service.plugins.http.Utils;
import com.ntt.core.service.plugins.http.onUrlChangeListener;
import com.ntt.core.service.plugins.http.parser.DefaultUrlParser;
import com.ntt.core.service.plugins.http.parser.UrlParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;

public class RetrofitUrlManager {
    private static final String TAG = "RetrofitUrlManager";
    private static final boolean DEPENDENCY_OKHTTP;
    private static final String DOMAIN_NAME = "Domain-Name";
    private static final String GLOBAL_DOMAIN_NAME = "me.jessyan.retrofiturlmanager.globalDomainName";
    public static final String DOMAIN_NAME_HEADER = "Domain-Name: ";
    public static final String IDENTIFICATION_IGNORE = "#url_ignore";
    public static final String IDENTIFICATION_PATH_SIZE = "#baseurl_path_size=";
    private HttpUrl baseUrl;
    private int pathSize;
    private boolean isRun = true;
    private boolean debug = false;
    private final Map<String, HttpUrl> mDomainNameHub = new HashMap<String, HttpUrl>();
    private final Interceptor mInterceptor;
    private final List<onUrlChangeListener> mListeners = new ArrayList<onUrlChangeListener>();
    private UrlParser mUrlParser;

    private RetrofitUrlManager() {
        if (!DEPENDENCY_OKHTTP) {
            throw new IllegalStateException("Must be dependency Okhttp");
        }
        DefaultUrlParser urlParser = new DefaultUrlParser();
        urlParser.init(this);
        this.setUrlParser(urlParser);
        this.mInterceptor = chain -> {
            if (!this.isRun()) {
                return chain.proceed(chain.request());
            }
            return chain.proceed(this.processRequest(chain.request()));
        };
    }

    public static final RetrofitUrlManager getInstance() {
        return RetrofitUrlManagerHolder.INSTANCE;
    }

    public OkHttpClient.Builder with(OkHttpClient.Builder builder) {
        Utils.checkNotNull(builder, "builder cannot be null");
        return builder.addInterceptor(this.mInterceptor);
    }

    public Request processRequest(Request request) {
        HttpUrl httpUrl;
        if (request == null) {
            return request;
        }
        Request.Builder newBuilder = request.newBuilder();
        String url = request.url().toString();
        if (url.contains(IDENTIFICATION_IGNORE)) {
            return this.pruneIdentification(newBuilder, url);
        }
        String domainName = this.obtainDomainNameFromHeaders(request);
        Object[] listeners = this.listenersToArray();
        if (!TextUtils.isEmpty((CharSequence)domainName)) {
            this.notifyListener(request, domainName, listeners);
            httpUrl = this.fetchDomain(domainName);
            newBuilder.removeHeader(DOMAIN_NAME);
        } else {
            this.notifyListener(request, GLOBAL_DOMAIN_NAME, listeners);
            httpUrl = this.getGlobalDomain();
        }
        if (null != httpUrl) {
            HttpUrl newUrl = this.mUrlParser.parseUrl(httpUrl, request.url());
            if (this.debug) {
                Log.d((String)TAG, (String)("The new url is { " + newUrl.toString() + " }, old url is { " + request.url().toString() + " }"));
            }
            if (listeners != null) {
                for (int i = 0; i < listeners.length; ++i) {
                    ((onUrlChangeListener)listeners[i]).onUrlChanged(newUrl, request.url());
                }
            }
            return newBuilder.url(newUrl).build();
        }
        return newBuilder.build();
    }

    private Request pruneIdentification(Request.Builder newBuilder, String url) {
        String[] split = url.split(IDENTIFICATION_IGNORE);
        StringBuffer buffer = new StringBuffer();
        for (String s : split) {
            buffer.append(s);
        }
        return newBuilder.url(buffer.toString()).build();
    }

    private void notifyListener(Request request, String domainName, Object[] listeners) {
        if (listeners != null) {
            for (int i = 0; i < listeners.length; ++i) {
                ((onUrlChangeListener)listeners[i]).onUrlChangeBefore(request.url(), domainName);
            }
        }
    }

    public boolean isRun() {
        return this.isRun;
    }

    public void setRun(boolean run) {
        this.isRun = run;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void startAdvancedModel(String baseUrl) {
        Utils.checkNotNull(baseUrl, "baseUrl cannot be null");
        this.startAdvancedModel(Utils.checkUrl(baseUrl));
    }

    public synchronized void startAdvancedModel(HttpUrl baseUrl) {
        Utils.checkNotNull(baseUrl, "baseUrl cannot be null");
        this.baseUrl = baseUrl;
        this.pathSize = baseUrl.pathSize();
        List baseUrlpathSegments = baseUrl.pathSegments();
        if ("".equals(baseUrlpathSegments.get(baseUrlpathSegments.size() - 1))) {
            --this.pathSize;
        }
    }

    public int getPathSize() {
        return this.pathSize;
    }

    public boolean isAdvancedModel() {
        return this.baseUrl != null;
    }

    public HttpUrl getBaseUrl() {
        return this.baseUrl;
    }

    public String setUrlNotChange(String url) {
        Utils.checkNotNull(url, "url cannot be null");
        return url + IDENTIFICATION_IGNORE;
    }

    public String setPathSizeOfUrl(String url, int pathSize) {
        Utils.checkNotNull(url, "url cannot be null");
        if (pathSize < 0) {
            throw new IllegalArgumentException("pathSize must be >= 0");
        }
        return url + IDENTIFICATION_PATH_SIZE + pathSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGlobalDomain(String globalDomain) {
        Utils.checkNotNull(globalDomain, "globalDomain cannot be null");
        Map<String, HttpUrl> map = this.mDomainNameHub;
        synchronized (map) {
            this.mDomainNameHub.put(GLOBAL_DOMAIN_NAME, Utils.checkUrl(globalDomain));
        }
    }

    public synchronized HttpUrl getGlobalDomain() {
        return this.mDomainNameHub.get(GLOBAL_DOMAIN_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGlobalDomain() {
        Map<String, HttpUrl> map = this.mDomainNameHub;
        synchronized (map) {
            this.mDomainNameHub.remove(GLOBAL_DOMAIN_NAME);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putDomain(String domainName, String domainUrl) {
        Utils.checkNotNull(domainName, "domainName cannot be null");
        Utils.checkNotNull(domainUrl, "domainUrl cannot be null");
        Map<String, HttpUrl> map = this.mDomainNameHub;
        synchronized (map) {
            this.mDomainNameHub.put(domainName, Utils.checkUrl(domainUrl));
        }
    }

    public synchronized HttpUrl fetchDomain(String domainName) {
        Utils.checkNotNull(domainName, "domainName cannot be null");
        return this.mDomainNameHub.get(domainName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDomain(String domainName) {
        Utils.checkNotNull(domainName, "domainName cannot be null");
        Map<String, HttpUrl> map = this.mDomainNameHub;
        synchronized (map) {
            this.mDomainNameHub.remove(domainName);
        }
    }

    public void clearAllDomain() {
        this.mDomainNameHub.clear();
    }

    public synchronized boolean haveDomain(String domainName) {
        return this.mDomainNameHub.containsKey(domainName);
    }

    public synchronized int domainSize() {
        return this.mDomainNameHub.size();
    }

    public void setUrlParser(UrlParser parser) {
        Utils.checkNotNull(parser, "parser cannot be null");
        this.mUrlParser = parser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerUrlChangeListener(onUrlChangeListener listener) {
        Utils.checkNotNull(listener, "listener cannot be null");
        List<onUrlChangeListener> list = this.mListeners;
        synchronized (list) {
            this.mListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterUrlChangeListener(onUrlChangeListener listener) {
        Utils.checkNotNull(listener, "listener cannot be null");
        List<onUrlChangeListener> list = this.mListeners;
        synchronized (list) {
            this.mListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] listenersToArray() {
        Object[] listeners = null;
        List<onUrlChangeListener> list = this.mListeners;
        synchronized (list) {
            if (this.mListeners.size() > 0) {
                listeners = this.mListeners.toArray();
            }
        }
        return listeners;
    }

    private String obtainDomainNameFromHeaders(Request request) {
        List headers = request.headers(DOMAIN_NAME);
        if (headers == null || headers.size() == 0) {
            return null;
        }
        if (headers.size() > 1) {
            throw new IllegalArgumentException("Only one Domain-Name in the headers");
        }
        return request.header(DOMAIN_NAME);
    }

    static {
        boolean hasDependency;
        try {
            Class.forName("okhttp3.OkHttpClient");
            hasDependency = true;
        }
        catch (ClassNotFoundException e) {
            hasDependency = false;
        }
        DEPENDENCY_OKHTTP = hasDependency;
    }

    private static class RetrofitUrlManagerHolder {
        private static final RetrofitUrlManager INSTANCE = new RetrofitUrlManager();

        private RetrofitUrlManagerHolder() {
        }
    }
}

