/*
 * Decompiled with CFR 0.152.
 */
package com.ntt.core.service.plugins.http;

import androidx.annotation.NonNull;
import com.ntt.core.service.CoreServiceImpl;
import com.ntt.core.service.plugins.http.RetrofitUrlManager;
import com.ntt.core.service.plugins.http.interceptor.HttpHeadInterceptor;
import com.ntt.core.service.plugins.http.interceptor.HttpResponseInterceptor;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava3.RxJava3CallAdapterFactory;
import retrofit2.converter.gson.GsonConverterFactory;

public class HTTPManager {
    private OkHttpClient mOkHttpClient = RetrofitUrlManager.getInstance().with(new OkHttpClient.Builder()).readTimeout(3L, TimeUnit.SECONDS).connectTimeout(3L, TimeUnit.SECONDS).writeTimeout(3L, TimeUnit.SECONDS).addInterceptor((Interceptor)new HttpHeadInterceptor()).addNetworkInterceptor((Interceptor)new HttpResponseInterceptor()).build();
    private Retrofit mRetrofit = new Retrofit.Builder().baseUrl(CoreServiceImpl.getInstance().getUseHost()).addCallAdapterFactory((CallAdapter.Factory)RxJava3CallAdapterFactory.create()).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).client(this.mOkHttpClient).build();

    public static final HTTPManager getInstance() {
        return HTTPManagerHolder.INSTANCE;
    }

    private HTTPManager() {
    }

    public <T> T obtainService(@NonNull Class<T> service) {
        return (T)this.mRetrofit.create(service);
    }

    private static class HTTPManagerHolder {
        private static final HTTPManager INSTANCE = new HTTPManager();

        private HTTPManagerHolder() {
        }
    }
}

