/*
 * Decompiled with CFR 0.152.
 */
package com.ntt.core.service.plugins.http;

import android.app.Application;
import android.content.Context;
import com.blankj.utilcode.util.Utils;
import com.ntt.core.service.plugins.http.BaseResp;
import com.ntt.core.service.plugins.http.exception.ExceptionHandlerDelegate;
import com.ntt.core.service.plugins.http.exception.HttpException;
import com.ntt.core.service.plugins.http.exception.ResponseExceptionListener;
import com.ntt.core.service.plugins.http.exception.RxExceptionHandler;
import com.ntt.core.service.plugins.http.exception.ServerException;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;

public abstract class BaseObserver<T>
implements Observer<BaseResp<T>> {
    private ExceptionHandlerDelegate mHandlerDelegate;

    public BaseObserver(RxExceptionHandler rxExceptionHandler) {
        this.mHandlerDelegate = rxExceptionHandler.getHandlerFactory();
    }

    public BaseObserver() {
        Application context = Utils.getApp();
        this.mHandlerDelegate = new ExceptionHandlerDelegate((Context)context, new ResponseExceptionListener(){

            @Override
            public HttpException handleException(Context context, Throwable throwable) {
                return new HttpException(throwable, 100);
            }
        });
    }

    public void onSubscribe(Disposable d) {
    }

    public void onNext(BaseResp<T> tBaseResp) {
        if (tBaseResp == null) {
            return;
        }
        if (tBaseResp.isSuccess()) {
            this.onSuccess(tBaseResp.getData());
        } else {
            if (this.mHandlerDelegate == null) {
                return;
            }
            ServerException serverException = this.handleServerException(tBaseResp.getCode(), tBaseResp.getMessage());
            HttpException httpException = this.mHandlerDelegate.handleException(serverException);
            if (httpException == null) {
                return;
            }
            this.onFailure(httpException);
        }
    }

    public void onError(Throwable e) {
        if (this.mHandlerDelegate == null) {
            return;
        }
        HttpException apiException = this.mHandlerDelegate.handleException(e);
        if (apiException == null) {
            return;
        }
        this.onFailure(apiException);
    }

    public void onComplete() {
    }

    private ServerException handleServerException(int code, String message) {
        if (code == 200) {
            return null;
        }
        ServerException serverException = new ServerException();
        serverException.setCode(code);
        serverException.setMessage(message);
        return serverException;
    }

    public abstract void onSuccess(T var1);

    public abstract void onFailure(HttpException var1);
}

