/*
 * Decompiled with CFR 0.152.
 */
package com.ntt.core.service.entities.player;

import android.content.Context;
import com.blankj.utilcode.util.LogUtils;
import com.ntt.core.service.entities.SJumpEntity;
import com.ntt.core.service.entities.player.SConfigEntity;
import com.ntt.core.service.entities.player.SMediaEntity;
import com.ntt.core.service.supports.jumper.JumperManager;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.HashMap;
import java.util.List;

public class SPlayEntity {
    public static final int AUDIO = 0;
    public static final int VIDEO = 1;
    private final int type;
    private final List<SMediaEntity> medias;
    private final int index;
    private final SConfigEntity config;
    private final long albumId;

    private SPlayEntity(Builder builder) {
        this.medias = builder.medias;
        this.index = builder.index;
        this.config = builder.config;
        this.albumId = builder.albumId;
        this.type = builder.type;
    }

    public int getType() {
        return this.type;
    }

    public List<SMediaEntity> getMedias() {
        return this.medias;
    }

    public int getIndex() {
        return this.index;
    }

    public SConfigEntity getConfig() {
        return this.config;
    }

    public long getAlbumId() {
        return this.albumId;
    }

    public String toString() {
        return "{\"type\":" + this.type + ",\"medias\":" + this.medias + ",\"index\":" + this.index + ",\"config\":" + this.config + ",\"albumId\":" + this.albumId + '}';
    }

    public void toJumpPlayer(Context context) {
        LogUtils.json(this);
        SJumpEntity sJumpEntity = new SJumpEntity();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("data", this.toString());
        sJumpEntity.setCode(this.type == 0 ? "com.benew.nttr.player.mvp.ui.activity.PlayerHomeActivity" : "com.benew.nttr.player.mvp.ui.activity.VideoHomeActivity");
        sJumpEntity.setParams(params);
        new JumperManager(context).doJump(sJumpEntity);
    }

    public static final class Builder {
        private List<SMediaEntity> medias;
        private int index;
        private SConfigEntity config;
        private long albumId;
        private int type;

        public Builder setMedias(List<SMediaEntity> medias) {
            this.medias = medias;
            return this;
        }

        public Builder setIndex(int index) {
            this.index = index;
            return this;
        }

        public Builder setConfig(SConfigEntity config) {
            this.config = config;
            return this;
        }

        public Builder setAlbumId(long albumId) {
            this.albumId = albumId;
            return this;
        }

        public Builder setType(int type) {
            this.type = type;
            return this;
        }

        public SPlayEntity build() {
            return new SPlayEntity(this);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Type {
    }
}

