/*
 * Decompiled with CFR 0.152.
 */
package com.ntt.core.service;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.IBinder;
import android.os.Process;
import android.text.TextUtils;
import android.util.Log;
import com.blankj.utilcode.util.Utils;
import com.ntt.core.service.ICoreService;
import com.ntt.core.service.R;
import com.ntt.core.service.entities.SJumpEntity;
import com.ntt.core.service.plugins.sharePreference.SharePreferenceManager;
import com.ntt.core.service.supports.auth.Auth;
import com.ntt.core.service.supports.jumper.JumperManager;
import com.ntt.core.service.supports.log.XLog;
import com.ntt.core.service.supports.provider.DContentResolver;

public class CoreServiceImpl {
    private static final String TAG = CoreServiceImpl.class.getSimpleName();
    private static volatile CoreServiceImpl instance = null;
    private String mAppId;
    private Context mContext;
    private boolean isServiceConnected;
    private ICoreService mService;
    private Auth mAuth;
    private JumperManager mJumper;
    private Object mLock = new Object();
    private boolean isDebug;
    private String mDomainHost;
    private String mDeviceId;
    ServiceConnection serviceConnection = new ServiceConnection(){

        public void onServiceConnected(ComponentName name, IBinder service) {
            CoreServiceImpl.this.mService = ICoreService.Stub.asInterface(service);
            CoreServiceImpl.this.isServiceConnected = true;
            CoreServiceImpl.this.mAuth.syncToken();
            XLog.d(TAG, "CoreService\u8fde\u63a5\u6210\u529f");
        }

        public void onServiceDisconnected(ComponentName name) {
            CoreServiceImpl.this.isServiceConnected = false;
            XLog.d(TAG, "\u4e0e\u6838\u5fc3\u670d\u52a1\u65ad\u5f00\u8fde\u63a5,2\u79d2\u540e\u91cd\u65b0\u8fde\u63a5", name.getClassName());
            new Handler().postDelayed(() -> {
                XLog.d(TAG, "\u51c6\u5907\u5c1d\u8bd5\u91cd\u65b0\u8fde\u63a5...", name.getPackageName(), name.getClassName());
                CoreServiceImpl.this.connectCoreService(true);
            }, 2000L);
        }

        public void onNullBinding(ComponentName name) {
            XLog.d(TAG, "onNullBinding ", name.getClassName());
        }

        public void onBindingDied(ComponentName name) {
            XLog.d(TAG, "onBindingDied ", name.getClassName());
        }
    };

    public static void init(Context context, String appId, String appSecret) {
        CoreServiceImpl.init(context, appId, appSecret, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void init(Context context, String appId, String appSecret, boolean debug) {
        if (instance != null) return;
        Class<CoreServiceImpl> clazz = CoreServiceImpl.class;
        synchronized (CoreServiceImpl.class) {
            if (instance != null) return;
            instance = new CoreServiceImpl(context, appId, appSecret, debug);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    public static CoreServiceImpl getInstance() {
        if (instance == null) {
            throw new Error("SDK\u9700\u8981\u521d\u59cb\u5316");
        }
        return instance;
    }

    private CoreServiceImpl(Context context, String appId, String appSecret, boolean debug) {
        this.mContext = context;
        this.isDebug = debug;
        SharePreferenceManager.init(context);
        this.mAuth = new Auth(appId, appSecret);
        XLog.init(context, true);
        this.mJumper = new JumperManager(this.mContext);
        this.connectCoreService(true);
        String platform = this.getPlatform();
        if (TextUtils.isEmpty((CharSequence)platform)) {
            Log.e((String)"CoreService", (String)"\u8b66\u544a\uff1a\u975e\u5728\u725b\u542c\u542c\u5e73\u53f0\u8fd0\u884c\u6b64\u7a0b\u5e8f\uff01\uff01\uff01");
            Process.killProcess((int)Process.myPid());
        }
    }

    private void connectCoreService(boolean force) {
        if (this.mService != null && !force) {
            return;
        }
        Intent intent = new Intent("com.ntt.coreService");
        intent.setPackage("com.ntt.core.service");
        intent.putExtra("appName", this.mAppId);
        boolean ret = this.mContext.bindService(intent, this.serviceConnection, 1);
        XLog.d(TAG, "\u51c6\u5907\u8fde\u63a5\u670d\u52a1\u7ed3\u679c=" + ret);
    }

    public boolean isUseDebug() {
        return this.isDebug;
    }

    public String getUseHost() {
        return this.isUseDebug() ? this.getLocalDomainHost() : this.getServiceDomainHost();
    }

    public String forceRefreshToken() {
        return this.mAuth.getToken(true);
    }

    public String getToken() {
        String cacheHost = this.getCacheHost();
        String useHost = this.getUseHost();
        if (!cacheHost.equals(this.getUseHost())) {
            this.mAuth.clearAuthCache();
        }
        SharePreferenceManager.encodeString("CacheDomainHost", useHost);
        String token = this.mAuth.getToken(false);
        if (TextUtils.isEmpty((CharSequence)token)) {
            token = this.mAuth.getToken(true);
        }
        return token;
    }

    public String getHeadToken() {
        return this.mAuth.getHeadToken();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDeviceId() {
        Object object = this.mLock;
        synchronized (object) {
            if (!TextUtils.isEmpty((CharSequence)this.mDeviceId)) {
                return this.mDeviceId;
            }
            if (this.mService == null) {
                this.mDeviceId = DContentResolver.query(1001);
                return this.mDeviceId;
            }
            try {
                this.mDeviceId = this.mService.getDeviceId();
            }
            catch (DeadObjectException e) {
                this.connectCoreService(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return this.mDeviceId;
        }
    }

    public String getPlatform() {
        String platform = DContentResolver.query(10024);
        return platform;
    }

    public void doJump(SJumpEntity jumpEntity) {
        if (this.mJumper == null) {
            return;
        }
        this.mJumper.doJump(jumpEntity);
    }

    private String getCacheHost() {
        return SharePreferenceManager.decodeString("CacheDomainHost");
    }

    private String getLocalDomainHost() {
        if (this.isDebug) {
            return Utils.getApp().getString(R.string.ntt_api_demo);
        }
        return Utils.getApp().getString(R.string.ntt_api);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getServiceDomainHost() {
        Object object = this.mLock;
        synchronized (object) {
            if (!TextUtils.isEmpty((CharSequence)this.mDomainHost)) {
                return this.mDomainHost;
            }
            if (this.mService == null) {
                this.mDomainHost = DContentResolver.query(1002);
                XLog.d(TAG, "\u901a\u8fc7ContentProvider\u83b7\u53d6\u7684Host", this.mDomainHost);
                return this.mDomainHost;
            }
            try {
                this.mDomainHost = this.mService.getDomainHost();
            }
            catch (DeadObjectException e) {
                this.connectCoreService(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            XLog.d(TAG, "\u901a\u8fc7Service\u83b7\u53d6\u7684Host", this.mDomainHost);
            return this.mDomainHost;
        }
    }
}

