/*
 * Decompiled with CFR 0.152.
 */
package com.blankj.utilcode.util;

import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.blankj.utilcode.util.Utils;
import com.blankj.utilcode.util.UtilsBridge;
import java.util.Locale;

public class LanguageUtils {
    private static final String KEY_LOCALE = "KEY_LOCALE";
    private static final String VALUE_FOLLOW_SYSTEM = "VALUE_FOLLOW_SYSTEM";

    private LanguageUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static void applySystemLanguage() {
        LanguageUtils.applySystemLanguage(false);
    }

    public static void applySystemLanguage(boolean isRelaunchApp) {
        LanguageUtils.applyLanguageReal(null, isRelaunchApp);
    }

    public static void applyLanguage(@NonNull Locale locale) {
        LanguageUtils.applyLanguage(locale, false);
    }

    public static void applyLanguage(@NonNull Locale locale, boolean isRelaunchApp) {
        LanguageUtils.applyLanguageReal(locale, isRelaunchApp);
    }

    private static void applyLanguageReal(Locale locale, final boolean isRelaunchApp) {
        if (locale == null) {
            UtilsBridge.getSpUtils4Utils().put(KEY_LOCALE, VALUE_FOLLOW_SYSTEM, true);
        } else {
            UtilsBridge.getSpUtils4Utils().put(KEY_LOCALE, LanguageUtils.locale2String(locale), true);
        }
        Locale destLocal = locale == null ? LanguageUtils.getLocal(Resources.getSystem().getConfiguration()) : locale;
        LanguageUtils.updateAppContextLanguage(destLocal, new Utils.Consumer<Boolean>(){

            @Override
            public void accept(Boolean success) {
                if (success.booleanValue()) {
                    LanguageUtils.restart(isRelaunchApp);
                } else {
                    UtilsBridge.relaunchApp();
                }
            }
        });
    }

    private static void restart(boolean isRelaunchApp) {
        if (isRelaunchApp) {
            UtilsBridge.relaunchApp();
        } else {
            for (Activity activity : UtilsBridge.getActivityList()) {
                activity.recreate();
            }
        }
    }

    public static boolean isAppliedLanguage() {
        return LanguageUtils.getAppliedLanguage() != null;
    }

    public static boolean isAppliedLanguage(@NonNull Locale locale) {
        Locale appliedLocale = LanguageUtils.getAppliedLanguage();
        if (appliedLocale == null) {
            return false;
        }
        return LanguageUtils.isSameLocale(locale, appliedLocale);
    }

    public static Locale getAppliedLanguage() {
        String spLocaleStr = UtilsBridge.getSpUtils4Utils().getString(KEY_LOCALE);
        if (TextUtils.isEmpty((CharSequence)spLocaleStr) || VALUE_FOLLOW_SYSTEM.equals(spLocaleStr)) {
            return null;
        }
        return LanguageUtils.string2Locale(spLocaleStr);
    }

    public static Locale getContextLanguage(Context context) {
        return LanguageUtils.getLocal(context.getResources().getConfiguration());
    }

    public static Locale getAppContextLanguage() {
        return LanguageUtils.getContextLanguage((Context)Utils.getApp());
    }

    public static Locale getSystemLanguage() {
        return LanguageUtils.getLocal(Resources.getSystem().getConfiguration());
    }

    public static void updateAppContextLanguage(@NonNull Locale destLocale, @Nullable Utils.Consumer<Boolean> consumer) {
        LanguageUtils.pollCheckAppContextLocal(destLocale, 0, consumer);
    }

    static void pollCheckAppContextLocal(final Locale destLocale, final int index, final Utils.Consumer<Boolean> consumer) {
        Resources appResources = Utils.getApp().getResources();
        Configuration appConfig = appResources.getConfiguration();
        Locale appLocal = LanguageUtils.getLocal(appConfig);
        LanguageUtils.setLocal(appConfig, destLocale);
        Utils.getApp().getResources().updateConfiguration(appConfig, appResources.getDisplayMetrics());
        if (consumer == null) {
            return;
        }
        if (LanguageUtils.isSameLocale(appLocal, destLocale)) {
            consumer.accept(true);
        } else {
            if (index < 20) {
                UtilsBridge.runOnUiThreadDelayed(new Runnable(){

                    @Override
                    public void run() {
                        LanguageUtils.pollCheckAppContextLocal(destLocale, index + 1, consumer);
                    }
                }, 16L);
                return;
            }
            Log.e((String)"LanguageUtils", (String)"appLocal didn't update.");
            consumer.accept(false);
        }
    }

    public static Context attachBaseContext(Context context) {
        String spLocaleStr = UtilsBridge.getSpUtils4Utils().getString(KEY_LOCALE);
        if (TextUtils.isEmpty((CharSequence)spLocaleStr) || VALUE_FOLLOW_SYSTEM.equals(spLocaleStr)) {
            return context;
        }
        Locale settingsLocale = LanguageUtils.string2Locale(spLocaleStr);
        if (settingsLocale == null) {
            return context;
        }
        Resources resources = context.getResources();
        Configuration config = resources.getConfiguration();
        LanguageUtils.setLocal(config, settingsLocale);
        if (Build.VERSION.SDK_INT >= 17) {
            return context.createConfigurationContext(config);
        }
        resources.updateConfiguration(config, resources.getDisplayMetrics());
        return context;
    }

    static void applyLanguage(Activity activity) {
        String spLocale = UtilsBridge.getSpUtils4Utils().getString(KEY_LOCALE);
        if (TextUtils.isEmpty((CharSequence)spLocale)) {
            return;
        }
        Locale destLocal = VALUE_FOLLOW_SYSTEM.equals(spLocale) ? LanguageUtils.getLocal(Resources.getSystem().getConfiguration()) : LanguageUtils.string2Locale(spLocale);
        if (destLocal == null) {
            return;
        }
        LanguageUtils.updateConfiguration((Context)activity, destLocal);
        LanguageUtils.updateConfiguration((Context)Utils.getApp(), destLocal);
    }

    private static void updateConfiguration(Context context, Locale destLocal) {
        Resources resources = context.getResources();
        Configuration config = resources.getConfiguration();
        LanguageUtils.setLocal(config, destLocal);
        resources.updateConfiguration(config, resources.getDisplayMetrics());
    }

    private static String locale2String(Locale locale) {
        String localLanguage = locale.getLanguage();
        String localCountry = locale.getCountry();
        return localLanguage + "$" + localCountry;
    }

    private static Locale string2Locale(String str) {
        Locale locale = LanguageUtils.string2LocaleReal(str);
        if (locale == null) {
            Log.e((String)"LanguageUtils", (String)("The string of " + str + " is not in the correct format."));
            UtilsBridge.getSpUtils4Utils().remove(KEY_LOCALE);
        }
        return locale;
    }

    private static Locale string2LocaleReal(String str) {
        if (!LanguageUtils.isRightFormatLocalStr(str)) {
            return null;
        }
        try {
            int splitIndex = str.indexOf("$");
            return new Locale(str.substring(0, splitIndex), str.substring(splitIndex + 1));
        }
        catch (Exception ignore) {
            return null;
        }
    }

    private static boolean isRightFormatLocalStr(String localStr) {
        char[] chars = localStr.toCharArray();
        int count = 0;
        for (char c : chars) {
            if (c != '$') continue;
            if (count >= 1) {
                return false;
            }
            ++count;
        }
        return count == 1;
    }

    private static boolean isSameLocale(Locale l0, Locale l1) {
        return UtilsBridge.equals(l1.getLanguage(), l0.getLanguage()) && UtilsBridge.equals(l1.getCountry(), l0.getCountry());
    }

    private static Locale getLocal(Configuration configuration) {
        if (Build.VERSION.SDK_INT >= 24) {
            return configuration.getLocales().get(0);
        }
        return configuration.locale;
    }

    private static void setLocal(Configuration configuration, Locale locale) {
        if (Build.VERSION.SDK_INT >= 17) {
            configuration.setLocale(locale);
        } else {
            configuration.locale = locale;
        }
    }
}

