package com.ntt.core.service.supports.jumper;

import java.util.HashMap;

public class JumpConstants {

    public static HashMap<String, HashMap<String, String>> OLD_JUMP_MAP = new HashMap<>();

    static {
        //例子：codeName:老协议的code字段的Value，通过code的值来获取到对应的Map数据去获取PackageName和配置的数据
        OLD_JUMP_MAP.put("codeName", new HashMap<String, String>() {{
            put("packageName", "com.benew.ntt.r2");
        }});
        //专辑详情

    }

    public static HashMap<String, String> get(String codeName) {
        return OLD_JUMP_MAP.get(codeName);
    }

    public static final String NATIVE_ALBUM_DETAIL_CODE = "AlbumDetail";                            //专辑详情
    public static final String NATIVE_SEARCH_CONTENT_HOME_CODE = "SearchContentHome";               //全局搜索
    public static final String NATIVE_BROADCASTER_DETAIL_CODE = "BroadcasterDetail";                //主播详情
    public static final String NATIVE_EDIFY_PLAN_DETAIL_CODE = "EdifyPlanDetail";                   //熏陶课程详情
    public static final String NATIVE_ALBUM_CAT_HOME = "AlbumCatHome";                              //首页分类
    public static final String NATIVE_ANNOUNCER_HOME = "AnnouncerHome";                             //金牌主播
    public static final String NATIVE_EDIFY_HOME = "EdifyHome";                                     //熏陶广场
    public static final String NATIVE_EDIFY_ALBUM_DETAIL = "EdifyAlbumDetail";                      //熏陶专辑详情
    public static final String SCHEDULE_REPEAT_LIST = "ScheduleRepeatClassify";                     //日程复读类型列表
    public static final String YOUDAO_FINGER_DETECT = "YouDaoFingerDetect";                         //有道指尖查词
    public static final String MEMORY_HOME_CODE = "MemoryCourseMine";                               //超记主页
    public static final String SCHEDULE_EXECUTE_CODE = "ScheduleExecute";                           //日程管理熏陶或者打卡
    public static final String CARTOON_BOOK_DETAIL_CODE = "CartoonbookDetail";                      //绘本详情
    public static final String BOOK_LIBRARY_CODE = "BookLibrary";                                   //绘本馆
    public static final String READING_CODE = "Reading";                                            //读书


    /***** Package name ****/
    public static final String PACKAGE_NAME_LAUNCHER = "com.benew.nttr.launcher";
    public static final String PACKAGE_NAME_ALBUM = "com.benew.nttr.r2album";
    public static final String PACKAGE_NAME_PLAYER = "com.benew.nttr.player";
    public static final String PACKAGE_NAME_CORESERVICE = "com.ntt.core.service";
    public static final String PACKAGE_NAME_SCHEDULE = "com.benew.nttr.schedule"; //日程管理
    public static final String PACKAGE_NAME_MEMORY = "com.benew.nttr2.memory";
    public static final String PACKAGE_NAME_READING = "com.benew.ntt.reading";  //读书
    public static final String PACKAGE_NAME_SYNC_LEARNING = "com.benew.nttr2.synclearning"; //同步学
    public static final String PACKAGE_NAME_EYE_PROTECTION = "com.benew.nttr2.eyeprotection"; //护眼模式

    /**** Album Code***/
    public static final String SEARCH_MINE_ALBUM_HOME = "com.benew.nttr.search.ui.SearchMineAlbumActivity"; //搜索自己的专辑
    public static final String NEW_ALBUM_DETAIL_CODE = "com.benew.nttr.album.ui.activity.AlbumDetailActivity";
    public static final String NEW_EDIFY_PACKAGE_DETAIL_CODE = "com.benew.nttr.edify.ui.activity.EdifyPackageDetailActivity";
    public static final String NEW_EDIFY_ALBUM_DETAIL_CODE = "com.benew.nttr.edify.ui.activity.EdifyAlbumDetailActivity";
    public static final String NEW_ANNOUNCER_DETAIL_CODE = "com.benew.nttr.announcer.ui.activity.AnnouncerDetailActivity";
    public static final String NEW_ANNOUNCER_HOME_CODE = "com.benew.nttr.announcer.ui.activity.AnnouncerMainActivity";
    public static final String NEW_ALBUM_CATEGORY_CODE = "com.benew.nttr.album.ui.activity.AlbumCategoryActivity";
    public static final String NEW_EDIFY_LIST_CODE = "com.benew.nttr.edify.ui.activity.EdifyListActivity";
    public static final String NEW_SEARCH_MAIN_HOME = "com.benew.nttr.search.ui.SearchMainActivity";
    public static final String NEW_ALBUM_REPEAT_CODE = "com.benew.nttr.album.ui.activity.AlbumRepeatActivity";

    /*****Player Code *****/
    public static final String AUDIO_PLAYER_HOME = "com.benew.nttr.player.mvp.ui.activity.PlayerHomeActivity";
    public static final String VIDEO_PLAYER_HOME = "com.benew.nttr.player.mvp.ui.activity.VideoHomeActivity";


    /**
     * 设备绑定
     */
    public static final String BIND_DEVICE_HOME = "com.benew.nttr.launcher.mvp.ui.activity.RegisterQRCodeActivity";

    /**
     * CoreService Code
     */
    //有道指尖查词
    public static final String YOUDAO_FINGER_DETECT_HOME = "com.ntt.core.service.logic.finger.YouDaoMainActivity";

    /** 同步学 code **/
    // 同步学首页
    public static final String NEW_SYNCHROLOGY_HOME = "com.benew.nttr2.synclearning.ui.activity.BookHomeActivity";


    /**
     * Schedule Code
     */
    //日程管理熏陶和打卡
    public static final String SCHEDULE_EDIFY_OR_PUNCH = "com.benew.nttr.schedule.mvp.ui.activity.IntermediaryActivity";
    //添加日程
    public static final String SCHEDULE_CATEGORY = "com.benew.nttr.schedule.mvp.ui.activity.CategoryActivity";

    /**
     * Memory Code
     */
    public static final String MEMORY_HOME = "com.example.flutter_code.MainActivity";

    /**
     * Reading
     **/
    public static final String READING_LIBRARY_CONTENT = "com.benew.ntt.reading.mvp.view.LibraryContentActivity";//绘本详情
    public static final String READING_LIBRARY = "com.benew.ntt.reading.mvp.view.LibraryActivity";//绘本馆
    public static final String READING_READING = "com.benew.ntt.reading.mvp.view.VtstoryBaseActivity";//读书

    /**
     * eyeprotection 护眼模式
     */
    public static final String EYE_PROTECTION_HOME = "com.benew.nttr2.eyeprotection.EyeProtectionHomeActivity";
}
