package com.ntt.core.service.supports.log;

import android.content.Context;

import com.blankj.utilcode.util.AppUtils;
import com.blankj.utilcode.util.LogUtils;
import com.blankj.utilcode.util.TimeUtils;
import com.blankj.utilcode.util.Utils;
import com.tencent.mars.xlog.Log;
import com.tencent.mars.xlog.Xlog;

import java.io.File;
import java.util.Date;

public class XLog {
    static {
        System.loadLibrary("c++_shared");
        System.loadLibrary("marsxlog");
    }

    private static final long FILE_SIZE = 1024 * 1024;  //默认存储日志大小
    private static final String SDF_LOG_TIME = "yyyyMMdd"; //日志文件名日期格式

    private static boolean debug = false;

    private static String prefixLog;

    /**
     * 初始化
     *
     * @param context
     * @param isDebug
     */
    public static void init(Context context, boolean isDebug) {
        String logPath = Utils.getApp().getExternalCacheDir() + File.separator + "system" + File.separator + "log/";
        prefixLog = AppUtils.getAppPackageName();
        String cachePath = context.getFilesDir() + "/log";
        Xlog xlog = new Xlog();
        xlog.appenderOpen(Xlog.LEVEL_ALL, Xlog.AppednerModeAsync, cachePath, logPath, prefixLog, 0);
        xlog.setConsoleLogOpen(0, true);
        debug = isDebug;
        xlog.setMaxFileSize(0, FILE_SIZE);
        Log.setLogImp(xlog);
    }

    public static void d(final Object... contents) {
        String format = stringFormat(contents);
        Log.d("", format, contents);
        if (debug) {
            LogUtils.d(contents);
        }
    }

    private static String stringFormat(final Object... contents) {
        String format = "";
        for (Object o : contents) {
            format += "[%s] ";
        }
        return format;
    }

    /**
     * 同步log日志
     * 上传日志前需要调用来同步
     */
    public static void syncLog() {
        Log.appenderFlush();
    }


    /**
     * 获取当前日志路径
     *
     * @return
     */
    public static String getDayFileName() {
        String date = TimeUtils.date2String(new Date(), SDF_LOG_TIME);
        return prefixLog + "_" + date + ".xlog";
    }

    /**
     * 获取当前日志路径
     *
     * @return
     */
    public static String getDayFileName(Date date) {
        if (date == null) date = new Date();
        String dateStr = TimeUtils.date2String(date, SDF_LOG_TIME);
        return prefixLog + "_" + dateStr + ".xlog";
    }


    /**
     * 获取当前日志路径
     *
     * @return
     */
    public static String getDayFileName(String date) {
        return prefixLog + "_" + date + ".xlog";
    }

}
