/*
 * Decompiled with CFR 0.152.
 */
package io.getunleash.repository;

import com.google.gson.JsonSyntaxException;
import io.getunleash.UnleashException;
import io.getunleash.event.EventDispatcher;
import io.getunleash.event.UnleashEvent;
import io.getunleash.event.UnleashSubscriber;
import io.getunleash.lang.Nullable;
import io.getunleash.repository.FeatureCollection;
import io.getunleash.repository.JsonFeatureParser;
import io.getunleash.repository.SegmentCollection;
import io.getunleash.repository.ToggleBootstrapFileProvider;
import io.getunleash.repository.ToggleBootstrapProvider;
import io.getunleash.repository.ToggleCollection;
import io.getunleash.util.UnleashConfig;
import java.io.StringReader;
import java.util.Collections;

public class FeatureBootstrapHandler {
    private final EventDispatcher eventDispatcher;
    private final ToggleBootstrapProvider toggleBootstrapProvider;

    public FeatureBootstrapHandler(UnleashConfig unleashConfig) {
        this.toggleBootstrapProvider = unleashConfig.getToggleBootstrapProvider() != null ? unleashConfig.getToggleBootstrapProvider() : new ToggleBootstrapFileProvider();
        this.eventDispatcher = new EventDispatcher(unleashConfig);
    }

    public FeatureCollection parse(@Nullable String jsonString) {
        if (jsonString != null) {
            StringReader stringReader = new StringReader(jsonString);
            try {
                FeatureCollection featureCollection = JsonFeatureParser.fromJson(stringReader);
                this.eventDispatcher.dispatch(new FeatureBootstrapRead(featureCollection));
                FeatureCollection featureCollection2 = featureCollection;
                stringReader.close();
                return featureCollection2;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        stringReader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (JsonSyntaxException | IllegalStateException ise) {
                    this.eventDispatcher.dispatch(new UnleashException("Failed to read toggle bootstrap", ise));
                }
            }
        }
        return new FeatureCollection(new ToggleCollection(Collections.emptyList()), new SegmentCollection(Collections.emptyList()));
    }

    public FeatureCollection read() {
        if (this.toggleBootstrapProvider != null) {
            return this.parse(this.toggleBootstrapProvider.read());
        }
        return new FeatureCollection(new ToggleCollection(Collections.emptyList()), new SegmentCollection(Collections.emptyList()));
    }

    public static class FeatureBootstrapRead
    implements UnleashEvent {
        private final FeatureCollection featureCollection;

        public FeatureBootstrapRead(FeatureCollection featureCollection) {
            this.featureCollection = featureCollection;
        }

        @Override
        public void publishTo(UnleashSubscriber unleashSubscriber) {
            unleashSubscriber.featuresBootstrapped(this.featureCollection);
        }
    }
}

