/*
 * Decompiled with CFR 0.152.
 */
package io.getunleash;

import io.getunleash.ActivationStrategy;
import io.getunleash.FeatureDependency;
import io.getunleash.lang.Nullable;
import io.getunleash.variant.VariantDefinition;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

public final class FeatureToggle {
    private final String name;
    private final boolean enabled;
    private final List<ActivationStrategy> strategies;
    @Nullable
    private final List<VariantDefinition> variants;
    private final boolean impressionData;
    @Nullable
    private final List<FeatureDependency> dependencies;

    public FeatureToggle(String name, boolean enabled, List<ActivationStrategy> strategies) {
        this(name, enabled, strategies, Collections.emptyList(), false, Collections.emptyList());
    }

    public FeatureToggle(String name, boolean enabled, List<ActivationStrategy> strategies, List<VariantDefinition> variants) {
        this(name, enabled, strategies, variants, false, Collections.emptyList());
    }

    public FeatureToggle(String name, boolean enabled, List<ActivationStrategy> strategies, @Nullable List<VariantDefinition> variants, @Nullable Boolean impressionData) {
        this(name, enabled, strategies, variants, impressionData, Collections.emptyList());
    }

    public FeatureToggle(String name, boolean enabled, List<ActivationStrategy> strategies, @Nullable List<VariantDefinition> variants, @Nullable Boolean impressionData, @Nullable List<FeatureDependency> dependencies) {
        this.name = name;
        this.enabled = enabled;
        this.strategies = strategies;
        this.variants = variants;
        this.impressionData = impressionData != null ? impressionData : false;
        this.dependencies = dependencies;
    }

    public String getName() {
        return this.name;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Nonnull
    public List<ActivationStrategy> getStrategies() {
        if (this.strategies == null) {
            return Collections.emptyList();
        }
        return this.strategies;
    }

    @Nonnull
    public List<VariantDefinition> getVariants() {
        if (this.variants == null) {
            return Collections.emptyList();
        }
        return this.variants;
    }

    @Nonnull
    public List<FeatureDependency> getDependencies() {
        if (this.dependencies == null) {
            return Collections.emptyList();
        }
        return this.dependencies;
    }

    public boolean hasDependencies() {
        return this.dependencies != null && !this.dependencies.isEmpty();
    }

    @Nullable
    public boolean hasImpressionData() {
        return this.impressionData;
    }

    public String toString() {
        return "FeatureToggle{name='" + this.name + '\'' + ", enabled=" + this.enabled + ", strategies=" + this.strategies + ", variants=" + this.variants + ", impressionData=" + this.impressionData + ", dependencies=" + this.dependencies + '}';
    }
}

