/*
 * Decompiled with CFR 0.152.
 */
package org.unleash.features.aop;

import io.getunleash.Unleash;
import io.getunleash.UnleashContext;
import io.getunleash.Variant;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Repository;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.unleash.features.UnleashContextPreProcessor;
import org.unleash.features.annotation.FeatureVariant;
import org.unleash.features.annotation.FeatureVariants;
import org.unleash.features.annotation.Toggle;

@Component(value="feature.advisor")
public class FeatureAdvisor
implements MethodInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureAdvisor.class);
    private final Unleash unleash;
    private final ApplicationContext applicationContext;
    @Autowired(required=false)
    private List<UnleashContextPreProcessor> contextPreProcessors;

    public FeatureAdvisor(Unleash unleash, ApplicationContext applicationContext) {
        this.unleash = unleash;
        this.applicationContext = applicationContext;
    }

    public Object invoke(@NotNull MethodInvocation mi) throws Throwable {
        Toggle toggle = this.getToggleAnnotation(mi);
        if (toggle != null) {
            FeatureVariants variants = toggle.variants();
            String alterBean = toggle.alterBean();
            boolean usingAlterBean = StringUtils.hasText((String)alterBean);
            String executedBeanName = this.getExecutedBeanName(mi);
            if ((variants == null || variants.variants().length == 0) && alterBean.equals(executedBeanName)) {
                return this.invokePreProcessors(() -> this.invokeMethodInvocation(mi));
            }
            return this.invokePreProcessors(() -> this.checkForFeatureToggle(mi, toggle, alterBean, usingAlterBean, executedBeanName));
        }
        return mi.proceed();
    }

    private Object checkForFeatureToggle(@NotNull MethodInvocation mi, Toggle toggle, String alterBean, boolean usingAlterBean, String executedBeanName) {
        Object[] arguments = mi.getArguments();
        Optional<UnleashContext> contextOpt = Arrays.stream(arguments).filter(a -> a instanceof UnleashContext).map(a -> (UnleashContext)a).findFirst();
        boolean isFeatureToggled = this.check(toggle, contextOpt);
        if (isFeatureToggled) {
            String variantBeanName;
            String string = variantBeanName = toggle.variants().variants().length > 0 ? this.getVariantBeanName(toggle.name(), toggle.variants(), contextOpt) : null;
            if (!StringUtils.hasText(variantBeanName) && toggle.variants().variants().length > 1) {
                LOGGER.warn("Variants present in toggle annotation, but no variants present for feature. Falling back to the default bean");
                return this.invokeMethodInvocation(mi);
            }
            if (usingAlterBean && !StringUtils.hasText((String)variantBeanName)) {
                return this.invokeAlterBean(mi, alterBean);
            }
            if (StringUtils.hasText((String)variantBeanName)) {
                if (variantBeanName.equals(executedBeanName)) {
                    return this.invokeMethodInvocation(mi);
                }
                return this.invokeAlterBean(mi, variantBeanName);
            }
            throw new IllegalArgumentException("alterClass not yet supported");
        }
        return this.invokeMethodInvocation(mi);
    }

    private String getVariantBeanName(String featureName, FeatureVariants featureVariants, Optional<UnleashContext> contextOpt) {
        String alterBean;
        Variant variant = contextOpt.map(context -> this.unleash.getVariant(featureName, context)).orElse(this.unleash.getVariant(featureName));
        FeatureVariant[] featureVariantList = featureVariants.variants();
        if (variant != null && variant.isEnabled()) {
            Optional<FeatureVariant> featureVariantOpt = Arrays.stream(featureVariantList).filter(featureVariant -> featureVariant.name().equals(variant.getName())).findAny();
            alterBean = featureVariantOpt.map(FeatureVariant::variantBean).orElseGet(() -> {
                LOGGER.warn(String.format("No bean defined for %s in the @FeatureVariants annotation. FallbackBean %s being used", variant.getName(), featureVariants.fallbackBean()));
                return featureVariants.fallbackBean();
            });
            if (!StringUtils.hasText((String)alterBean)) {
                throw new IllegalArgumentException(String.format("No bean or fallback defined for %s in the @FeatureVariants annotation", variant.getName()));
            }
        } else {
            alterBean = null;
        }
        return alterBean;
    }

    private Object invokeMethodInvocation(MethodInvocation methodInvocation) {
        try {
            return methodInvocation.proceed();
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private Object invokePreProcessors(Supplier<Object> supplier) {
        Supplier<Object> returnValue = supplier;
        if (!CollectionUtils.isEmpty(this.contextPreProcessors)) {
            for (UnleashContextPreProcessor contextPreProcessor : this.contextPreProcessors) {
                returnValue = contextPreProcessor.preProcess(supplier);
            }
        }
        return returnValue.get();
    }

    private Object invokeAlterBean(MethodInvocation mi, String alterBeanName) {
        Method method = mi.getMethod();
        try {
            Object alterBean = this.applicationContext.getBean(alterBeanName);
            return method.invoke(alterBean, mi.getArguments());
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    private boolean check(Toggle toggle, Optional<UnleashContext> contextOpt) {
        String featureId = toggle.name();
        return contextOpt.map(context -> this.unleash.isEnabled(featureId, context)).orElseGet(() -> this.unleash.isEnabled(featureId));
    }

    private String getExecutedBeanName(MethodInvocation mi) {
        Class<?> targetClass = this.getExecutedClass(mi);
        Component component = targetClass.getAnnotation(Component.class);
        if (component != null) {
            return component.value();
        }
        Service service = targetClass.getAnnotation(Service.class);
        if (service != null) {
            return service.value();
        }
        Repository repository = targetClass.getAnnotation(Repository.class);
        if (repository != null) {
            return repository.value();
        }
        try {
            for (String beanName : this.applicationContext.getBeanDefinitionNames()) {
                Object bean = this.applicationContext.getBean(beanName);
                if (AopUtils.isJdkDynamicProxy((Object)bean)) {
                    bean = ((Advised)bean).getTargetSource().getTarget();
                }
                if (bean == null || !bean.getClass().isAssignableFrom(targetClass)) continue;
                return beanName;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        throw new IllegalArgumentException("Cannot read behind proxy target");
    }

    private Toggle getToggleAnnotation(MethodInvocation mi) {
        Method method = mi.getMethod();
        if (AnnotatedElementUtils.hasAnnotation((AnnotatedElement)method, Toggle.class)) {
            return (Toggle)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, Toggle.class);
        }
        Class<?> currentInterface = method.getDeclaringClass();
        if (AnnotatedElementUtils.hasAnnotation(currentInterface, Toggle.class)) {
            return (Toggle)AnnotatedElementUtils.findMergedAnnotation(currentInterface, Toggle.class);
        }
        Class<?> currentImplementation = this.getExecutedClass(mi);
        if (AnnotatedElementUtils.hasAnnotation(currentImplementation, Toggle.class)) {
            return (Toggle)AnnotatedElementUtils.findMergedAnnotation(currentImplementation, Toggle.class);
        }
        return null;
    }

    private Class<?> getExecutedClass(MethodInvocation mi) {
        Object ref = mi.getThis();
        Class executedClass = ref != null ? AopUtils.getTargetClass((Object)ref) : null;
        if (executedClass == null) {
            throw new IllegalArgumentException("Static methods cannot feature feature flipping");
        }
        return executedClass;
    }
}

