/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.log.android;

import android.app.Application;
import android.os.Build;
import android.util.Log;
import androidx.annotation.ChecksSdkIntAtLeast;
import io.getstream.log.Priority;
import io.getstream.log.StreamLog;
import io.getstream.log.StreamLogger;
import io.getstream.log.helper.StringifyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0003J*\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\f\u0010\u0010\u001a\u00020\u0003*\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/getstream/log/android/AndroidStreamLogger;", "Lio/getstream/log/StreamLogger;", "maxTagLength", "", "(I)V", "isNougatOrHigher", "", "log", "", "priority", "Lio/getstream/log/Priority;", "tag", "", "message", "throwable", "", "toAndroidPriority", "Companion", "stream-log-android_release"})
@SourceDebugExtension(value={"SMAP\nAndroidStreamLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidStreamLogger.kt\nio/getstream/log/android/AndroidStreamLogger\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,107:1\n1#2:108\n*E\n"})
public final class AndroidStreamLogger
implements StreamLogger {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int maxTagLength;
    public static final int DEFAULT_MAX_TAG_LENGTH = 23;

    public AndroidStreamLogger(int maxTagLength) {
        this.maxTagLength = maxTagLength;
    }

    public /* synthetic */ AndroidStreamLogger(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 23;
        }
        this(n);
    }

    /*
     * Unable to fully structure code
     */
    public void log(@NotNull Priority priority, @NotNull String tag, @NotNull String message, @Nullable Throwable throwable) {
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)priority, (String)"priority");
                Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                androidPriority = this.toAndroidPriority(priority);
                it = var8_6 = tag;
                $i$a$-takeIf-AndroidStreamLogger$log$androidTag$1 = false;
                v0 = var7_9 = (it.length() > this.maxTagLength && this.isNougatOrHigher() == false) != false ? var8_6 : null;
                if (var7_9 == null) ** GOTO lbl-1000
                v1 = var7_9.substring(0, this.maxTagLength);
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                var8_6 = v1;
                if (var8_6 != null) {
                    v2 = var8_6;
                } else lbl-1000:
                // 2 sources

                {
                    v2 = tag;
                }
                androidTag = v2;
                $this$log_u24lambda_u241 = Thread.currentThread();
                $i$a$-run-AndroidStreamLogger$log$thread$1 = false;
                thread = $this$log_u24lambda_u241.getName() + ':' + $this$log_u24lambda_u241.getId();
                composed = '(' + thread + ") " + message;
                v3 = throwable;
                if (v3 == null) break block5;
                it = v3;
                $i$a$-let-AndroidStreamLogger$log$finalMessage$1 = false;
                v4 = composed + '\n' + StringifyKt.stringify((Throwable)it);
                v3 = v4;
                if (v4 != null) break block6;
            }
            v3 = composed;
        }
        finalMessage = v3;
        Log.println((int)androidPriority, (String)androidTag, (String)finalMessage);
    }

    private final int toAndroidPriority(Priority $this$toAndroidPriority) {
        int n;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$toAndroidPriority.ordinal()]) {
            case 1: {
                n = 2;
                break;
            }
            case 2: {
                n = 3;
                break;
            }
            case 3: {
                n = 4;
                break;
            }
            case 4: {
                n = 5;
                break;
            }
            case 5: {
                n = 6;
                break;
            }
            case 6: {
                n = 7;
                break;
            }
            default: {
                n = 6;
            }
        }
        return n;
    }

    @ChecksSdkIntAtLeast(api=24)
    private final boolean isNougatOrHigher() {
        return Build.VERSION.SDK_INT >= 24;
    }

    public AndroidStreamLogger() {
        this(0, 1, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u0004J\"\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00072\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0005\u001a\u00020\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\b\u00a8\u0006\u0010"}, d2={"Lio/getstream/log/android/AndroidStreamLogger$Companion;", "", "()V", "DEFAULT_MAX_TAG_LENGTH", "", "isDebuggableApp", "", "Landroid/app/Application;", "(Landroid/app/Application;)Z", "install", "", "minPriority", "Lio/getstream/log/Priority;", "maxTagLength", "installOnDebuggableApp", "application", "stream-log-android_release"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isDebuggableApp(Application $this$isDebuggableApp) {
            return ($this$isDebuggableApp.getApplicationInfo().flags & 2) != 0;
        }

        public final void installOnDebuggableApp(@NotNull Application application, @NotNull Priority minPriority, int maxTagLength) {
            Intrinsics.checkNotNullParameter((Object)application, (String)"application");
            Intrinsics.checkNotNullParameter((Object)minPriority, (String)"minPriority");
            if (!StreamLog.isInstalled() && this.isDebuggableApp(application)) {
                StreamLog.setValidator((arg_0, arg_1) -> Companion.installOnDebuggableApp$lambda$0(minPriority, arg_0, arg_1));
                StreamLog.install((StreamLogger)new AndroidStreamLogger(maxTagLength));
            }
        }

        public static /* synthetic */ void installOnDebuggableApp$default(Companion companion, Application application, Priority priority, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                priority = Priority.DEBUG;
            }
            if ((n2 & 4) != 0) {
                n = 23;
            }
            companion.installOnDebuggableApp(application, priority, n);
        }

        public final void install(@NotNull Priority minPriority, int maxTagLength) {
            Intrinsics.checkNotNullParameter((Object)minPriority, (String)"minPriority");
            StreamLog.setValidator((arg_0, arg_1) -> Companion.install$lambda$1(minPriority, arg_0, arg_1));
            StreamLog.install((StreamLogger)new AndroidStreamLogger(maxTagLength));
        }

        public static /* synthetic */ void install$default(Companion companion, Priority priority, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                priority = Priority.DEBUG;
            }
            if ((n2 & 2) != 0) {
                n = 23;
            }
            companion.install(priority, n);
        }

        private static final boolean installOnDebuggableApp$lambda$0(Priority $minPriority, Priority priority, String string) {
            Intrinsics.checkNotNullParameter((Object)$minPriority, (String)"$minPriority");
            Intrinsics.checkNotNullParameter((Object)priority, (String)"priority");
            Intrinsics.checkNotNullParameter((Object)string, (String)"<anonymous parameter 1>");
            return priority.getLevel() >= $minPriority.getLevel();
        }

        private static final boolean install$lambda$1(Priority $minPriority, Priority priority, String string) {
            Intrinsics.checkNotNullParameter((Object)$minPriority, (String)"$minPriority");
            Intrinsics.checkNotNullParameter((Object)priority, (String)"priority");
            Intrinsics.checkNotNullParameter((Object)string, (String)"<anonymous parameter 1>");
            return priority.getLevel() >= $minPriority.getLevel();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Priority.values().length];
            try {
                nArray[Priority.VERBOSE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Priority.DEBUG.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Priority.INFO.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Priority.WARN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Priority.ERROR.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Priority.ASSERT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

