/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.java.services.framework;

import io.getstream.chat.java.services.framework.UserCall;
import io.getstream.chat.java.services.framework.UserServiceFactory;
import io.getstream.chat.java.services.framework.UserToken;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.concurrent.ConcurrentHashMap;
import retrofit2.Call;
import retrofit2.Retrofit;

final class UserServiceFactoryCall
implements UserServiceFactory {
    private final Retrofit retrofit;
    private final ConcurrentHashMap<Method, Type> responseTypeCache = new ConcurrentHashMap();

    public UserServiceFactoryCall(Retrofit retrofit) {
        this.retrofit = retrofit;
    }

    @Override
    public final <TService> TService create(Class<TService> svcClass, UserToken userToken) {
        Object delegate = this.retrofit.create(svcClass);
        return (TService)Proxy.newProxyInstance(svcClass.getClassLoader(), new Class[]{svcClass}, (proxy, method, args) -> {
            Object result = method.invoke(delegate, args);
            if (!(result instanceof Call)) {
                throw new IllegalStateException("Service method " + method.getDeclaringClass().getName() + "." + method.getName() + " must return retrofit2.Call<T> for user token injection. Actual return type: " + (result == null ? "null" : result.getClass().getName()));
            }
            Call call = (Call)result;
            Type responseType = this.responseTypeCache.computeIfAbsent(method, this::extractResponseType);
            return new UserCall(this.retrofit, userToken, call, responseType);
        });
    }

    private Type extractResponseType(Method method) {
        Type returnType = method.getGenericReturnType();
        if (!(returnType instanceof ParameterizedType)) {
            throw new IllegalStateException("Service method " + method.getDeclaringClass().getName() + "." + method.getName() + " must return Call<T> with a type parameter, not raw Call. Ensure the service interface is compiled with generic type information.");
        }
        ParameterizedType parameterizedType = (ParameterizedType)returnType;
        Type[] typeArguments = parameterizedType.getActualTypeArguments();
        if (typeArguments.length == 0) {
            throw new IllegalStateException("Service method " + method.getDeclaringClass().getName() + "." + method.getName() + " returns Call without type arguments. Expected Call<T>.");
        }
        return typeArguments[0];
    }
}

