/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.java.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.getstream.chat.java.models.framework.StreamRequest;
import io.getstream.chat.java.models.framework.StreamResponseObject;
import io.getstream.chat.java.services.ExportUsersService;
import io.getstream.chat.java.services.framework.Client;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import retrofit2.Call;

public class ExportUsers {
    @NotNull
    public static ExportUsersRequestData.ExportUsersRequest exportUsers(@NotNull List<String> userIds) {
        return new ExportUsersRequestData.ExportUsersRequest().userIds(userIds);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExportUsers)) {
            return false;
        }
        ExportUsers other = (ExportUsers)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExportUsers;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "ExportUsers()";
    }

    public static class ExportUsersResponse
    extends StreamResponseObject {
        @JsonProperty(value="task_id")
        @NotNull
        private String taskId;

        @NotNull
        public String getTaskId() {
            return this.taskId;
        }

        @JsonProperty(value="task_id")
        public void setTaskId(@NotNull String taskId) {
            if (taskId == null) {
                throw new NullPointerException("taskId is marked non-null but is null");
            }
            this.taskId = taskId;
        }

        @Override
        public String toString() {
            return "ExportUsers.ExportUsersResponse(taskId=" + this.getTaskId() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExportUsersResponse)) {
                return false;
            }
            ExportUsersResponse other = (ExportUsersResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$taskId = this.getTaskId();
            String other$taskId = other.getTaskId();
            return !(this$taskId == null ? other$taskId != null : !this$taskId.equals(other$taskId));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ExportUsersResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $taskId = this.getTaskId();
            result = result * 59 + ($taskId == null ? 43 : $taskId.hashCode());
            return result;
        }
    }

    public static class ExportUsersRequestData {
        @JsonProperty(value="user_ids")
        private List<String> userIds;

        ExportUsersRequestData(List<String> userIds) {
            this.userIds = userIds;
        }

        public List<String> getUserIds() {
            return this.userIds;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExportUsersRequestData)) {
                return false;
            }
            ExportUsersRequestData other = (ExportUsersRequestData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<String> this$userIds = this.getUserIds();
            List<String> other$userIds = other.getUserIds();
            return !(this$userIds == null ? other$userIds != null : !((Object)this$userIds).equals(other$userIds));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ExportUsersRequestData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $userIds = this.getUserIds();
            result = result * 59 + ($userIds == null ? 43 : ((Object)$userIds).hashCode());
            return result;
        }

        public static class ExportUsersRequest
        extends StreamRequest<ExportUsersResponse> {
            private List<String> userIds;

            @Override
            protected Call<ExportUsersResponse> generateCall(Client client) {
                return client.create(ExportUsersService.class).exportUsers(this.internalBuild());
            }

            ExportUsersRequest() {
            }

            @JsonProperty(value="user_ids")
            public ExportUsersRequest userIds(List<String> userIds) {
                this.userIds = userIds;
                return this;
            }

            public ExportUsersRequestData internalBuild() {
                return new ExportUsersRequestData(this.userIds);
            }

            public String toString() {
                return "ExportUsers.ExportUsersRequestData.ExportUsersRequest(userIds=" + String.valueOf(this.userIds) + ")";
            }
        }
    }
}

