/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.java.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.getstream.chat.java.models.framework.StreamRequest;
import io.getstream.chat.java.models.framework.StreamResponseObject;
import io.getstream.chat.java.services.UnreadCountsService;
import io.getstream.chat.java.services.framework.Client;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;

public class UnreadCounts {
    @NotNull
    public static UnreadCountsGetRequestData.UnreadCountsGetRequest get(@NotNull String userId) {
        return new UnreadCountsGetRequestData.UnreadCountsGetRequest(userId);
    }

    @NotNull
    public static UnreadCountsBatchRequestData.UnreadCountsBatchRequest batch() {
        return new UnreadCountsBatchRequestData.UnreadCountsBatchRequest();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UnreadCounts)) {
            return false;
        }
        UnreadCounts other = (UnreadCounts)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof UnreadCounts;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "UnreadCounts()";
    }

    public static class UnreadCountsBatchRequestData {
        @JsonProperty(value="user_ids")
        @NotNull
        private List<String> userIds;

        UnreadCountsBatchRequestData(@NotNull List<String> userIds) {
            if (userIds == null) {
                throw new NullPointerException("userIds is marked non-null but is null");
            }
            this.userIds = userIds;
        }

        public static class UnreadCountsBatchRequest
        extends StreamRequest<UnreadCountsBatchResponse> {
            private List<String> userIds;

            private UnreadCountsBatchRequest() {
            }

            @Override
            protected Call<UnreadCountsBatchResponse> generateCall(Client client) {
                return client.create(UnreadCountsService.class).batch(this.internalBuild());
            }

            @JsonProperty(value="user_ids")
            public UnreadCountsBatchRequest userIds(@NotNull List<String> userIds) {
                if (userIds == null) {
                    throw new NullPointerException("userIds is marked non-null but is null");
                }
                this.userIds = userIds;
                return this;
            }

            public UnreadCountsBatchRequestData internalBuild() {
                return new UnreadCountsBatchRequestData(this.userIds);
            }

            public String toString() {
                return "UnreadCounts.UnreadCountsBatchRequestData.UnreadCountsBatchRequest(userIds=" + String.valueOf(this.userIds) + ")";
            }
        }
    }

    public static class UnreadCountsBatchResponse
    extends StreamResponseObject {
        @JsonProperty(value="counts_by_user")
        @NotNull
        private Map<String, UnreadCountsResponse> countsByUser;

        @NotNull
        public Map<String, UnreadCountsResponse> getCountsByUser() {
            return this.countsByUser;
        }

        @JsonProperty(value="counts_by_user")
        public void setCountsByUser(@NotNull Map<String, UnreadCountsResponse> countsByUser) {
            if (countsByUser == null) {
                throw new NullPointerException("countsByUser is marked non-null but is null");
            }
            this.countsByUser = countsByUser;
        }

        @Override
        public String toString() {
            return "UnreadCounts.UnreadCountsBatchResponse(countsByUser=" + String.valueOf(this.getCountsByUser()) + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UnreadCountsBatchResponse)) {
                return false;
            }
            UnreadCountsBatchResponse other = (UnreadCountsBatchResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Map<String, UnreadCountsResponse> this$countsByUser = this.getCountsByUser();
            Map<String, UnreadCountsResponse> other$countsByUser = other.getCountsByUser();
            return !(this$countsByUser == null ? other$countsByUser != null : !((Object)this$countsByUser).equals(other$countsByUser));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof UnreadCountsBatchResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Map<String, UnreadCountsResponse> $countsByUser = this.getCountsByUser();
            result = result * 59 + ($countsByUser == null ? 43 : ((Object)$countsByUser).hashCode());
            return result;
        }
    }

    public static class UnreadCountsGetRequestData {
        @JsonProperty(value="user_id")
        @Nullable
        private String userId;

        UnreadCountsGetRequestData(@Nullable String userId) {
            this.userId = userId;
        }

        public static class UnreadCountsGetRequest
        extends StreamRequest<UnreadCountsResponse> {
            private String userId;

            private UnreadCountsGetRequest(@NotNull String userId) {
                this.userId = userId;
            }

            @Override
            protected Call<UnreadCountsResponse> generateCall(Client client) {
                return client.create(UnreadCountsService.class).get(this.userId);
            }

            @JsonProperty(value="user_id")
            public UnreadCountsGetRequest userId(@Nullable String userId) {
                this.userId = userId;
                return this;
            }

            public UnreadCountsGetRequestData internalBuild() {
                return new UnreadCountsGetRequestData(this.userId);
            }

            public String toString() {
                return "UnreadCounts.UnreadCountsGetRequestData.UnreadCountsGetRequest(userId=" + this.userId + ")";
            }
        }
    }

    public static class UnreadCountsResponse
    extends StreamResponseObject {
        @JsonProperty(value="total_unread_count")
        @NotNull
        private Integer totalUnreadCount;
        @JsonProperty(value="total_unread_threads_count")
        @NotNull
        private Integer totalUnreadThreadsCount;
        @JsonProperty(value="channels")
        @Nullable
        private List<UnreadCountsChannel> channels;
        @JsonProperty(value="channel_type")
        @Nullable
        private List<UnreadCountsChannelType> channelType;
        @JsonProperty(value="threads")
        @Nullable
        private List<UnreadCountsThread> threads;

        @NotNull
        public Integer getTotalUnreadCount() {
            return this.totalUnreadCount;
        }

        @NotNull
        public Integer getTotalUnreadThreadsCount() {
            return this.totalUnreadThreadsCount;
        }

        @Nullable
        public List<UnreadCountsChannel> getChannels() {
            return this.channels;
        }

        @Nullable
        public List<UnreadCountsChannelType> getChannelType() {
            return this.channelType;
        }

        @Nullable
        public List<UnreadCountsThread> getThreads() {
            return this.threads;
        }

        @JsonProperty(value="total_unread_count")
        public void setTotalUnreadCount(@NotNull Integer totalUnreadCount) {
            if (totalUnreadCount == null) {
                throw new NullPointerException("totalUnreadCount is marked non-null but is null");
            }
            this.totalUnreadCount = totalUnreadCount;
        }

        @JsonProperty(value="total_unread_threads_count")
        public void setTotalUnreadThreadsCount(@NotNull Integer totalUnreadThreadsCount) {
            if (totalUnreadThreadsCount == null) {
                throw new NullPointerException("totalUnreadThreadsCount is marked non-null but is null");
            }
            this.totalUnreadThreadsCount = totalUnreadThreadsCount;
        }

        @JsonProperty(value="channels")
        public void setChannels(@Nullable List<UnreadCountsChannel> channels) {
            this.channels = channels;
        }

        @JsonProperty(value="channel_type")
        public void setChannelType(@Nullable List<UnreadCountsChannelType> channelType) {
            this.channelType = channelType;
        }

        @JsonProperty(value="threads")
        public void setThreads(@Nullable List<UnreadCountsThread> threads) {
            this.threads = threads;
        }

        @Override
        public String toString() {
            return "UnreadCounts.UnreadCountsResponse(totalUnreadCount=" + this.getTotalUnreadCount() + ", totalUnreadThreadsCount=" + this.getTotalUnreadThreadsCount() + ", channels=" + String.valueOf(this.getChannels()) + ", channelType=" + String.valueOf(this.getChannelType()) + ", threads=" + String.valueOf(this.getThreads()) + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UnreadCountsResponse)) {
                return false;
            }
            UnreadCountsResponse other = (UnreadCountsResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Integer this$totalUnreadCount = this.getTotalUnreadCount();
            Integer other$totalUnreadCount = other.getTotalUnreadCount();
            if (this$totalUnreadCount == null ? other$totalUnreadCount != null : !((Object)this$totalUnreadCount).equals(other$totalUnreadCount)) {
                return false;
            }
            Integer this$totalUnreadThreadsCount = this.getTotalUnreadThreadsCount();
            Integer other$totalUnreadThreadsCount = other.getTotalUnreadThreadsCount();
            if (this$totalUnreadThreadsCount == null ? other$totalUnreadThreadsCount != null : !((Object)this$totalUnreadThreadsCount).equals(other$totalUnreadThreadsCount)) {
                return false;
            }
            List<UnreadCountsChannel> this$channels = this.getChannels();
            List<UnreadCountsChannel> other$channels = other.getChannels();
            if (this$channels == null ? other$channels != null : !((Object)this$channels).equals(other$channels)) {
                return false;
            }
            List<UnreadCountsChannelType> this$channelType = this.getChannelType();
            List<UnreadCountsChannelType> other$channelType = other.getChannelType();
            if (this$channelType == null ? other$channelType != null : !((Object)this$channelType).equals(other$channelType)) {
                return false;
            }
            List<UnreadCountsThread> this$threads = this.getThreads();
            List<UnreadCountsThread> other$threads = other.getThreads();
            return !(this$threads == null ? other$threads != null : !((Object)this$threads).equals(other$threads));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof UnreadCountsResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Integer $totalUnreadCount = this.getTotalUnreadCount();
            result = result * 59 + ($totalUnreadCount == null ? 43 : ((Object)$totalUnreadCount).hashCode());
            Integer $totalUnreadThreadsCount = this.getTotalUnreadThreadsCount();
            result = result * 59 + ($totalUnreadThreadsCount == null ? 43 : ((Object)$totalUnreadThreadsCount).hashCode());
            List<UnreadCountsChannel> $channels = this.getChannels();
            result = result * 59 + ($channels == null ? 43 : ((Object)$channels).hashCode());
            List<UnreadCountsChannelType> $channelType = this.getChannelType();
            result = result * 59 + ($channelType == null ? 43 : ((Object)$channelType).hashCode());
            List<UnreadCountsThread> $threads = this.getThreads();
            result = result * 59 + ($threads == null ? 43 : ((Object)$threads).hashCode());
            return result;
        }
    }

    public static class UnreadCountsThread {
        @JsonProperty(value="unread_count")
        @NotNull
        private Integer unreadCount;
        @JsonProperty(value="last_read")
        @NotNull
        private Date lastRead;
        @JsonProperty(value="last_read_message_id")
        @Nullable
        private String lastReadMessageId;
        @JsonProperty(value="parent_message_id")
        @Nullable
        private String parentMessageId;

        @NotNull
        public Integer getUnreadCount() {
            return this.unreadCount;
        }

        @NotNull
        public Date getLastRead() {
            return this.lastRead;
        }

        @Nullable
        public String getLastReadMessageId() {
            return this.lastReadMessageId;
        }

        @Nullable
        public String getParentMessageId() {
            return this.parentMessageId;
        }

        @JsonProperty(value="unread_count")
        public void setUnreadCount(@NotNull Integer unreadCount) {
            if (unreadCount == null) {
                throw new NullPointerException("unreadCount is marked non-null but is null");
            }
            this.unreadCount = unreadCount;
        }

        @JsonProperty(value="last_read")
        public void setLastRead(@NotNull Date lastRead) {
            if (lastRead == null) {
                throw new NullPointerException("lastRead is marked non-null but is null");
            }
            this.lastRead = lastRead;
        }

        @JsonProperty(value="last_read_message_id")
        public void setLastReadMessageId(@Nullable String lastReadMessageId) {
            this.lastReadMessageId = lastReadMessageId;
        }

        @JsonProperty(value="parent_message_id")
        public void setParentMessageId(@Nullable String parentMessageId) {
            this.parentMessageId = parentMessageId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UnreadCountsThread)) {
                return false;
            }
            UnreadCountsThread other = (UnreadCountsThread)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$unreadCount = this.getUnreadCount();
            Integer other$unreadCount = other.getUnreadCount();
            if (this$unreadCount == null ? other$unreadCount != null : !((Object)this$unreadCount).equals(other$unreadCount)) {
                return false;
            }
            Date this$lastRead = this.getLastRead();
            Date other$lastRead = other.getLastRead();
            if (this$lastRead == null ? other$lastRead != null : !((Object)this$lastRead).equals(other$lastRead)) {
                return false;
            }
            String this$lastReadMessageId = this.getLastReadMessageId();
            String other$lastReadMessageId = other.getLastReadMessageId();
            if (this$lastReadMessageId == null ? other$lastReadMessageId != null : !this$lastReadMessageId.equals(other$lastReadMessageId)) {
                return false;
            }
            String this$parentMessageId = this.getParentMessageId();
            String other$parentMessageId = other.getParentMessageId();
            return !(this$parentMessageId == null ? other$parentMessageId != null : !this$parentMessageId.equals(other$parentMessageId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof UnreadCountsThread;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $unreadCount = this.getUnreadCount();
            result = result * 59 + ($unreadCount == null ? 43 : ((Object)$unreadCount).hashCode());
            Date $lastRead = this.getLastRead();
            result = result * 59 + ($lastRead == null ? 43 : ((Object)$lastRead).hashCode());
            String $lastReadMessageId = this.getLastReadMessageId();
            result = result * 59 + ($lastReadMessageId == null ? 43 : $lastReadMessageId.hashCode());
            String $parentMessageId = this.getParentMessageId();
            result = result * 59 + ($parentMessageId == null ? 43 : $parentMessageId.hashCode());
            return result;
        }

        public String toString() {
            return "UnreadCounts.UnreadCountsThread(unreadCount=" + this.getUnreadCount() + ", lastRead=" + String.valueOf(this.getLastRead()) + ", lastReadMessageId=" + this.getLastReadMessageId() + ", parentMessageId=" + this.getParentMessageId() + ")";
        }
    }

    public static class UnreadCountsChannelType {
        @JsonProperty(value="channel_type")
        @NotNull
        private String channelType;
        @JsonProperty(value="channel_count")
        @NotNull
        private String channelCount;
        @JsonProperty(value="unread_count")
        @NotNull
        private Integer unreadCount;

        @NotNull
        public String getChannelType() {
            return this.channelType;
        }

        @NotNull
        public String getChannelCount() {
            return this.channelCount;
        }

        @NotNull
        public Integer getUnreadCount() {
            return this.unreadCount;
        }

        @JsonProperty(value="channel_type")
        public void setChannelType(@NotNull String channelType) {
            if (channelType == null) {
                throw new NullPointerException("channelType is marked non-null but is null");
            }
            this.channelType = channelType;
        }

        @JsonProperty(value="channel_count")
        public void setChannelCount(@NotNull String channelCount) {
            if (channelCount == null) {
                throw new NullPointerException("channelCount is marked non-null but is null");
            }
            this.channelCount = channelCount;
        }

        @JsonProperty(value="unread_count")
        public void setUnreadCount(@NotNull Integer unreadCount) {
            if (unreadCount == null) {
                throw new NullPointerException("unreadCount is marked non-null but is null");
            }
            this.unreadCount = unreadCount;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UnreadCountsChannelType)) {
                return false;
            }
            UnreadCountsChannelType other = (UnreadCountsChannelType)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$unreadCount = this.getUnreadCount();
            Integer other$unreadCount = other.getUnreadCount();
            if (this$unreadCount == null ? other$unreadCount != null : !((Object)this$unreadCount).equals(other$unreadCount)) {
                return false;
            }
            String this$channelType = this.getChannelType();
            String other$channelType = other.getChannelType();
            if (this$channelType == null ? other$channelType != null : !this$channelType.equals(other$channelType)) {
                return false;
            }
            String this$channelCount = this.getChannelCount();
            String other$channelCount = other.getChannelCount();
            return !(this$channelCount == null ? other$channelCount != null : !this$channelCount.equals(other$channelCount));
        }

        protected boolean canEqual(Object other) {
            return other instanceof UnreadCountsChannelType;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $unreadCount = this.getUnreadCount();
            result = result * 59 + ($unreadCount == null ? 43 : ((Object)$unreadCount).hashCode());
            String $channelType = this.getChannelType();
            result = result * 59 + ($channelType == null ? 43 : $channelType.hashCode());
            String $channelCount = this.getChannelCount();
            result = result * 59 + ($channelCount == null ? 43 : $channelCount.hashCode());
            return result;
        }

        public String toString() {
            return "UnreadCounts.UnreadCountsChannelType(channelType=" + this.getChannelType() + ", channelCount=" + this.getChannelCount() + ", unreadCount=" + this.getUnreadCount() + ")";
        }
    }

    public static class UnreadCountsChannel {
        @JsonProperty(value="channel_id")
        @NotNull
        private String channelId;
        @JsonProperty(value="unread_count")
        @NotNull
        private Integer unreadCount;
        @JsonProperty(value="last_read")
        @NotNull
        private Date lastRead;

        @NotNull
        public String getChannelId() {
            return this.channelId;
        }

        @NotNull
        public Integer getUnreadCount() {
            return this.unreadCount;
        }

        @NotNull
        public Date getLastRead() {
            return this.lastRead;
        }

        @JsonProperty(value="channel_id")
        public void setChannelId(@NotNull String channelId) {
            if (channelId == null) {
                throw new NullPointerException("channelId is marked non-null but is null");
            }
            this.channelId = channelId;
        }

        @JsonProperty(value="unread_count")
        public void setUnreadCount(@NotNull Integer unreadCount) {
            if (unreadCount == null) {
                throw new NullPointerException("unreadCount is marked non-null but is null");
            }
            this.unreadCount = unreadCount;
        }

        @JsonProperty(value="last_read")
        public void setLastRead(@NotNull Date lastRead) {
            if (lastRead == null) {
                throw new NullPointerException("lastRead is marked non-null but is null");
            }
            this.lastRead = lastRead;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UnreadCountsChannel)) {
                return false;
            }
            UnreadCountsChannel other = (UnreadCountsChannel)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$unreadCount = this.getUnreadCount();
            Integer other$unreadCount = other.getUnreadCount();
            if (this$unreadCount == null ? other$unreadCount != null : !((Object)this$unreadCount).equals(other$unreadCount)) {
                return false;
            }
            String this$channelId = this.getChannelId();
            String other$channelId = other.getChannelId();
            if (this$channelId == null ? other$channelId != null : !this$channelId.equals(other$channelId)) {
                return false;
            }
            Date this$lastRead = this.getLastRead();
            Date other$lastRead = other.getLastRead();
            return !(this$lastRead == null ? other$lastRead != null : !((Object)this$lastRead).equals(other$lastRead));
        }

        protected boolean canEqual(Object other) {
            return other instanceof UnreadCountsChannel;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $unreadCount = this.getUnreadCount();
            result = result * 59 + ($unreadCount == null ? 43 : ((Object)$unreadCount).hashCode());
            String $channelId = this.getChannelId();
            result = result * 59 + ($channelId == null ? 43 : $channelId.hashCode());
            Date $lastRead = this.getLastRead();
            result = result * 59 + ($lastRead == null ? 43 : ((Object)$lastRead).hashCode());
            return result;
        }

        public String toString() {
            return "UnreadCounts.UnreadCountsChannel(channelId=" + this.getChannelId() + ", unreadCount=" + this.getUnreadCount() + ", lastRead=" + String.valueOf(this.getLastRead()) + ")";
        }
    }
}

